//myApp.cpp

#include "themAll.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myroColour.h"
#include "myApp.h"
#include "XmyApp.h"
#include "DtinySnooze.h"
#include "Dreopen.h"
#include "myButton.h"
#include "stringGadget.h"
#include "uInt32Gadget.h"
#include "Xwarning.h"
#include "fontData.h"
#include "layoutMatrix.h"
#include "colorWell.h"
#include "myColorControl.h"
#include "myTextView.h"
#include "windowGuts.h"
#include "myCheckBox.h"
#include "prefPanelWindow.h"
#include "titleWindow.h"
#include "designButtons.h"
#include "listViewWindow.h"
#include "editUniverseWindow.h"
#include "editUniversalConstantsWindow.h"
#include "bottomLine.h"
#include <memory>
#include "Xthings.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "dataNode.h"
#include "dataList.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "Xunique.h"



MyApp	::	MyApp()
		:	BApplication("application/x-EFM5.SoIEditGUI"),//AppSignature if it changes here, change it in strings.r
			pTitleWindow(NULL),
			pEditUniverseWindow(NULL),
			pEditUniversalConstantsWindow(NULL),
			bEditingUniverse(false)
			
{
//BResources * appResources = AppResources();
//size_t len;
//char * str = (char *)appResources->FindResource('CSTR', "name", &len);
//free (str);
	try
	{
		for (	int32 i = 0;i < NUMTHINGS;i++) 
		{
			IDs[i] = 0;
			dataListGlobal[i] = new DataList(i);
		}
		universe = new Universe;
		universalConstants = new UniversalConstants;
		galaxy = new Galaxy;
		species = new Species;
		blackhole = new Blackhole;
		wormhole = new Wormhole;
		star = new Star;
		ship = new Ship;
		engine = new Engine;
		shipWeapon = new ShipWeapon;
		shipShield = new ShipShield;
		planet = new Planet;
		planetWeapon = new PlanetWeapon;
		planetShield = new PlanetShield;
		factory = new Factory;
		mine = new Mine;
		compound = new Compound;
		element = new Element;
	}
	catch (...)
	{
		warning(FailCreateAll);
		throw;
	}
	Preferences appsPreferences(PrefSignature);
	PreferenceSet appsPreferenceSet(	appsPreferences,  
										"hierarchical/extendable/settings", 
										true);
	if (appsPreferences.InitCheck())
	{
		puts(PrefFailInit);
		exit(1);
	}
	if (appsPreferenceSet.InitCheck())
	{
		puts(PrefFailGetSettings);
		exit(2);
	}		
	BRect	screenResolutionRect;
		{//I do screen like this so it goes away fast
			BScreen	screen(B_MAIN_SCREEN_ID);
			if(!screen.IsValid()) 
			{//may not be valid, if not, this is not a critical app--bail out as best we can
				puts("!screen.IsValid()");
				exit(3);
			}
			screenResolutionRect = screen.Frame();
		}
	BRect windowPrefArea;
	const void * windowPrefAreaData;
	ssize_t windowPrefAreaSize;
	uint32 windowPrefAreaType = '    ';
	if (	appsPreferenceSet.GetData(	"TitleWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
					22, 
					screenResolutionRect.right - 17,
					screenResolutionRect.bottom - 37);
					//the - 17 and - 37 were determined based upon trial and error
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredTitleWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditUniverseFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditUniverseWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditUniversalConstantsFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
					22, 
					screenResolutionRect.right - 17,
					screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditUniversalConstantsWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditSpeciesFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditSpeciesWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditHoleAffectsFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditHoleAffectsWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditWormholeFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditWormholeWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditBlackholeFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditBlackholeWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditGalaxyFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditGalaxyWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditStarFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditStarWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditPlanetFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditPlanetWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditPlanetWeaponFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditPlanetWeaponWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditPlanetShieldFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditPlanetShieldWindowRect(windowPrefArea);
	
	if (	appsPreferenceSet.GetData(	"EditShipFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditShipWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditShipWeaponFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditShipWeaponWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"EditShipShieldFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditShipShieldWindowRect(windowPrefArea);
		if (	appsPreferenceSet.GetData(	"EditEngineFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditEngineWindowRect(windowPrefArea);
		if (	appsPreferenceSet.GetData(	"EditFactoryFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditFactoryWindowRect(windowPrefArea);
		if (	appsPreferenceSet.GetData(	"EditMineFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditMineWindowRect(windowPrefArea);
		if (	appsPreferenceSet.GetData(	"EditCompoundFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditCompoundWindowRect(windowPrefArea);
		if (	appsPreferenceSet.GetData(	"EditElementFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredEditElementWindowRect(windowPrefArea);
}//end


MyApp	::	~MyApp() 
{
	//left blank
}//end


bool
MyApp	::	QuitRequested(	void) 
{
	if (pTitleWindow)
	{
		pTitleWindow->PostMessage(B_QUIT_REQUESTED);
	}
	if (pEditUniverseWindow)
	{
		pEditUniverseWindow->PostMessage(B_QUIT_REQUESTED);
	}
	if (pEditUniversalConstantsWindow)
	{
		pEditUniversalConstantsWindow->PostMessage(B_QUIT_REQUESTED);
	}
	return(BApplication	::	QuitRequested());
}//end


//all apps will need a main window to display on launch
void 
MyApp	::	ReadyToRun(				void) 
{
	try 
	{
		BRect holdRect;
		GetPreferredTitleWindowRect(&holdRect);
		pTitleWindow = new TitleWindow(	holdRect,
										TitleWindowTitle,
										"titleWindow",
										"TitleWindowFrame");
		pTitleWindow->Initialize();
	}
	catch (...) 
	{
		warning(FailTitleWindow);
		myApp->PostMessage(B_QUIT_REQUESTED);
	}
}//end


void 
MyApp	::	MessageReceived(		BMessage *	message) 
{
	switch(message->what)
	{
		case REOPEN_TITLE:
		{
			int timeOut = 0;
			while (pTitleWindow && (timeOut < 50)) 
			{
				if (pTitleWindow->PostMessage(B_QUIT_REQUESTED))
				{
					pTitleWindow = NULL;
				}
				else
				{
					snooze(TINYSNOOZE);
					timeOut++;
				}
			}
			if (!pTitleWindow) 
			{
				try 
				{
					BRect holdRect;
					GetPreferredTitleWindowRect(&holdRect);
					pTitleWindow = new TitleWindow(	holdRect,
													TitleWindowTitle,
													"titleWindow",
													"TitleWindowFrame");
					pTitleWindow->Initialize();
				}
				catch (...)
				{
					warning(FailTitleWindow);
					myApp->PostMessage(B_QUIT_REQUESTED);
				}
			}
			if (pEditUniversalConstantsWindow) 
			{
				timeOut = 0;
				while (pEditUniverseWindow && (timeOut < 50)) 
				{
					pEditUniverseWindow->PostMessage(BLDONE);
					snooze(TINYSNOOZE);
					timeOut++;
				}
				if (!pEditUniverseWindow) 
				{
					OpenEditor(NULL);
				}
				timeOut = 0;
				while (pEditUniversalConstantsWindow && (timeOut < 50)) 
				{
					pEditUniversalConstantsWindow->PostMessage(BLDONE);
					snooze(TINYSNOOZE);
					timeOut++;
				}
				if (!pEditUniversalConstantsWindow) 
				{
					try 
					{
						BRect holdRect;
						GetPreferredEditUniversalConstantsWindowRect(&holdRect);
						pEditUniversalConstantsWindow = new EditUniversalConstantsWindow(	holdRect,
																							EditUniversalConstantsWindowTitle,
																							"UniversalConstantsView",
																							"UniversalConstantsFrame");
						pEditUniversalConstantsWindow->Initialize();
					}
					catch (...)
					{
						warning(FailEditUniversalConstantsWindow);
						myApp->PostMessage(B_QUIT_REQUESTED);
					}
				}
			}
			myPrefs->bPrefChangesMade = false;
			if (myPrefs->pPrefPanelWindow)
			{
				timeOut = 0;
				while (myPrefs->pPrefPanelWindow && (timeOut < 50)) 
				{
					myPrefs->pPrefPanelWindow->PostMessage(B_QUIT_REQUESTED);
					snooze(TINYSNOOZE);
					timeOut++;
				}
				if (!myPrefs->pPrefPanelWindow) 
				{
					myPrefs->OpenPreferencesPanel();
				}
			}
		break;
		}
//		case 0:	//I am wondering about this
//				//it only shows up when app is launched from 
//				//tracker and resources are present in the file
//				//when run via double-click on the app icon I get a message here
//				//with a message->what == zero
//			warning("got unexpected zero msg in app\n");
//		break;
		case BLNEW:
		{
			if (pEditUniverseWindow) 
			{
				if (pEditUniverseWindow->PostMessage(B_QUIT_REQUESTED))
				{
					pEditUniverseWindow = NULL;
				}
			}
			if (!pEditUniverseWindow) 
			{
				if (!OpenEditor(NULL))
				{
					myApp->PostMessage(B_QUIT_REQUESTED);
				}
			}
		break;
		}
		default:
			//I don't expect any msgs here
			//warning("got unexpected msg in app\n");
		break;
	}
}//end


void
MyApp	::	GetPreferredEditUniverseWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditUniverseWindowRect;
}//end


void
MyApp	::	SetPreferredEditUniverseWindowRect(	const BRect paramWindowRect)
{
	preferredEditUniverseWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditElementWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditElementWindowRect;
}//end


void
MyApp	::	SetPreferredEditElementWindowRect(	const BRect paramWindowRect)
{
	preferredEditElementWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditCompoundWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditCompoundWindowRect;
}//end


void
MyApp	::	SetPreferredEditCompoundWindowRect(	const BRect paramWindowRect)
{
	preferredEditCompoundWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditMineWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditMineWindowRect;
}//end


void
MyApp	::	SetPreferredEditMineWindowRect(	const BRect paramWindowRect)
{
	preferredEditMineWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditFactoryWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditFactoryWindowRect;
}//end


void
MyApp	::	SetPreferredEditFactoryWindowRect(	const BRect paramWindowRect)
{
	preferredEditFactoryWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditEngineWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditEngineWindowRect;
}//end


void
MyApp	::	SetPreferredEditEngineWindowRect(	const BRect paramWindowRect)
{
	preferredEditEngineWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditPlanetWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditPlanetWindowRect;
}//end


void
MyApp	::	SetPreferredEditPlanetWindowRect(	const BRect paramWindowRect)
{
	preferredEditPlanetWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditPlanetShieldWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditPlanetShieldWindowRect;
}//end


void
MyApp	::	SetPreferredEditPlanetShieldWindowRect(	const BRect paramWindowRect)
{
	preferredEditPlanetShieldWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditPlanetWeaponWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditPlanetWeaponWindowRect;
}//end


void
MyApp	::	SetPreferredEditPlanetWeaponWindowRect(	const BRect paramWindowRect)
{
	preferredEditPlanetWeaponWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditShipWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditShipWindowRect;
}//end


void
MyApp	::	SetPreferredEditShipWindowRect(	const BRect paramWindowRect)
{
	preferredEditShipWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditShipShieldWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditShipShieldWindowRect;
}//end


void
MyApp	::	SetPreferredEditShipShieldWindowRect(	const BRect paramWindowRect)
{
	preferredEditShipShieldWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditShipWeaponWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditShipWeaponWindowRect;
}//end


void
MyApp	::	SetPreferredEditShipWeaponWindowRect(	const BRect paramWindowRect)
{
	preferredEditShipWeaponWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditStarWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditStarWindowRect;
}//end


void
MyApp	::	SetPreferredEditStarWindowRect(	const BRect paramWindowRect)
{
	preferredEditStarWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditGalaxyWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditGalaxyWindowRect;
}//end


void
MyApp	::	SetPreferredEditGalaxyWindowRect(	const BRect paramWindowRect)
{
	preferredEditGalaxyWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditBlackholeWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditBlackholeWindowRect;
}//end


void
MyApp	::	SetPreferredEditBlackholeWindowRect(	const BRect paramWindowRect)
{
	preferredEditBlackholeWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditWormholeWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditWormholeWindowRect;
}//end


void
MyApp	::	SetPreferredEditWormholeWindowRect(	const BRect paramWindowRect)
{
	preferredEditWormholeWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditHoleAffectsWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditHoleAffectsWindowRect;
}//end


void
MyApp	::	SetPreferredEditHoleAffectsWindowRect(	const BRect paramWindowRect)
{
	preferredEditHoleAffectsWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditUniversalConstantsWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditUniversalConstantsWindowRect;
}//end


void
MyApp	::	SetPreferredEditUniversalConstantsWindowRect(	const BRect paramWindowRect)
{
	preferredEditUniversalConstantsWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredEditSpeciesWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredEditSpeciesWindowRect;
}//end


void
MyApp	::	SetPreferredEditSpeciesWindowRect(	const BRect paramWindowRect)
{
	preferredEditSpeciesWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredTitleWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredTitleWindowRect;
}//end


void
MyApp	::	SetPreferredTitleWindowRect(	const BRect paramWindowRect)
{
	preferredTitleWindowRect = paramWindowRect;
}//end

bool
MyApp	::	OpenEditor(	BFile * file)
{
	if (file)
	{
		//fill universe from file
	}
	else
	{
		//fill universe from defaults??
	}
	try 
	{
		BRect holdRect;
		GetPreferredEditUniverseWindowRect(&holdRect);
		pEditUniverseWindow = new EditUniverseWindow(	holdRect,
														EditUniverseWindowTitle,
														"EditUniverseView",
														"EditUniverseFrame");
		pEditUniverseWindow->Initialize();
	}
	catch (...) 
	{
		warning(FailEditUniverseWindow);
		myApp->PostMessage(B_QUIT_REQUESTED);
		return false;
	}
	bEditingUniverse = true;
	return true;
}//end