#ifndef _BUG_OUT_H_
#define _BUG_OUT_H_

#include <Application.h>
#include <Roster.h>
#include <String.h>
#include <Path.h>

//Our standard debug message
#define BUG_OUT  'bugO'

//Some standard debug Levels (you can add more if you want)
#define BUG_INIT      1
#define BUG_MESSAGE   2
#define BUG_ERROR     3
#define BUG_WARNING   4
#define BUG_END       5
#define BUG_SUCCESS   6

class BugOut{
   public:
      /*******************************************************
      *   Set Up a the messenger so we can talk to our Output
      *   window. And grab debuger name. This alows us to 
      *   multiple app accessing the same debug window at one
      *   time.
      *******************************************************/
      BugOut(const char *name){
         Console = new BMessenger ("application/x-vnd.Abstract-BugOut");
         app_info ai;
         if(be_app != NULL){
            be_app->GetAppInfo(&ai);
            BEntry entry(&ai.ref);
            entry.GetPath(&AppPath);
         }else{
            AppPath.SetTo("/");
         }
         //AppName.SetTo(AppPath.Leaf());
         AppName.SetTo(name);
   
         SendMessage( BUG_INIT,"It's alive, it's alive");
      }
      /*******************************************************
      *   Shutdown the debug console
      *******************************************************/
      ~BugOut(){
         SendMessage(BUG_END,"RIP");
         if(!Console){ return; }
         if(Console->IsValid ()){
            delete Console;
            Console = NULL;
         }
      }
      /*******************************************************
      *   A way for your app to see if the Console is up and
      *   running. Just so you dont have to do some debug 
      *   calculations, and so we don't send messages to 
      *   nowhere - its just not usefull if we did.
      *******************************************************/
      bool IsValid(){
         if(!Console){ return false; }
         if(!Console->IsValid()){ return false; }
         return true;
      }
      /*******************************************************
      *   Here is what you will like to play with. Just add
      *   in a message and give it a debug level. There are
      *   a few pre-defined debug levels, but you can use any
      *   number. (currently must fall inside of a int32 though)
      *******************************************************/
      /*******************************************************
      *   Defalut to a general message. for easy of use
      *******************************************************/
      void SendMessage(char *message){
         SendMessage(BUG_MESSAGE,message);
      }
      /*******************************************************
      *   Full flegged SendMessage at any level you want, but
      *   remeber the pre defind ones. its helps some times :)
      *******************************************************/
      void SendMessage(int32 level,char *message){
         if(!IsValid()){ return; }
         BMessage msg(BUG_OUT);
         msg.AddString("AppName",AppName.String());
         msg.AddString("FullPath",AppPath.Path());
         msg.AddString("BugMessage", message);
         msg.AddInt32("Level",level);
         Console->SendMessage(&msg);
      }
      /*******************************************************
      *   Lets you set up the colors of the debug out.    
      *******************************************************/
     // void AssignDebugLevel(int level,rgb_color c){
      //   if(!IsValid()){ return; }
      //   BMessage msg(BUG_SET_COLOR);
      //   msg.AddString("AppName", AppName.String());
      //   msg.AddInt32("Level", level);
         //msg->FindData("RGBColor",B_RGB_COLOR_TYPE,(const void**)&c,&s)
      //   Console->SendMessage(&msg);
      //}
   private:
      BMessenger *Console;
      BString AppName;
      BPath AppPath;
};
#endif