#ifndef REMOTE_USER_H
#define REMOTE_USER_H

#include "message/Message.h"
#include "CLVEasyItem.h"
#include "BeShareNameSpace.h"

class BBitmap;

namespace beshare {

class RemoteFileItem;
class ShareWindow;

// This class represents a single remote user and his current matching file set
class RemoteUserItem : public CLVEasyItem
{
public:
   RemoteUserItem(ShareWindow * owner, const char * sessionID);

   ~RemoteUserItem();

   void SetHandle(const char * handle);
   void SetStatus(const char * status);
   void SetHostName(const char * hostName) {_hostName = hostName;}
   void SetPort(int port) {_port = port;}
   void SetInstallID(uint64 id) {_installID = id;}
   void SetClient(const char * client);
   void SetSupportsPartialHash(bool sph) {_supportsPartialHash = sph;}

   virtual void DrawItemColumn(BView* owner, BRect item_column_rect, int32 column_index, bool complete);

   void PutFile(const char * fileName, MessageRef fileAttrs);
   void RemoveFile(const char * fileName);
   void ClearFiles();

   int GetNumFiles() const {return _files.GetNumItems();}

   const char * GetSessionID() const {return _sessionID.Cstr();}
   const char * GetHandle() const {return _handle.Cstr();}
   const char * GetStatus() const {return _status.Cstr();}
   const char * GetHostName() const {return _hostName.Cstr();}
   const char * GetBandwidthLabel() const {return _bandwidthLabel.Cstr();}
   int GetPort() const {return _port;}
   uint64 GetInstallID() const {return _installID;}
   const char * GetClient() const { return _client.Cstr(); }
   bool GetSupportsPartialHash() const {return _supportsPartialHash;}

   int Compare(const RemoteUserItem * i2, int32 sortKey) const;

   ShareWindow * GetOwner() const {return _owner;}

   String GetUserString() const;

   bool GetFirewalled() const {return _firewalled;}
   void SetFirewalled(bool f);

   void SetIsBot(bool isBot) {_isBot = isBot;}
   bool IsBot() const {return _isBot;}

   void SetBandwidth(const char * label, uint32 bps);
   uint32 GetBandwidth() const {return _bandwidth;}

   void SetNumSharedFiles(int32 nsf);
   int32 GetNumSharedFiles() const {return _numSharedFiles;}

   void SetUploadStats(uint32 curUploads, uint32 maxUploads);

   void PingReceived(Message * pmsg); // handle parsing the message for a client string

private:
   float GetLoadFactor() const;

   ShareWindow * _owner;
   String _sessionID;
   String _handle;
   String _status;
   String _hostName;
   String _client;
   int _port;
   bool _firewalled;
   bool _isBot;
   uint32 _curUploads;
   uint32 _maxUploads;
   bool _supportsPartialHash;

   Hashtable<const char *, RemoteFileItem *> _files;

   String _bandwidthLabel;
   uint32 _bandwidth;

   int32 _numSharedFiles;

   uint64 _installID;
};

};  // end namespace beshare


#endif
