#ifndef SHARE_COLUMN_H
#define SHARE_COLUMN_H

#include "util/String.h"
#include "CLVColumn.h"
#include "BeShareNameSpace.h"

namespace beshare {

class RemoteFileItem;
class RemoteUserItem;

class ShareColumn : public CLVColumn
{
public:
   ShareColumn(int type, const char * attrName, const char * label, float width);

   virtual ~ShareColumn() {/* empty */}
   
   const char * GetAttributeName() const {return _attrName.Cstr();}

   const char * GetFileCellText(const RemoteFileItem * item) const;
   int Compare(const RemoteFileItem * rf1, const RemoteFileItem * rf2) const;

   enum {
      ATTR_MISC = 0,   // file-specific attrs here
      ATTR_FILENAME,
      ATTR_OWNERNAME,
      ATTR_OWNERID,
      ATTR_OWNERCONNECTION
   };

private:
   mutable char _buf[256];
   int _type;
   String _attrName;
};

};  // end namespace beshare

#endif
