/*******************************************************/
/*                       Lists.hpp                     */
/*                                                     */
/*  Started at  940409               Last Rev  ------  */
/*                                                     */
/*                   © Claes Löfqvist                  */
/*******************************************************/
    

#ifndef CLAES_LISTS_HPP
   #define CLAES_LISTS_HPP 
   
   #ifndef CLAES_CLAES_HPP
    #include <Claes\Claes.hpp>
   #endif
 
   class Node {
   friend class List;                
     public:
      Node() { InList= FALSE; };
      Node *Next () const {return (( ln_Succ->ln_Succ ) ? ln_Succ : 0);};
      Node *Prev () const {return (( ln_Pred->ln_Pred ) ? ln_Pred : 0);};
      void AddBefore (Node *NewN);
      void AddAfter  (Node *NewN);
      void Remove (void);
      virtual ~Node (void) {if (InList) Remove();};
     private:                         
      Node *ln_Succ;	// Pointer to next (successor)
      Node *ln_Pred;	// Pointer to previous (predecessor)
      Bool InList;
   };     
   
   class List {
   friend class Node;
     public:                                                                                                     
      List () { this->lh_Head.ln_Pred= this->lh_Tail.ln_Succ= 0; this->lh_Head.InList= this->lh_Tail.InList= TRUE; this->lh_Head.ln_Succ= &this->lh_Tail; this->lh_Tail.ln_Pred= &this->lh_Head;};
      Node *First () const {return (( lh_Head.ln_Succ->ln_Succ ) ? lh_Head.ln_Succ     : 0);};
      Node *Last ()  const {return (( lh_Tail.ln_Pred->ln_Pred ) ? lh_Tail.ln_Pred : 0);};
      void AddFirst (Node &N);
      void AddLast (Node *N);
      ~List () {Node *tmp; while (tmp=First()) delete (tmp); };
     private:
      Node lh_Head;
      Node lh_Tail;
     
  
   //   Node *lh_Head;
   //   Node *lh_Tail;
   //   Node *lh_TailPred;
   };
               

   #define DECL_NODE(NewNode,BaseNode) class NewNode : BaseNode { public : virtual ~NewNode () {}; \
                                        NewNode *Next () const {return ((NewNode *)Node::Next());}; \
                                        NewNode *Prev () const {return ((NewNode *)Node::Prev());}; private:
   #define END_NODE_DECL } 
                             
#endif                             
/* 





DECL_NODE (MyNode, Node)
  public:                 
   void SetName (char *Name);
   char *GetName (void);
   void SortLoToHi (void);
   void SortHiToLo (void); 
  private:
   char Name[200];
END_NODE_DECL;          


*/
         