#include "InputPlugin.h"

class MyPlugin : public InputPlugin {
// >>-- Start of CL-Amp input plugin's virtual functions --------------
public:
	// No thread considerations
	MyPlugin();
	void Init ();
	void Cleanup ();
	// Thread A
	bool About(bool Question);
	bool Prefs(bool Question);
	bool Edit (const char *FileName, bool Question);
	bool GetMimeType(BMimeType *m, int Nr);
	bool IsOur(const char *FileName);
	bool GetSongInfo(const char *FName, struct PlayerInfoStruct *Info);
	void AbortPlaying();
	void Pause(bool On);
	void NewSpeed(long Promille);
	void NewVolume(long Promille);
	// Thread B
	bool InitPlaying(const char *FileName, struct PlayerInfoStruct *Info);
	int GetAudio(char **Buff, int Size);
	void JumpTo(long NewTime);
	void CleanupPlaying();
// ---- End of CL-Amp input plugin's virtual functions --------------<<

public:
	// Included as an example how the BHandler * can be useful
	// However, only needed in special plugins!
	void PostPlayInfo(struct PlayerInfoStruct *Info);
private:
	struct PlayerInfoStruct *PlayInfo;
};
