//
// ClockRAM.cpp
//

#include "ClockRAM.h"

extern const char *CLOCK_RAM_SIGNATURE = "application/x-vnd.JB-ClockRAM";
extern bool NotReplicant = true;

ClockRAM::ClockRAM( bool install )
	: BApplication( CLOCK_RAM_SIGNATURE )
{
	if (install) {
		// install option specified, install self into the Deskbar
		//  Can't be higher than 17; wider than 89, thus 0, 0, 88, 16
		BRect r(0, 0, 88, 16);
		ClockView *replicant = new ClockView( r );
		BMessage archiveMsg(B_ARCHIVED_OBJECT);
		// archive an instance of ClockRAM into a message
		replicant->Archive(&archiveMsg);
		
		// send archived replicant to the deskbar
		BMessenger messenger("application/x-vnd.Be-TSKB", -1, NULL);
		messenger.SendMessage(&archiveMsg);

		// commit suicide
		PostMessage(B_QUIT_REQUESTED);
		return;
	}
	mClockWindow = new ClockWindow( BRect(813, 2, 901, 18) );
	mClockWindow->Show();
}

main( int, char **argv )
{
	if (argv[1] && strcmp(argv[1], "-deskbar") != 0) {
		// print a simple usage string
		printf(	"# %s (c) 1997-98 Be Inc.\n"
				"# Usage: %s [-deskbar]\n",
			 argv[0], argv[0]);
		return 0;
	}

	bool install = argv[1] && (strcmp(argv[1], "-deskbar") == 0);
	(new ClockRAM(install))->Run();
}
