//
// ClockView.h
//

#pragma once

#include <View.h>
#include <PopUpMenu.h>
#include <time.h>
#include <kernel/OS.h>

#pragma export on
class _EXPORT ClockView;
// the dragger part has to be exported

class ClockView : public BStringView
{
	public:
		ClockView( BRect r );
		ClockView( BMessage *data );
		~ClockView();
		status_t	Archive( BMessage *data, bool deep = true ) const;
		static ClockView* Instantiate( BMessage *data );
		virtual void AttachedToWindow( void );
		virtual void MessageReceived( BMessage *m );
		virtual void MouseDown( BPoint p );
		virtual void Pulse( void );

		void InitView( void );
		void GetTime( void );
		long GetFreeBytes( void );

	private:
		time_t cur_t;
		struct tm * local;
		system_info SysInfo;
		long FreeBytes;
		int32 MenuIdx;
		char * apm;					// morning-afternoon.

		char			TimeStr[20];
		BPopUpMenu		*ClockMenu;
};

#pragma export reset
