/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include "strEtc.h"

strEtc::strEtc( const char *buff, 
                const int   buflen )
{
    initp = ( char * )buff ;
    wklen = buflen ;
    
    work = new char[ wklen +1 ] ;
    memset( work, 0, wklen +1 ) ;
    count = 0 ;
}


strEtc::~strEtc()
{
    initp = NULL ;
    wklen = 0 ;
    count = 0 ;
    delete work ;
}


int strEtc::_Lstrlen( const char *source )
{
    register char *srcP ;
    static   int   c ;
    
    c = 0 ;
    srcP = ( char * )source ;
    while( *srcP ){
        srcP++ ;
        c++ ;
    }
    return c ; 
}


char *strEtc::_Lstrstr( const char *source, /* In */
                        const char *seek )  /* In */
{
    register char *srcP ;
    register char *comp ;
    register char *seekP ;

    srcP = ( char * )source ;
    while( *srcP ){
        seekP = ( char * )seek ;
        comp = srcP ;
        while( *seekP ){
            if( *comp != *seekP ) goto NEXT ;
            seekP++ ;
            comp++ ;
        }
        return srcP ;
            
        NEXT:
        srcP++ ;
    }    
    return NULL ;
}


char *strEtc::_Ltok( char *strToken, const char *strDelimit ) 
{
    static char *str ;
    static int   dlen ;
    static char *top ;
    register int i ;

    if( strToken != NULL ){ /* Initialize */
        top  = str = ( char * )strToken ;
        dlen = strlen( strDelimit ) ;
	}
    else{
        top = str ;
	}

	while( *str != ( char )NULL ){
		for( i = 0; i < dlen; i++ ){
			if( *str == strDelimit[ i ] ){
				*str = ( char )NULL ;
				str++ ;
				return top ;
			}
		}
	    str++ ;
	}

    if( *top == ( char )NULL ) return NULL ;
	return top ;
}


void strEtc::unpack( const char *separator, /* In  */
                           int  *n_item,    /* Out */
                           char *item[] )   /* Out */
{
    register char *getP, *retp ;

    memcpy( work, initp, wklen );
    len = _Lstrlen( separator ) ;
    count = 0 ;
    getP = work ;
    while( (retp = ( char * )_Lstrstr( getP, separator ) ) ){
        item[ count ] = getP ;
        getP = retp + len ;
        *retp = ( char )NULL ;
        count++ ;
    }
    if( count > 0 ){
        item[ count ] = getP ;
        count++ ;
    }
    *n_item = count ;
}


int strEtc::strcount( const char *str ) /* In */
{
    register char *get ;
    register char *tmp;

    memcpy( work, initp, wklen ) ;
    len = _Lstrlen( str ) ;
    count = 0 ;
    get = work ;
    while( (tmp = ( char * )_Lstrstr( get, str ) ) ){
        get = tmp + len ;
        count++ ;
    }
    if( count > 0 ) count++ ;

    return count ;
}/* strcount END */


char *strEtc::strFetch( const char       *separator, 
                        const str_fetch_t flg )
{
    static   char *getP, *ret ;
    register char *div ;
 
    if( flg == STR_FETCH_INIT ){ /* Initialize */
        memcpy( work, initp, wklen ) ;
        getP = work ;
    }
    
    /* Below function is STR_FETCH_NEXT */
    ret = ( char * )_Lstrstr( getP, separator ) ;
    if( ret != NULL ){
        div = getP ;
        getP = ret + _Lstrlen( separator )  ;
        *ret = ( char )NULL ;
        return div ;
    }
    count = _Lstrlen( getP ) ;
    if( count > 0 ){
        div = getP ;
        getP = getP + count ;
        return div ;
    }
    return ret ;   
}


char *strEtc::charTok( const char       *separator, 
                       const str_fetch_t flg )
{
    static   char *getP, *ret ;
 
    if( flg == STR_FETCH_INIT ){ /* Initialize */
        memcpy( work, initp, wklen ) ;
        getP = work ;
    }
    
    /* Below function is STR_FETCH_NEXT */
    getP = _Ltok( getP, separator ) ;
//    getP = (char*)strtok( getP, separator ) ;
    ret = getP ;
    getP = NULL  ;
    
    return ret ;   
}


void strEtc::unpackChar( const char *separator, int *n_item, char **item )
{
    register char *tok ;
    static int c ;

    memcpy( work, initp, wklen ) ;
    tok = work ;
    c = 0 ;
    while( (tok = (char*)strtok( tok, separator )) ){
        *( item + c ) = tok ;
        c++ ;
        tok = NULL ;
    }
    *n_item = c ;
}


int strEtc::countChar( const char *str ) /* In */
{
    register char *tok ;
    static int c ;

    memcpy( work, initp, wklen ) ;
    tok = work ;
    c = 0 ;
    while( (tok = (char*)strtok( tok, str )) ){
        c++ ;
        tok = NULL ;
    }
    return c ;
}
/*
 * End.
 */