/*
 *  DIGIClock.cpp -  DIGIClock V2.0
 *                   Written by Tinic Uro
 *                   FreeWare
 */

#include <AppKit.h>
#include <InterfaceKit.h>
#include <StorageKit.h>
#include <KernelKit.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>
#include <time.h>

// Types
typedef unsigned char 	UBYTE;
typedef unsigned short 	UWORD;
typedef unsigned long 	ULONG;
typedef char 			BYTE;
typedef short 			WORD;
typedef long 			LONG;

// Constants

const 	char			*APP_SIGNATURE = "application/x-vnd.tinic-DIGIClock";
const 	LONG 			DISPLAY_X = 80;
const 	LONG 			DISPLAY_Y = 480;		

enum
{
	ABOUT_REQ=0x2323,
	LEFT_TOP=0xF000,
	RIGHT_TOP,
	RIGHT_BOTTOM,
	LEFT_BOTTOM
};	
			
// Window/Application messages

class					Clock;
class 					ClockWindow;
class					ClockView;
class					MainView;
class					StatView;
class					VolView;
class					MemView;
class					SwapView;

int32 used_swap(void);
int32 total_swap(void);

extern	UBYTE 			image[];
static 	system_info		si;
static 	char			id[256];
static 	Clock 			*the_app;
static 	BScreen			*the_screen;

// Application object
class Clock : public BApplication 
{
	public:
						Clock();
			void 		ReadyToRun(void);
			bool 		QuitRequested(void);
			void 		AboutRequested(void);
			
	private:

			ClockWindow	*the_window;
};

// Window object
class ClockWindow : public BWindow 
{
	public:
	
							ClockWindow(int width, int height);
			bool 			QuitRequested(void);
			void 			MessageReceived(BMessage *msg);
			void			WorkspaceActivated(long ws, bool state);
			void 			UpdateWindowPosition(void);

	private:
	
			MainView		*main_view;	
			BResources		*resource;
			BFile			*file;
			int32			winpos;
};

// View object

class MainView : public BView 
{
	public:

							MainView(BRect frame);
							~MainView();
			void 			AttachedToWindow();
			void 			MessageReceived(BMessage *msg);
		 	void 			Draw(BRect update);
			void			Pulse(void);
			void 			MouseDown(BPoint where);

	private:
	
			BBitmap			*clock_bitmap;
			ClockView		*clock_view;
			StatView		*teams,*machine;
			VolView			*vol;
			MemView			*mem;
			SwapView		*swap;
			uchar			grey;
			node_ref		root;
			BVolumeRoster	roster;
			BList			vollist;
			BPopUpMenu		*pop;			
};

class ClockView : public BView 
{
	public:
						ClockView(BRect frame);
						~ClockView();
	virtual	void 		Draw(BRect update);

	private:			
			BBitmap		*numbers[10];
			uchar		todo[6];
			BFont		*font;
};


class StatView : public BView 
{
	public:
						StatView(BRect frame) : BView(frame, "", B_FOLLOW_NONE, B_WILL_DRAW)
						{
							bd=Bounds();
							font = new BFont(be_plain_font);
							font->SetSize(9);
							SetFont(font);
							SetDrawingMode(B_OP_OVER);
							col.red=255;
							col.green=64;
							col.blue=0;
							col.alpha=0;
						}
						
	virtual	void 		Draw(BRect update)
						{
							char buf[256];
							SetHighColor(255,255,255);
							FillRect(bd);
							SetHighColor(0,0,0);
							StrokeRect(bd);
							SetHighColor(col);
							sprintf(buf,str,act);
							FillRect(BRect(1,1,(act*(bd.Width()-1))/max,bd.Height()-1));
							SetHighColor(0,0,0);
							DrawString(buf,BPoint((bd.Width()-StringWidth(buf))/2,9));
						}
			
			long		max;
			long		act;
			long		mod;
			char		*str;			

	protected:

			rgb_color	col;
			BRect		bd;
			BFont		*font;

};

class FreeView : public BView 
{
	public:
						FreeView(BRect frame) : BView(frame, "", B_FOLLOW_NONE, B_WILL_DRAW)
						{
							bd=Bounds();
							font=new BFont(be_plain_font);
							font->SetSize(9);
							SetFont(font);
							SetDrawingMode(B_OP_OVER);
							col.red=32;
							col.green=128;
							col.blue=255;
							col.alpha=0;
							rdo=false;
						}
						
	virtual	void 		Draw(BRect update)
						{
							char buf[256];
							SetHighColor(200,200,200);
							FillRect(Bounds());
							if(rdo)
								SetHighColor(255,64,0);
							else
								SetHighColor(255,255,255);
							FillRect(bd);
							SetHighColor(0,0,0);
							StrokeRect(bd);
							SetHighColor(col);
							BRect r=BRect(1,1,(act*(bd.Width()-1))/max,bd.Height()-1);
							r.top+=bd.top;
							r.left+=bd.left;
							r.bottom+=bd.top;
							r.right+=bd.left;
							FillRect(r);
							sprintf(buf,str,(max-act)/(1024*1024));
							SetHighColor(0,0,0);
							DrawString(buf,bd.LeftTop()+BPoint((bd.Width()-StringWidth(buf))/2,9));
						}

			float		max;
			float		act;
			float		mod;
			
	protected:
	
			rgb_color	col;
			BRect		bd;
			char		*str;			
			BFont		*font;
			bool		rdo;

};

class SwapView : public FreeView
{
	public:			
						SwapView(BRect frame):FreeView(frame)	
						{
							max=total_swap();
							act=used_swap();
							str="%.1fMB MEM";
						};
};

class MemView : public FreeView
{
	public:			
						MemView(BRect frame):FreeView(frame)	
						{
							max=(si.max_pages)*4096;
							act=(si.used_pages)*4096;
							str="%.1fMB RAM";
						};
};

class VolView : public FreeView
{
	public:			
						VolView(BRect frame, BVolume *vol):FreeView(frame)	
						{
							bd.top+=10;
							volume=vol;
							mod=-1;
							max=volume->Capacity();
							act=volume->Capacity()-volume->FreeBytes();
							volume->GetName(tmp);
							str="%.2fMB";
							
							if(volume->IsReadOnly())
							{
								act=0;
								rdo=true;
							}
							else rdo=false;
							
							if(volume->IsRemovable())
							{
								col.red=32;
								col.blue=128;
								col.green=255;
								col.alpha=0;						
							}
							else
							{
								col.red=32;
								col.green=128;
								col.blue=255;
								col.alpha=0;						
							}
						};
			
						~VolView()
						{
							delete volume;
						}

			void		Update()
						{
							max=volume->Capacity();
							act=volume->Capacity()-volume->FreeBytes();
							if(volume->IsReadOnly())
							{
								act=0;
								rdo=true;
							}
							else rdo=false;
							
							if(mod!=act)
							{
								Draw(Frame());
								mod=act;
							}	
						}

	virtual	void 		Draw(BRect update)
						{
							SetDrawingMode(B_OP_OVER);
							FreeView::Draw(update);
							SetDrawingMode(B_OP_COPY);
							SetLowColor(200,200,200);
							DrawString(tmp,BPoint((bd.Width()-StringWidth(tmp))/2,8));
						}

	private:	
			BVolume		*volume;
			char		tmp[1024];
};

int32 used_swap(void)
{
	static 	team_info ti;
	static 	area_info ai;
	int32 size=0;
	int32 cookie1=0;	
	
	while(get_next_team_info(&cookie1,&ti)==B_NO_ERROR)
	{
		int32 cookie2=0;
		while(get_next_area_info(ti.team,&cookie2,&ai)==B_NO_ERROR)
		{
			size+=ai.size;
		}
	}
	return size;
}

int32 total_swap(void)
{
	static int32 tot=0;
	if(tot==0)
	{
		off_t t;
		BEntry entry = BEntry("/boot/beos/system/swap");
		entry.GetSize(&t);
		tot=t;
		tot+=(si.max_pages)*4096;
	}
	return (int32)tot;
}

// Create application object and start it
int main(int argc, char **argv)
{	
	the_app = new Clock();
	the_app->Run();
	delete the_app;

	return 0;
}


/*
 *  Application constructor
 */

Clock::Clock() : BApplication(APP_SIGNATURE)
{
	the_window = NULL;
}

/*
 *	Thats from me!
 */

void Clock::AboutRequested(void) 
{
	char str[256];
	sprintf(str, "DIGIClock V2.0 by Tinic Urou\n<5uro@informatik.uni-hamburg.de>\n\nFreely distributable.\nIf you like this software, leave me an email!");
	BAlert *the_alert = new BAlert("", str, "OK");
	the_alert->Go();
}


/*
 *  Open window and start rendering
 */

void Clock::ReadyToRun(void)
{
	// Open window
	the_window = new ClockWindow(DISPLAY_X, DISPLAY_Y);
}


/*
 *  Quit requested (either by menu or by closing the window)
 */

bool Clock::QuitRequested(void)
{
	// Make sure that the window closes first
	if (BApplication::QuitRequested()) 
	{
		return TRUE;
	}
	return FALSE;
}


/*
 *  Window constructor
 */

void ClockWindow::UpdateWindowPosition()
{
	switch(winpos)
	{	
		case	0:
				MoveTo(0,0);
				break;
		default:
		case	1:
				MoveTo(the_screen->Frame().Width()-DISPLAY_X,0);
				break;
		case	2:
				MoveTo(the_screen->Frame().Width()-DISPLAY_X,the_screen->Frame().Height()-Frame().Height());
				break;
		case	3:
				MoveTo(0,the_screen->Frame().Height()-Frame().Height());
				break;
	}
}
																											// B_TITLED_WINDOW
ClockWindow::ClockWindow(int width, int height) : BWindow(BRect(0, 0, width-1, height-1), "DIGIClock by Tinic", B_BORDERED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE,B_ALL_WORKSPACES)
{
	app_info info;
	be_app->GetAppInfo(&info);
	file = new BFile(&info.ref,B_READ_WRITE);
	resource = new BResources(file);
	
	if(resource->HasResource(B_INT32_TYPE, 'POSI'))
	{
		if(resource->ReadResource(B_INT32_TYPE, 'POSI', &winpos, 0, sizeof(int32))!=B_NO_ERROR)
		{
			winpos=1;
		}
	}
	else
	{
		winpos=1;
	}

	the_screen = new BScreen();
	// Move window to right position

	UpdateWindowPosition();

	// Create bitmap view
	Lock();
	main_view = new MainView(BRect(0, 0, DISPLAY_X, DISPLAY_Y));
	AddChild(main_view);
	Unlock();

	SetPulseRate(1000000);

	// Show the window
	Show();
}


/*
 *  Closing the window quits the program
 */

bool ClockWindow::QuitRequested(void)
{
	if(!resource->HasResource(B_INT32_TYPE,'POSI'))
		resource->AddResource(B_INT32_TYPE,'POSI',&winpos,sizeof(int32));
	else
		resource->WriteResource(B_INT32_TYPE,'POSI',&winpos,0,sizeof(int32));

	delete resource;
	delete file;
	
	be_app->PostMessage(B_QUIT_REQUESTED);
	return TRUE;
}


/*
 *  Handles redraw messages
 */

void ClockWindow::MessageReceived(BMessage *msg)
{
	switch (msg->what) 
	{
		case	ABOUT_REQ:
				be_app->PostMessage(B_ABOUT_REQUESTED);
				return;
		case	LEFT_TOP:
		case	RIGHT_TOP:
		case	RIGHT_BOTTOM:
		case	LEFT_BOTTOM:
				winpos=msg->what&0x3;
				UpdateWindowPosition();
				return;
		default:
				BWindow::MessageReceived(msg);
				return;
	}
}

void ClockWindow::WorkspaceActivated(long ws, bool state)
{
	MoveTo(the_screen->Frame().Width()-DISPLAY_X,0);
}

MainView::MainView(BRect frame) : BView(frame, "", B_FOLLOW_NONE, B_WILL_DRAW | B_PULSE_NEEDED)
{
}

void MainView::AttachedToWindow()
{
	float y1,y2;

	// Create stuff to watch volumes

	roster = BVolumeRoster();
	BEntry entry = BEntry("/");
	entry.GetNodeRef(&root);
	watch_node(&root,B_WATCH_MOUNT,this);
	
	// Create Interface stuff

	grey=the_screen->IndexForColor(200,200,200);
	clock_bitmap = new BBitmap(BRect(0, 0, DISPLAY_X-1, DISPLAY_Y-1),B_COLOR_8_BIT,TRUE);
	clock_bitmap->Lock();
	clock_view = new ClockView(BRect(0, 0, DISPLAY_X-1, DISPLAY_Y-1));
	clock_bitmap->AddChild(clock_view);

	y1=34;
	y2=44;
	
	teams = new StatView(BRect(4, y1, DISPLAY_X-5, y2));
	get_system_info(&si);
	teams->max=si.max_teams;
	teams->act=si.used_teams;
	teams->str="%d teams";

	y1+=12;
	y2+=12;

	machine = new StatView(BRect(4, y1, DISPLAY_X-5, y2));
	machine->max=si.max_threads;
	machine->act=si.used_threads;
	machine->str="%d threads";

	y1+=12;
	y2+=12;

	mem = new MemView(BRect(4, y1, DISPLAY_X-5, y2));

	y1+=12;
	y2+=12;

	swap = new SwapView(BRect(4, y1, DISPLAY_X-5, y2));
	
	clock_bitmap->AddChild(teams);
	clock_bitmap->AddChild(machine);
	clock_bitmap->AddChild(mem);
	clock_bitmap->AddChild(swap);

	y1+=12;
	y2+=22;

	roster.Rewind();
	BVolume *vol= new BVolume();
	for(;roster.GetNextVolume(vol)==B_NO_ERROR;)
	{
		if(vol->Capacity()>0)
		{
			VolView *volview = new VolView(BRect(4, y1, DISPLAY_X-5, y2),vol);
			vollist.AddItem(volview);
			clock_bitmap->AddChild(volview);
			vol = new BVolume();

			y1+=22;
			y2+=22;
		}
	}
	delete vol;
	
	clock_bitmap->Unlock();
	Window()->ResizeTo(DISPLAY_X-1,y1+2);
	((ClockWindow *)Window())->UpdateWindowPosition();		

	// Create PopUpMenu	

	pop = new BPopUpMenu("PopUpMenu");
	pop->SetRadioMode(FALSE);
	pop->SetTriggersEnabled(FALSE);
	BMenuItem *item = new BMenuItem("About DIGIClock…",new BMessage(ABOUT_REQ));
	pop->AddItem(item);
	pop->AddItem(new BSeparatorItem());
	item = new BMenuItem("LeftTop",new BMessage(LEFT_TOP));
	pop->AddItem(item);
	item = new BMenuItem("RightTop",new BMessage(RIGHT_TOP));
	pop->AddItem(item);
	item = new BMenuItem("RightBottom",new BMessage(RIGHT_BOTTOM));
	pop->AddItem(item);
	item = new BMenuItem("LeftBottom",new BMessage(LEFT_BOTTOM));
	pop->AddItem(item);
	pop->SetTargetForItems(Window());
	
}

void MainView::MouseDown(BPoint where)
{
	// Open popupmenu when the right mouse button is pressed

	uint32 buttons;
	GetMouse(&where,&buttons);
	if(buttons&B_SECONDARY_MOUSE_BUTTON)
	{
		pop->Go(ConvertToScreen(where)-BPoint(2,2),TRUE,TRUE,Frame());
	}
}

void MainView::MessageReceived(BMessage *msg)
{
	switch (msg->what) 
	{		
		case	B_NODE_MONITOR:
				{
					// Volumes changed. We must update the WHOLE volumelist, since
					// the dev_t I get in "devices" seems to be invalid. Hmmm, it seems,
					// that the dev_t numbers are reordered. Additionally BVolumes cant
					// be compared correcly together. I have to do this, since I have to
					// look in the BList which entry was unmounted. But the dev_t value in
					// the BVolumes are not updated... Strange...
					// Some programs could get into troubles when using a BVolume object 
					// while mounting new devices. I noticed f.ex. a problem with BeIDE...

					int32 opcode;
					if(msg->FindInt32("opcode",&opcode)==B_NO_ERROR)
					{
						switch(opcode)
						{
							case	B_DEVICE_MOUNTED:
							case	B_DEVICE_UNMOUNTED:

									clock_bitmap->Lock();

									VolView*t; while(t=(VolView *)vollist.RemoveItem((int32)0)) 
									{ 
										t->RemoveSelf(); 
										delete t; 
									}

									float y1,y2;

									y1=34+24+12+12;
									y2=44+24+22+12;

									roster.Rewind();
									BVolume *vol= new BVolume();
									for(;roster.GetNextVolume(vol)==B_NO_ERROR;)
									{
										if(vol->Capacity()>0)
										{
											VolView *volview = new VolView(BRect(4, y1, DISPLAY_X-5, y2),vol);
											vollist.AddItem(volview);
											clock_bitmap->AddChild(volview);
											vol = new BVolume();
								
											y1+=22;
											y2+=22;
										}
									}
									delete vol;

									Window()->Lock();
									Window()->ResizeTo(DISPLAY_X-1,y1+2);
									((ClockWindow *)Window())->UpdateWindowPosition();										
									clock_view->Draw(Frame());
									clock_view->SetHighColor(200,200,200);
									clock_view->FillRect(BRect(0,y1,DISPLAY_X,y1+2));
									clock_view->Window()->Unlock();
									DrawBitmap(clock_bitmap,BPoint(0,0));
									Window()->Unlock();
									break;
						}
					}
				}
				return;
		default:
				BView::MessageReceived(msg);
				return;
	}
}

MainView::~MainView()
{
	delete clock_bitmap;
}

void MainView::Pulse()
{
	memset(clock_bitmap->Bits(),grey,32*DISPLAY_X);
	clock_view->Window()->Lock();

	// Hmm... Not quite OO... 8-}

	get_system_info(&si);

	teams->max=si.max_teams;
	teams->act=si.used_teams;

	if(teams->mod!=teams->act)
	{
		teams->Draw(Frame());
		teams->mod=teams->act;
	}
	
	machine->max=si.max_threads;
	machine->act=si.used_threads;
	if(machine->mod!=machine->act)
	{
		machine->Draw(Frame());
		machine->mod=machine->act;
	}
	
	mem->max=(si.max_pages)*4096;
	mem->act=(si.used_pages)*4096;
	if(mem->mod!=mem->act)
	{
		mem->Draw(Frame());
		mem->mod=mem->act;
	}	

	static uint32 counter=0;
	counter++;
	if(!(counter%5)) // Every five seconds since is uses some processor time.
	{
		swap->max=total_swap();
		swap->act=used_swap();
		if(swap->mod!=swap->act)
		{
			swap->Draw(Frame());
			swap->mod=swap->act;
		}		
	}

	// This looks better...
		
	for(int i=0;i<vollist.CountItems();i++)
	{
		VolView *vol = ((VolView *)vollist.ItemAt(i));
		vol->Update();
	}
	
	clock_view->Draw(Frame());
	clock_view->Window()->Unlock();
	Window()->Lock();
	DrawBitmap(clock_bitmap,BPoint(0,0));
	Window()->Unlock();
}

void MainView::Draw(BRect updateRect)
{
	memset(clock_bitmap->Bits(),grey,DISPLAY_Y*DISPLAY_X);

	clock_bitmap->Lock();
	
	// Speed is not a problem, so we make it simple
	
	teams->Draw(teams->Frame());
	machine->Draw(machine->Frame());
	mem->Draw(mem->Frame());
	swap->Draw(swap->Frame());

	for(int i=0;i<vollist.CountItems();i++)
	{
		VolView *vol = ((VolView *)vollist.ItemAt(i));
		vol->Draw(vol->Frame());
	}

	clock_view->Draw(clock_view->Frame());
	
	clock_bitmap->Unlock();
	DrawBitmap(clock_bitmap);
}

ClockView::ClockView(BRect frame) : BView(frame, "", B_FOLLOW_NONE, B_WILL_DRAW | B_PULSE_NEEDED)
{
	for(int i=0;i<10;i++)
	{
		numbers[i]= new BBitmap(BRect(0,0,11,16),B_COLOR_8_BIT);
		memcpy(numbers[i]->Bits(),&image[i*12*17],12*17);
	}
	font = new BFont(be_fixed_font);
	font->SetSize(11);
	SetFont(font);
	SetDrawingMode(B_OP_OVER);
}

ClockView::~ClockView()
{
	for(int i=0;i<10;i++)
	{
		if(numbers[i])delete numbers[i];
	}
}

void ClockView::Draw(BRect update)
{
	// Horrible code!
	
	struct tm *my_tm;
	time_t	my_time;
	char mytime[256];
	
	my_time=__get_time();
	my_tm=localtime(&my_time);
	SetHighColor(0,0,0);
	
	todo[0]=my_tm->tm_hour/10;
	todo[1]=my_tm->tm_hour-(todo[0]*10);
	todo[2]=my_tm->tm_min/10;
	todo[3]=my_tm->tm_min-(todo[2]*10);
	todo[4]=my_tm->tm_sec/10;
	todo[5]=my_tm->tm_sec-(todo[4]*10);
	
	if(my_tm->tm_sec&0x01)
	{
		FillRect(BRect(30,8,31,9));
		FillRect(BRect(30,13,31,14));
	}
	
	DrawBitmapAsync(numbers[todo[0]],BPoint(6,3));
	DrawBitmapAsync(numbers[todo[1]],BPoint(18,3));
	DrawBitmapAsync(numbers[todo[2]],BPoint(35,3));
	DrawBitmapAsync(numbers[todo[3]],BPoint(47,3));		
	DrawChar(todo[4]+0x30,BPoint(62,20));
	DrawChar(todo[5]+0x30,BPoint(69,20));

	strcpy(mytime,ctime(&my_time));
	mytime[10]=0;
	DrawString(mytime,BPoint(6,31));
	Sync();
}
