#ifndef VTIMER_H
#define VTIMER_H

#include "tdefs.h"

#define VT_VRSYNC    1
#define VT_CALLOLD   2

#ifdef __cplusplus
extern "C" {
#endif

void VT_Exit(void);
void VT_Init(void);
WORD VT_Alloc(void);
void VT_Free(WORD handle);
void VT_SetHandler(WORD handle,void (*handler)(void));
void VT_SetSpeed(WORD handle,LONG speed);
void VT_SetBPM(WORD handle,UBYTE bpm);
void VT_Start(WORD handle);
void VT_Stop(WORD handle);
void VT_Mode(UBYTE flags);
void VT_V0Handler(void (*handler)(void));
void VT_V1Handler(void (*handler)(void));

#ifdef __cplusplus
}
#endif

/* COUNTER.C defnitions */

#define CNT_ACTIVE   16
#define CNT_VALUE    0
#define CNT_POINTER  1
#define CNT_FUNCTION 2
#define CNT_TYPE     15
                         
typedef struct COUNTER
{  struct COUNTER *next, *prev;
   UBYTE  flags;
   ULONG  counter;
   ULONG  resetcount;
   int    increment;
   int    value;
   int    stopvalue;
} COUNTER;


COUNTER *RegisterCounter(ULONG initcount, ULONG resetcount, int value, int increment, int stopvalue, UBYTE flags);
void RemoveCounter(COUNTER *counter);
void StartCounter(COUNTER *counter);
void StopCounter(COUNTER *counter);
void Counter_Init(void);
void Counter_Exit(void);

#endif
