//scrolling window

#include "windowGuts.h"
#include <memory>
#include "scrollView.h"
#include "layoutMatrix.h"
#include "intGadget.h"
#include "myButton.h"
#include "myPopUpMenu.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myColorControl.h"
#include "myRadioView.h"
#include "myStatusBar.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include "colorWell.h"
#include "mainWindow.h"

//ctor 
WindowGuts	::	WindowGuts(	BRect			paramBound,
							const char *	ccpparamWindowTitle,
							const char *	ccpparamScrollViewName,
							const char *	ccpparamNamePrefFrame)
			: 
				BWindow(	paramBound, 
							ccpparamWindowTitle, 
							B_DOCUMENT_WINDOW, 
							/*B_WILL_ACCEPT_FIRST_CLICK*/0), 
				baseView(NULL), 
				scrollView(NULL),
				pMenuBar(new BMenuBar(BRect(0, 0, 1000, 15), "WindowGutsMenuBar")),
				scrollViewName(new char[strlen(ccpparamScrollViewName) + 1]),
				ccpNamePrefFrame(ccpparamNamePrefFrame),
				pLayoutMatrixList(new BList())
{
	strcpy(scrollViewName, ccpparamScrollViewName);
}//end


//dtor
WindowGuts	::	~WindowGuts() 
{
	delete pLayoutMatrixList;//if we keep this around until now, we MAY be able to "re-Initial()ize" a window!
	delete [] scrollViewName;
}//end


//do all the real work of construction so we can fail gracefully
bool 
WindowGuts	::	Initialize(	void) 
{
	AddChild(pMenuBar);
	float mb_height = pMenuBar->Bounds().Height();
	float maxRight = 50;
	float maxBottom = 20;
	LayoutMatrix * tempLayoutMatrix;
	int32 numItems = pLayoutMatrixList->CountItems();
	if (numItems)
	{
		tempLayoutMatrix = (LayoutMatrix *)pLayoutMatrixList->ItemAt(0);
		maxRight = tempLayoutMatrix->right;
		maxBottom = tempLayoutMatrix->bottom;
		for (int32 i = 1; i < numItems; i++)
		{
			tempLayoutMatrix = (LayoutMatrix *)pLayoutMatrixList->ItemAt(i);//dynamic cast??
			if (tempLayoutMatrix->right > maxRight)
			{
				maxRight = tempLayoutMatrix->right;
			}
			if (tempLayoutMatrix->bottom > maxBottom)
			{
				maxBottom = tempLayoutMatrix->bottom;
			}
		}
	}
	maxRight += MATRIXHORIZONTALOFFSETGUTS;
	maxBottom += (2 * MATRIXVERTICALOFFSETGUTS);
	//gives a bit of pad spacing between the items and the view's right & lower edges
	
	//insure the widow is appropriately sized--as small as
	//needed, or if need be (underlaying view larger than screen
	//resolution) as large as will fit on the screen nicely
	BRect	screenResolutionRect;
	{
		BScreen	screen(B_MAIN_SCREEN_ID);
		if(!screen.IsValid()) 
		{
			warning("!screen.IsValid()\n");
			return false;
		}
		screenResolutionRect = screen.Frame();
	}
	float horizFudge = 9;//so our window nicely fits inside screen
	float vertFudge = 8;//so our window nicely fits inside screen
	float newWindowWidth = screenResolutionRect.IntegerWidth() - (B_V_SCROLL_BAR_WIDTH + horizFudge);
	if (maxRight < newWindowWidth)
	{
		newWindowWidth = maxRight;
	}
	float newWindowHeight = screenResolutionRect.IntegerHeight() - (B_H_SCROLL_BAR_HEIGHT + MATRIXVERTICALOFFSETGUTS + mb_height + vertFudge);
	if (maxBottom < newWindowHeight)
	{
		newWindowHeight = maxBottom;
	}
	ResizeTo(	newWindowWidth + B_V_SCROLL_BAR_WIDTH, 
				newWindowHeight + B_H_SCROLL_BAR_HEIGHT + mb_height);

	underViewWidth = maxRight;
	underViewHeight = maxBottom;
	try 
	{
		//this is the view into which we will place our buttons
		//notice the "mb_height + 1", in the second element
		baseView = new ScrollView(	BRect(	0, 
											mb_height + 1, 
											maxRight, 
											maxBottom + mb_height - 1));
		baseView->SetFont(myPrefs->GetPreferredFont());
	}
	catch(...) 
	{
		warning("New failed.\n");
		return false;
	}
	try 
	{
		//this is the scroll bar stuff:
		scrollView = new BScrollView(	scrollViewName, 
										(BView *)baseView, 
										B_FOLLOW_ALL, 
										B_WILL_DRAW, 
										true, 
										true, 
										B_NO_BORDER);
	}
	catch(...) 
	{
		warning("New failed.\n");
		return false;
	}
	AddChild(scrollView);
	//to the older sized window
	
	scrollView->ResizeTo(	newWindowWidth + B_V_SCROLL_BAR_WIDTH + 1, 
							newWindowHeight + B_H_SCROLL_BAR_HEIGHT - 1);
	//BScrollViews get thier initial size from the underlaying BView (baseView)
	
	//now we have a baseView with permenent homes for the created buttons:
	int32 numLayoutMatrixListItems = pLayoutMatrixList->CountItems();
	for (int32 j = 0; j < numLayoutMatrixListItems; j++)
	{
		LayoutMatrix * holdLayoutMatrix = (LayoutMatrix *)pLayoutMatrixList->ItemAt(j);
		int32 numThingsTo = holdLayoutMatrix->mpChildrenToAdd->CountItems();
		for (int32 i = 0; i < numThingsTo; i++)
		{
			BView * child = (BView *)holdLayoutMatrix->mpChildrenToAdd->ItemAt(i);
			ColorWell * cwg = dynamic_cast<ColorWell *> (child);
			if (cwg)
			{
				cwg->MoveTo(cwg->GetLeft(), cwg->GetTop());
				baseView->AddChild(child);
			}
			else
			{
				MyButton * mbg = dynamic_cast<MyButton *> (child);
				if (mbg)
				{
					BButton * button = dynamic_cast<BButton *> (child);
					if (button)
					{
						baseView->AddChild(button);
						button->SetTarget(this);
					}
					else
					{
						baseView->AddChild(child);
					}
				}
				else
				{
					IntGadget * intGadget = dynamic_cast<IntGadget *> (child);
					if (intGadget)
					{
						BTextControl * textControl = dynamic_cast<BTextControl *> (child);
						if (textControl)
						{
							baseView->AddChild(textControl);
							textControl->SetTarget(this);
						}
						else
						{
							baseView->AddChild(child);
						}
					}
					else
					{
						MyStringDrawer * stringDrawer = dynamic_cast<MyStringDrawer *> (child);
						if (stringDrawer)
						{
							baseView->pmStringViewList->AddItem((void *)stringDrawer);
						}
						else	
						{
							MyRadioView * radioView = dynamic_cast<MyRadioView *> (child);
							if (radioView)
							{
								baseView->AddChild(radioView);
							}
							else
							{
								MyStatusBar * myStatusBar = dynamic_cast<MyStatusBar *> (child);
								if (myStatusBar)
								{
									rgb_color rgb;
									rgb.red = 200;
									rgb.green = 40;
									rgb.blue = 100;
									rgb.alpha = 255;
									myStatusBar->SetMaxValue(100);
									baseView->AddChild(myStatusBar);
									myStatusBar->SetBarColor(rgb);
								}
								else
								{
									MyColorControl * myColorControl = dynamic_cast<MyColorControl *> (child);
									if (myColorControl)
									{
										baseView->AddChild(myColorControl);
										//float fontSize = myPrefs->GetPreferredFont()->Size();
										//myColorControl->ResizeBy(fontSize * 5.8, fontSize * 1.5);
										//int32 children = myColorControl->CountChildren();
//										BView * tbv;
//										for (int32 i = 0; i < children; i++)
//										{
//											tbv = myColorControl->ChildAt(i);
//											tbv->SetFont(deb->GetPreferredFont());
//											tbv->ResizeToPreferred();
//										}
//										myColorControl->ResizeToPreferred();
									}
									else
									{
										// this is where anything without a specific dynamic_cast item is attached
										baseView->AddChild(child);
									}
								}
							}
						}
					}
				}
			}
		}
		numThingsTo = holdLayoutMatrix->mpItemsToDraw->CountItems();
		for (int32 i = 0; i < numThingsTo; i++)
		{
			baseView->pmTextItemList->AddItem(holdLayoutMatrix->mpItemsToDraw->ItemAt(i));
		}
	}
	//from above, numItems = pLayoutMatrixList->CountItems();
	for (int32 i = 0; i < numItems; i++)
	{
		delete (LayoutMatrix *)pLayoutMatrixList->ItemAt(i);
	}
	UpdateScrollBars();//adjust knobs position and proportions
	Show();
	return true;
}//end


//adjust scroll bars to reflect new situation
void 
WindowGuts	::	UpdateScrollBars() 
{
	//puts the scroll bars in the proper perspective
	//this code was grabbed from the mandx sample
	//and converted from BBitMap to BView stuff
	
	BScrollView * scrollview;
	BScrollBar * scrollbar;
	BRect visibleExtent;
	BRect totalExtent;
	BRect bound;
	BRect myBounds;
	long max;
	
	Lock();
	scrollview = (BScrollView *)FindView(scrollViewName);
	if (scrollview) 
	{
		bound.Set(0, 0, underViewWidth, underViewHeight);
		myBounds = Bounds();
	
		visibleExtent = bound & myBounds;
		totalExtent = bound | myBounds;
	
		scrollbar = scrollview->ScrollBar(B_HORIZONTAL);
		max = bound.Width() - myBounds.Width();
		if (max < 0) 
		{
			max = 0;
		}
		scrollbar->SetRange(0, max);
		scrollbar->SetProportion(visibleExtent.Width() / totalExtent.Width());
	
		scrollbar = scrollview->ScrollBar(B_VERTICAL);
		max = bound.Height() - myBounds.Height();
		if (max < 0) 
		{
			max = 0;
		}
		scrollbar->SetRange(0, max);
		scrollbar->SetProportion(visibleExtent.Height() / totalExtent.Height());
		baseView->Invalidate(baseView->Bounds());
	}
	else 
	{
		warning("No scrollView!\n");
	}
	Unlock();
}//end


void 
WindowGuts	::	FrameResized(	float, /*note that by NOT naming these we avoid the "unused parameter" warning*/
								float) 
{
	UpdateScrollBars();
}//end


bool
WindowGuts	::	QuitRequested(	void) 
{
	/*	save our position	*/
	bool allSetsOK = true;
	BRect frame = Frame();
	if (myPrefs->appsPreferenceSet.SetData(ccpNamePrefFrame, &frame, sizeof(frame), B_RECT_TYPE))
	{
		warning("Cannot set frame preference.\n");
		allSetsOK = false;
	}
	if (allSetsOK)
	{
		if (myPrefs->appsPreferenceSet.Save())
		{
			warning("Prefs cannot save settings.\n");
		}
	}
	if (myPrefs->bPrefChangesMade)
	{
		myApp->pMainWindow->PostMessage(B_QUIT_REQUESTED);
	}
	return(true);
}//end


void
WindowGuts	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_WINDOWGUTS:	
		{
			warning("about gutsy window\n");
		break;
		}
		default:
			BWindow::MessageReceived(pparamMessage);
		break;
	}
}//end


void
WindowGuts	::	AddToLayoutMatrixList(	LayoutMatrix * pparamLayoutMatrix)
{
	pLayoutMatrixList->AddItem((void *)pparamLayoutMatrix);
}//end