//scrolling pref window

#include "textItem.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "stringGadget.h"
#include "intGadget.h"
#include "myButton.h"
#include "myPopUpMenu.h"
#include "myCheckBox.h"
#include "myTextView.h"
#include "myStringDrawer.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include "s2uint32.h"
#include "windowGuts.h"
#include "zipWindow.h"
#include <memory>
#include <string>

char * dashOptions[GUIZIP_CHECKBOXES] = 
{
	" -A",
	" -b",
	" -c",
	" -d",
	" -D",
	" -f",
	" -F",
	" -FF",
	" -g",
	" -i",
	" -j",
	" -J",
	" -k",
	" -l",
	" -ll",
	" -m",
	" -n",
	" -o",
	" -P",
	" -q",
	" -r",
	" -R",
	" -S",
	" -t",
	" -tt ",
	" -T",
	" -u",
	" -v",
	" -x",
	" -X",
	" -y",
	" -z",
	" -$"
};

uint32 checkBoxMsgs[GUIZIP_CHECKBOXES] = 
{
	GUIZIP_ADJUST,
	GUIZIP_TEMP_PATH,
	GUIZIP_ADD_FILE_COMMENT,
	GUIZIP_DELETE,
	GUIZIP_NO_DIRS,
	GUIZIP_FRESHEN,
	GUIZIP_FIX,
	GUIZIP_FFIX,
	GUIZIP_GROW,
	GUIZIP_SPECIFY,
	GUIZIP_NAMES,
	GUIZIP_STRIP,
	GUIZIP_MSDOS,
	GUIZIP_LF2CRLF,
	GUIZIP_CRLF2LF,
	GUIZIP_MOVE,
	GUIZIP_NO_COMPRESS,
	GUIZIP_OLDEST,
	GUIZIP_PASSWORD,
	GUIZIP_QUIET,
	GUIZIP_recursive,
	GUIZIP_RECURSIVE,
	GUIZIP_HIDDEN,
	GUIZIP_NOT_PRIOR,
	GUIZIP_NOT_AFTER,
	GUIZIP_TEST_INTEGRITY,
	GUIZIP_REPLACE,
	GUIZIP_VERBOSE,
	GUIZIP_EXCLUDE,
	GUIZIP_NO_ATTRIBUTES,
	GUIZIP_SYMBOLIC_LINKS,
	GUIZIP_ADD_COMMENT_TO_ARCHIVE,
	GUIZIP_VOLUME_LABEL
};

const char * checkBoxNames[GUIZIP_CHECKBOXES] =
{
	"GUIZIP_ADJUST",
	"GUIZIP_TEMP_PATH",
	"GUIZIP_ADD_FILE_COMMENT",
	"GUIZIP_DELETE",
	"GUIZIP_NO_DIRS",
	"GUIZIP_FRESHEN",
	"GUIZIP_FIX",
	"GUIZIP_FFIX",
	"GUIZIP_GROW",
	"GUIZIP_SPECIFY",
	"GUIZIP_NAMES",
	"GUIZIP_STRIP",
	"GUIZIP_MSDOS",
	"GUIZIP_LF2CRLF",
	"GUIZIP_CRLF2LF",
	"GUIZIP_MOVE",
	"GUIZIP_NO_COMPRESS",
	"GUIZIP_OLDEST",
	"GUIZIP_PASSWORD",
	"GUIZIP_QUIET",
	"GUIZIP_recursive",
	"GUIZIP_RECURSIVE",
	"GUIZIP_HIDDEN",
	"GUIZIP_NOT_PRIOR",
	"GUIZIP_NOT_AFTER",
	"GUIZIP_TEST_INTEGRITY",
	"GUIZIP_REPLACE",
	"GUIZIP_VERBOSE",
	"GUIZIP_EXCLUDE",
	"GUIZIP_NO_ATTRIBUTES",
	"GUIZIP_SYMBOLIC_LINKS",
	"GUIZIP_ADD_COMMENT_TO_ARCHIVE",
	"GUIZIP_VOLUME_LABEL"
};

const char * checkBoxLabels[GUIZIP_CHECKBOXES] =
{
	"-A Adjust self-extracting executable archive",
	"-b Use the specified path for the temporary archive",
	"-c Add one-line comments for each file",
	"-d Remove entries from a archive",
	"-D Do not create entries in the archive for directories",
	"-f Replace an existing entry only if it is newer than the version already in the archive",
	"-F Fix the archive",
	"-FF Special Fix for the archive",
	"-g Grow the specified archive",
	"-i Include only the specified files",
	"-j Store just the name of a saved file",
	"-J Strip any prepended data from the archive",
	"-k Convert the names and paths to conform to MSDOS",
	"-l Translate the Unix end-of-line character LF into the MSDOS convention CR LF",
	"-ll Translate the MSDOS end-of-line CR LF into Unix LF",
	"-m Move the specified files into the archive",
	"-n Do not compress files named with the given suffixes",
	"-o Set the last modified time of the archive to the latest last modified time of the entries in the archive",
	"-p Use password to encrypt entries",
	"-q Quiet, eliminate informational messages",
	"-r Travel the directory structure recursively",
	"-R Travel the directory structure recursively starting at the current directory",
	"-S Include system and hidden files",
	"-t Do not operate on files modified prior to the specified date",
	"-tt Do not operate on files modified after or at the specified date",
	"-T Test the integrity of the new archive",
	"-u Replace an existing entry in the archive only if it has been modified more recently than the version already in the archive",
	"-v Verbose mode or print diagnostic version info",
	"-x Explicitly exclude the specified files",
	"-X Do not save extra file attributes",
	"-y Store symbolic links as such in the archive",
	"-z Prompt for a multi-line comment for the entire archive",
	"-$ Include the volume label for the the drive holding the first file to be compressed"
};

#define NUM_LABELS 9
const char * textEntryLabels[NUM_LABELS] =
{
	"Temporary path: ",
	"Add archive comment: ",
	"Not prior to: ",
	"Not after: ",
	"Do Not compress: ",
	"Exclude: ",
	"Archive name: ",
	"Include: ",
	"File and Directories: "
};

const char * compressionStrings[10] = 
{
	"-#0 ",
	"-#1 ",
	"-#2 ",
	"-#3 ",
	"-#4 ",
	"-#5 ",
	"-#6 ",
	"-#7 ",
	"-#8 ",
	"-#9 "
};
const char * compressionLabels[10] = 
{
	"-#0 Compression Level 0 (least)",
	"-#1 Compression Level 1",
	"-#2 Compression Level 2",
	"-#3 Compression Level 3",
	"-#4 Compression Level 4",
	"-#5 Compression Level 5",
	"-#6 Compression Level 6",
	"-#7 Compression Level 7",
	"-#8 Compression Level 8",
	"-#9 Compression Level 9 (most)"
};
uint32 compressionMessages[10] = 
{
	'-#00',
	'-#11',
	'-#22',
	'-#33',
	'-#44',
	'-#55',
	'-#66',
	'-#77',
	'-#88',
	'-#99'
};
	
//ctor 
ZipWindow	::	ZipWindow(	BRect			paramBound,
							const char *	ccpparamWindowTitle,
							const char *	ccpparamScrollViewName,
							const char *	ccpparamNamePrefFrame)
			: 
				WindowGuts(	paramBound, 
							ccpparamWindowTitle, 
							ccpparamScrollViewName,
							ccpparamNamePrefFrame),
				mui32cmpressionLevel(6)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning("Could not create_sem.\n");
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		BWindow bw(	BRect(0, 0, 32, 32), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
		BView bv(BRect(0, 0, 32, 32), "zipWindowView", B_FOLLOW_NONE, B_WILL_DRAW);
		bw.AddChild(&bv);
		bv.SetFont(myPrefs->GetPreferredFont());
		float maxWidth = bv.StringWidth(textEntryLabels[0]);
		float stringEntryPixWidth;
		for (int i = 1; i < NUM_LABELS; i++)
		{
			stringEntryPixWidth = bv.StringWidth(textEntryLabels[i]);
			if (stringEntryPixWidth > maxWidth)
			{
				maxWidth = stringEntryPixWidth;
			}
		}
		stringEntryPixWidth = maxWidth;
		font_height	fontHeight;
		bv.GetFontHeight(&fontHeight);
		float stringEntryPixHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		bv.RemoveSelf();
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apCheckboxesLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 36, 1));//rows,columns
		LayoutMatrix *	pholdZipLayoutMatrix = apCheckboxesLayoutMatrix.get();
		apCheckboxesLayoutMatrix.release();
		AddToLayoutMatrixList(pholdZipLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFont(new BFont());//note-- using system be_plain_font
		BFont * pBFont = apBFont.get();//NOT preferredFont(), just for something different
		apBFont.release();
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		auto_ptr<MyStringDrawer> apTitleMyStringDrawer(new MyStringDrawer(	 "optionsMyStringDrawer", 
																		"GUIZip options", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFont));
		MyStringDrawer * pTitleMyStringDrawer = apTitleMyStringDrawer.get();
		apTitleMyStringDrawer.release();
		pholdZipLayoutMatrix->AddToChildren((void *)pTitleMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apTitleMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)pTitleMyStringDrawer, 
																								pholdZipLayoutMatrix->itemsList,
																								KIND_STRINGDRAWER));
///////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> licenseMsg(new BMessage(GUIZIP_LICENSE));
		auto_ptr<MyButton> apLicenseMyButton(new MyButton(	 
															"licenseZipButton", 
															"Display license", 
															licenseMsg.get(), 
															B_FOLLOW_NONE, 
															B_WILL_DRAW));
		licenseMsg.release();
		MyButton * pholdLicenseMyButton = apLicenseMyButton.get();
		apLicenseMyButton.release();
		pholdLicenseMyButton->SetFont(myPrefs->GetPreferredFont());
		pholdZipLayoutMatrix->AddToChildren((void *)pholdLicenseMyButton);
		auto_ptr<LayoutMatrixItem> apLicenseMyButtonLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)pholdLicenseMyButton, 
																								pholdZipLayoutMatrix->itemsList,
																								KIND_MYBUTTON));
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> helpMsg(new BMessage(GUIZIP_HELP));
		auto_ptr<MyButton> apHelpMyButton(new MyButton(	"helpZipButton", 
																	"Display help", 
																	helpMsg.get(), 
																	B_FOLLOW_NONE, 
																	B_WILL_DRAW));
		helpMsg.release();
		MyButton * pholdHelpMyButton = apHelpMyButton.get();
		apHelpMyButton.release();
		pholdHelpMyButton->SetFont(myPrefs->GetPreferredFont());
		pholdZipLayoutMatrix->AddToChildren((void *)pholdHelpMyButton);
		auto_ptr<LayoutMatrixItem> apHelpMyButtonLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pholdHelpMyButton, 
																							pholdZipLayoutMatrix->itemsList,
																							KIND_MYBUTTON));
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
		LayoutMatrixItem * checkBoxesLayoutMatrixItem[GUIZIP_CHECKBOXES];
		uint32 iCheckBox;
		for (iCheckBox = 0; iCheckBox < GUIZIP_CHECKBOXES; iCheckBox++)
		{
			BMessage * checkBoxesMsg = new BMessage(checkBoxMsgs[iCheckBox]);
			mpCheckBoxes[iCheckBox] = new MyCheckBox(	checkBoxNames[iCheckBox], 
															checkBoxLabels[iCheckBox], 
															checkBoxesMsg, 
															B_FOLLOW_NONE, 
															B_WILL_DRAW);
			mpCheckBoxes[iCheckBox]->SetFont(myPrefs->GetPreferredFont());
			pholdZipLayoutMatrix->AddToChildren((void *)mpCheckBoxes[iCheckBox]);
			checkBoxesLayoutMatrixItem[iCheckBox] = new LayoutMatrixItem(	&bw, 
																			(void *)mpCheckBoxes[iCheckBox], 
																			pholdZipLayoutMatrix->itemsList,
																			KIND_MYCHECKBOX);
		}
		mpCheckBoxes[2]->SetEnabled(false);//these 5 are not possible via GUI???
		mpCheckBoxes[18]->SetEnabled(false);
		mpCheckBoxes[19]->SetEnabled(false);
		mpCheckBoxes[27]->SetEnabled(false);
		mpCheckBoxes[31]->SetEnabled(false);
		checkBoxesLayoutMatrixItem[--iCheckBox]->last = true;
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apArchiveNameLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 1, 1));//rows,columns
		LayoutMatrix *	pholdArchiveNameLayoutMatrix = apArchiveNameLayoutMatrix.get();
		apArchiveNameLayoutMatrix.release();
		AddToLayoutMatrixList(pholdArchiveNameLayoutMatrix);
///////////////////////////////////////////////
	auto_ptr<BMessage> apArchiveNameMsg(new BMessage(GUIZIP_ARCHIVE_NAME));
	auto_ptr<StringGadget> apArchiveNameGadget(new StringGadget(	BRect(0, 0, 32, 32), 
															"archiveName", 
															textEntryLabels[6], 
															NULL, 
															apArchiveNameMsg.get(), 
															B_FOLLOW_NONE, 
															B_WILL_DRAW | B_NAVIGABLE,
															stringEntryPixWidth));
	apArchiveNameMsg.release();
	StringGadget * pholdArchiveNameGadget = (StringGadget *)apArchiveNameGadget.get();
	apArchiveNameGadget.release();
	pholdArchiveNameGadget->SetFont(myPrefs->GetPreferredFont());
	auto_ptr<LayoutMatrixItem> apArchiveNameLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pholdArchiveNameGadget, 
																					pholdArchiveNameLayoutMatrix->itemsList,
																					KIND_STRINGGADG));
	pholdArchiveNameLayoutMatrix->AddToChildren((void *)pholdArchiveNameGadget);
	ArchiveNameGadget = pholdArchiveNameGadget;
/////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apFileStringLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		LayoutMatrix *	pholdFileStringLayoutMatrix = apFileStringLayoutMatrix.get();
		apFileStringLayoutMatrix.release();
		AddToLayoutMatrixList(pholdFileStringLayoutMatrix);
///////////////////////////////////////////////
	auto_ptr<BMessage> apFileStringMsg(new BMessage(GUIZIP_FILEDIR_STR));
	auto_ptr<StringGadget> apFileStringGadget(new StringGadget(	BRect(0, 0, 32, 32), 
															"fileDir", 
															textEntryLabels[8], 
															NULL, 
															apFileStringMsg.get(), 
															B_FOLLOW_NONE, 
															B_WILL_DRAW | B_NAVIGABLE,
															stringEntryPixWidth));
	apFileStringMsg.release();
	StringGadget * pholdFileStringGadget = (StringGadget *)apFileStringGadget.get();
	apFileStringGadget.release();
	pholdFileStringGadget->SetFont(myPrefs->GetPreferredFont());
	auto_ptr<LayoutMatrixItem> apFileStringLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pholdFileStringGadget, 
																					pholdFileStringLayoutMatrix->itemsList,
																					KIND_STRINGGADG));
	pholdFileStringLayoutMatrix->AddToChildren((void *)pholdFileStringGadget);
	FileStringGadget = pholdFileStringGadget;
//////////////////////////////////////////////////
	BList * pumbl = new BList();
	PopUpMenuData  * pumd[10];
	for (uint32 i = 0; i < 10; i++)
	{
		pumd[i] = new PopUpMenuData();
		pumd[i]->ui32mMsg = compressionMessages[i];
		pumd[i]->ccpmLabel = compressionLabels[i];
		pumbl->AddItem((void *)pumd[i]);
	}
	MyPopUpMenu * pum = new MyPopUpMenu("compressPUM", "-#6 Compression Level 6", pumbl, true);
	bool success = pum->Initialize();
	if (!success) 
	{
		warning("PopUpMenu failed Initialize() for zipWindow./n");
	}
	pholdFileStringLayoutMatrix->AddToChildren((void *)pum);
	auto_ptr<LayoutMatrixItem> apPopUpMenuLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pum, 
																					pholdFileStringLayoutMatrix->itemsList,
																					KIND_MYPOPUPMENU));
///////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apTempPathLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 1, 1));//rows,columns
		LayoutMatrix *	pholdTempPathLayoutMatrix = apTempPathLayoutMatrix.get();
		apTempPathLayoutMatrix.release();
		AddToLayoutMatrixList(pholdTempPathLayoutMatrix);
///////////////////////////////////////////////
	auto_ptr<BMessage> apTempPathMsg(new BMessage(GUIZIP_TEMP_PATH_STR));
	auto_ptr<StringGadget> apTempPathGadget(new StringGadget(	BRect(0, 0, 32, 32), 
														"tempPath", 
														textEntryLabels[0], 
														NULL, 
														apTempPathMsg.get(), 
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														stringEntryPixWidth));
	apTempPathMsg.release();
	StringGadget * pholdTempPathGadget = (StringGadget *)apTempPathGadget.get();
	apTempPathGadget.release();
	pholdTempPathGadget->SetFont(myPrefs->GetPreferredFont());
	auto_ptr<LayoutMatrixItem> apTempPathLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																				(void *)pholdTempPathGadget, 
																				pholdTempPathLayoutMatrix->itemsList,
																				KIND_STRINGGADG));
	pholdTempPathLayoutMatrix->AddToChildren((void *)pholdTempPathGadget);
	TempPathGadget = pholdTempPathGadget;
///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apNoPriorLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 1, 1));//rows,columns
		LayoutMatrix *	pholdNoPriorLayoutMatrix = apNoPriorLayoutMatrix.get();
		apNoPriorLayoutMatrix.release();
		AddToLayoutMatrixList(pholdNoPriorLayoutMatrix);
///////////////////////////////////////////////
	auto_ptr<BMessage> apNoPriorMsg(new BMessage(GUIZIP_NOT_PRIOR_STR));
	auto_ptr<StringGadget> apNoPriorGadget(new StringGadget(	BRect(0, 0, 32, 32), 
														"noPrior", 
														textEntryLabels[2], 
														NULL, 
														apNoPriorMsg.get(), 
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														stringEntryPixWidth));
	apNoPriorMsg.release();
	StringGadget * pholdNoPriorGadget = (StringGadget *)apNoPriorGadget.get();
	apNoPriorGadget.release();
	pholdNoPriorGadget->SetFont(myPrefs->GetPreferredFont());
	auto_ptr<LayoutMatrixItem> apNoPriorLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																				(void *)pholdNoPriorGadget, 
																				pholdNoPriorLayoutMatrix->itemsList,
																				KIND_STRINGGADG));
	pholdNoPriorLayoutMatrix->AddToChildren((void *)pholdNoPriorGadget);
	NoPriorGadget = pholdNoPriorGadget;
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apNoAfterLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 1, 1));//rows,columns
		LayoutMatrix *	pholdNoAfterLayoutMatrix = apNoAfterLayoutMatrix.get();
		apNoAfterLayoutMatrix.release();
		AddToLayoutMatrixList(pholdNoAfterLayoutMatrix);
///////////////////////////////////////////////
	auto_ptr<BMessage> apNoAfterMsg(new BMessage(GUIZIP_NOT_AFTER_STR));
	auto_ptr<StringGadget> apNoAfterGadget(new StringGadget(	BRect(0, 0, 32, 32), 
														"noAfter", 
														textEntryLabels[3], 
														NULL, 
														apNoAfterMsg.get(), 
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														stringEntryPixWidth));
	apNoAfterMsg.release();
	StringGadget * pholdNoAfterGadget = (StringGadget *)apNoAfterGadget.get();
	apNoAfterGadget.release();
	pholdNoAfterGadget->SetFont(myPrefs->GetPreferredFont());
	auto_ptr<LayoutMatrixItem> apNoAfterLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																				(void *)pholdNoAfterGadget, 
																				pholdNoAfterLayoutMatrix->itemsList,
																				KIND_STRINGGADG));
	pholdNoAfterLayoutMatrix->AddToChildren((void *)pholdNoAfterGadget);
	NoAfterGadget = pholdNoAfterGadget;
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apNoCompressLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 1, 1));//rows,columns
		LayoutMatrix *	pholdNoCompressLayoutMatrix = apNoCompressLayoutMatrix.get();
		apNoCompressLayoutMatrix.release();
		AddToLayoutMatrixList(pholdNoCompressLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	auto_ptr<BMessage> apNoCompressMsg(new BMessage(GUIZIP_NO_COMPRESS_STR));
	auto_ptr<StringGadget> apNoCompressGadget(new StringGadget(	BRect(0, 0, 32, 32), 
															"noCompress", 
															textEntryLabels[4], 
															NULL, 
															apNoCompressMsg.get(), 
															B_FOLLOW_NONE, 
															B_WILL_DRAW | B_NAVIGABLE,
															stringEntryPixWidth));
	apNoCompressMsg.release();
	StringGadget * pholdNoCompressGadget = (StringGadget *)apNoCompressGadget.get();
	apNoCompressGadget.release();
	pholdNoCompressGadget->SetFont(myPrefs->GetPreferredFont());
	auto_ptr<LayoutMatrixItem> apNoCompressLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pholdNoCompressGadget, 
																					pholdNoCompressLayoutMatrix->itemsList,
																					KIND_STRINGGADG));
	pholdNoCompressLayoutMatrix->AddToChildren((void *)pholdNoCompressGadget);
	NoCompressGadget = pholdNoCompressGadget;
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apExcludeLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		LayoutMatrix *	pholdExcludeLayoutMatrix = apExcludeLayoutMatrix.get();
		apExcludeLayoutMatrix.release();
		AddToLayoutMatrixList(pholdExcludeLayoutMatrix);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apExcludeFont(new BFont(myPrefs->GetPreferredFont()));
		BFont * pExcludeFont = apExcludeFont.get();
		apExcludeFont.release();
		auto_ptr<MyStringDrawer> apExcludeMyStringDrawer(new MyStringDrawer(	"exclude", 
																				textEntryLabels[5], 
																				B_FOLLOW_NONE, 
																				B_WILL_DRAW,
																				pExcludeFont));
		MyStringDrawer * pExcludeMyStringDrawer = apExcludeMyStringDrawer.get();
		apExcludeMyStringDrawer.release();
		pholdExcludeLayoutMatrix->AddToChildren((void *)pExcludeMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apExcludeMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																									(void *)pExcludeMyStringDrawer, 
																									pholdExcludeLayoutMatrix->itemsList,
																									KIND_STRINGDRAWER));

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//debug	auto_ptr<BMessage> apExcludeMsg(new BMessage(GUIZIP_EXCLUDE_TV));
	auto_ptr<MyTextView> apExcludeGadget(new MyTextView(	"exclude", 
														NULL, 
														stringEntryPixWidth,
														6 * stringEntryPixHeight));
//debug	apExcludeMsg.release();
	MyTextView * pholdExcludeGadget = (MyTextView *)apExcludeGadget.get();
	apExcludeGadget.release();
	pholdExcludeGadget->SetFont(myPrefs->GetPreferredFont());
	auto_ptr<LayoutMatrixItem> apExcludeLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																				(void *)pholdExcludeGadget, 
																				pholdExcludeLayoutMatrix->itemsList,
																				KIND_MYTEXTVIEW));
	pholdExcludeLayoutMatrix->AddToChildren((void *)pholdExcludeGadget);
	pholdExcludeGadget->SetMaxBytes(256);
	ExcludeGadget = pholdExcludeGadget;
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apIncludeLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		LayoutMatrix *	pholdIncludeLayoutMatrix = apIncludeLayoutMatrix.get();
		apIncludeLayoutMatrix.release();
		AddToLayoutMatrixList(pholdIncludeLayoutMatrix);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apIncludeFont(new BFont(myPrefs->GetPreferredFont()));
		BFont * pIncludeFont = apIncludeFont.get();
		apIncludeFont.release();
		auto_ptr<MyStringDrawer> apIncludeMyStringDrawer(new MyStringDrawer(	"includeStr", 
																				textEntryLabels[7], 
																				B_FOLLOW_NONE, 
																				B_WILL_DRAW,
																				pIncludeFont));
		MyStringDrawer * pIncludeMyStringDrawer = apIncludeMyStringDrawer.get();
		apIncludeMyStringDrawer.release();
		pholdIncludeLayoutMatrix->AddToChildren((void *)pIncludeMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apIncludeMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																									(void *)pIncludeMyStringDrawer, 
																									pholdIncludeLayoutMatrix->itemsList,
																									KIND_STRINGDRAWER));
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//debug	auto_ptr<BMessage> apIncludeMsg(new BMessage(GUIZIP_INCLUDE_TV));
	auto_ptr<MyTextView> apIncludeGadget(new MyTextView(	"include", 
														NULL, 
														stringEntryPixWidth,
														7 * stringEntryPixHeight));
//debug	apIncludeMsg.release();
	MyTextView * pholdIncludeGadget = (MyTextView *)apIncludeGadget.get();
	apIncludeGadget.release();
	pholdIncludeGadget->SetFont(myPrefs->GetPreferredFont());
	auto_ptr<LayoutMatrixItem> apIncludeLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																				(void *)pholdIncludeGadget, 
																				pholdIncludeLayoutMatrix->itemsList,
																				KIND_MYTEXTVIEW));
	pholdIncludeLayoutMatrix->AddToChildren((void *)pholdIncludeGadget);
	pholdIncludeGadget->SetMaxBytes(256);
	IncludeGadget = pholdIncludeGadget;
///////////////////////////////////////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdZipLayoutMatrix->Calc(	(2 * stringEntryPixWidth) + 10 + (2 * MATRIXHORIZONTALOFFSET), 
									MATRIXVERTICALOFFSET, 
									calc_sem);
		pholdArchiveNameLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
											pholdLicenseMyButton->Frame().top - 2, 
											calc_sem);
		pholdFileStringLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
											pholdArchiveNameLayoutMatrix->bottom, 
											calc_sem);
		pholdTempPathLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
											mpCheckBoxes[1]->Frame().top - 2, 
											calc_sem);
		pholdNoPriorLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
										mpCheckBoxes[23]->Frame().top - 2, 
										calc_sem);
		pholdNoAfterLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
										mpCheckBoxes[24]->Frame().top - 2, 
										calc_sem);
		pholdNoCompressLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
											mpCheckBoxes[16]->Frame().top - 2, 
											calc_sem);
		pholdExcludeLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
										mpCheckBoxes[28]->Frame().top - 2, 
										calc_sem);
		pholdIncludeLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
										mpCheckBoxes[9]->Frame().top - 2, 
										calc_sem);
	}
	catch (...)
	{
		release_sem(calc_sem);
		throw;
	}
	BMenuItem *	menuItem;
	BMenu *		appMenu = new BMenu("app");
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(ABOUT_ZIPWINDOW));
		menuItem = new BMenuItem(	"about...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	appMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(B_QUIT_REQUESTED));
		menuItem = new BMenuItem(	"Close panel", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	appMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(QUIT_FROM_ZIP_PANEL));
		menuItem = new BMenuItem(	"Quit", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	appMenu->AddItem(menuItem);
	pMenuBar->AddItem(appMenu);
}//end


//dtor
ZipWindow	::	~ZipWindow() 
{
	if (be_app)//this check is almost for sure not needed!
	{
		myApp->pZipWindow = NULL;
	}
}//end


void
ZipWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case '-#00':
			mui32cmpressionLevel = 0;
		break;
		case '-#11':
			mui32cmpressionLevel = 1;
		break;
		case '-#22':
			mui32cmpressionLevel = 2;
		break;
		case '-#33':
			mui32cmpressionLevel = 3;
		break;
		case '-#44':
			mui32cmpressionLevel = 4;
		break;
		case '-#55':
			mui32cmpressionLevel = 5;
		break;
		case '-#66':
			mui32cmpressionLevel = 6;
		break;
		case '-#77':
			mui32cmpressionLevel = 7;
		break;
		case '-#88':
			mui32cmpressionLevel = 8;
		break;
		case '-#99':
			mui32cmpressionLevel = 9;
		break;
		case ABOUT_ZIPWINDOW:	
		{
			warning("about Zip window\n");
		break;
		}
		case GUIZIP_LICENSE:	
		{
			warning("Zip license\n");
		break;
		}
		
		case GUIZIP_HELP:	
		{
			warning("Zip help\n");
		break;
		}
		case QUIT_FROM_ZIP_PANEL:
		{
			myApp->PostMessage(B_QUIT_REQUESTED);
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
ZipWindow	::	QuitRequested() 
{
	string spZipCommand = "zip ";
	spZipCommand += ArchiveNameGadget->Text();
	spZipCommand += ".zip ";
	for (uint32 i = 0; i < GUIZIP_CHECKBOXES; i++)
	{
		if (mpCheckBoxes[i]->Value() == B_CONTROL_ON) {
			spZipCommand += dashOptions[i];
			switch (i)
			{
				case 1:
				{
					spZipCommand += TempPathGadget->Text();
				break;
				}
				case 2:
				{
					spZipCommand += ArchiveNameGadget->Text();
				break;
				}
				case 9:
				{
					try
					{
						int32 maxBytesInInclude;
						maxBytesInInclude = IncludeGadget->MaxBytes();
						char * includeBuf = new char[maxBytesInInclude + 1];//probably do not need the extra one
						IncludeGadget->GetText(0, maxBytesInInclude, includeBuf);
						includeBuf[maxBytesInInclude] = '\0';//just in case final byte is a cr/lf
						for (int32 i = 0; i < maxBytesInInclude; i++)
						{
							if (includeBuf[i] == 0x0A)//cr?lf??
							{
								includeBuf[i] = 0x20;//space
							}
						}
						spZipCommand += includeBuf;
						delete [] includeBuf;
					}
					catch (...)
					{
						throw;
					}
				break;
				}
				case 18:
				{
					spZipCommand += NoCompressGadget->Text();
				break;
				}
				case 23:
				{
					spZipCommand += NoPriorGadget->Text();
				break;
				}
				case 24:
				{
					spZipCommand += NoAfterGadget->Text();
				break;
				}
				case 28:
				{
					try
					{
						int32 maxBytesInExclude;
						maxBytesInExclude = ExcludeGadget->MaxBytes();
						char * excludeBuf = new char[maxBytesInExclude + 1];//probably do not need the extra one
						ExcludeGadget->GetText(0, maxBytesInExclude, excludeBuf);
						excludeBuf[maxBytesInExclude] = '\0';//just in case final byte is a cr/lf
						for (int32 i = 0; i < maxBytesInExclude; i++)
						{
							if (excludeBuf[i] == 0x0A)//cr?lf??
							{
								excludeBuf[i] = 0x20;//space
							}
						}
						spZipCommand += excludeBuf;
						delete [] excludeBuf;
					}
					catch (...)
					{
						throw;
					}
				break;
				}
			}
			spZipCommand += " ";
		}
	}
	spZipCommand += compressionStrings[mui32cmpressionLevel];
	spZipCommand += FileStringGadget->Text();
	warning("Outputs only a shell command!\nRun GUIZip from a Terminal.\nUse the mouse to select and paste the command string!\n");//debug
	printf("%s\n", spZipCommand.c_str());
	BRect frame = Frame();
	myApp->SetPreferredZipWindowRect(frame);
	return(WindowGuts::QuitRequested());
}//end