//
//
//	Command test application
//
//								(C) Alain Gautherot 1999

#if defined(DEBUG_COMMAND)

#include "Homer.h"
#include "HomerMime.h"
#include "CommandTest.h"
#include "MessagesWindow.h"
#include <stdio.h>


//---------------------------------------------------------
int					main()
{
	CommandTestApp*	app = new CommandTestApp();
	app->Run();
	delete app;
	return 0;
}


//---------------------------------------------------------
CommandTestApp::CommandTestApp()
: BApplication(HOMER_COMMAND_SIGNATURE)
{
	CommandTestWin*		win;
	win = new CommandTestWin();
	win->Show();
}

CommandTestApp::~CommandTestApp()
{}

void
CommandTestApp::RefsReceived(BMessage* msg)
{
	BWindow*		win = WindowAt(0);
	if (win)
		win->PostMessage(msg);
}


//---------------------------------------------------------
CommandTestWin::CommandTestWin()
: BWindow(BRect(0, 0, 10, 10), "default", B_TITLED_WINDOW,
			B_NOT_ZOOMABLE)
{
	char*				title = new char[strlen(addonName)+10];

	hfc = instantiate_command();
	strcpy(title, "command: ");
	hview = hfc->CommandView();
	strcat(title, addonName);
	SetTitle(title);
	delete[] title;

	hview->MoveTo(5, 5);
	BRect				fr = hview->Bounds();
	fr.InsetBy(-10, -10);
	fr.OffsetBy(200, 160);
	AddChild(hview);
	this->MoveTo(fr.LeftTop());
	this->ResizeTo(fr.Width(), fr.Height());

	//-------------------------------------------------------------
	fr.Set(0, 0, 400, 250);
	fr.OffsetBy(200, 150);
	msgWindow = new MessagesWindow(fr, "add-on messages", B_TITLED_WINDOW, 0);//B_NOT_CLOSABLE);

	// use preferences
	BMessage			prefs;
	if (Homer::ReadPrefs(&prefs) == B_OK)
	{
		if (prefs.FindRect("messages_frame", &fr) == B_OK)
		{
			msgWindow->MoveTo(fr.LeftTop());
			msgWindow->ResizeTo(fr.Width(), fr.Height());
		}
	}

	msgWindow->Run();
}

CommandTestWin::~CommandTestWin()
{
	delete hfc;
}

void
CommandTestWin::MessageReceived(BMessage* msg)
{
	if (msg->HasRef("refs"))
	{
		uint32				type;
		int32				nbRefs;
		entry_ref			ref;

		msg->GetInfo("refs", &type, &nbRefs);
		if (type != B_REF_TYPE)
			return ;

		for (int32 i = 0; i < nbRefs; i++)
		{
			if (msg->FindRef("refs", i, &ref) == B_OK)
			{
				BMessage		param;
				if (hfc->GetConfig(&param, hview) != B_OK)
				{
					printf("** GetConfig\n");
					continue;
				}
				printf("command %s(%s): %d\n", addonName, ref.name,
						hfc->Process(ref, &param, msgWindow));
				param.MakeEmpty();
			}
		}
		return;
	}
	if (msg->HasPointer("HomerTarget"))
	{
		BView*			v = NULL;
		if (msg->FindPointer("HomerTarget", &v) == B_OK)
			v->MessageReceived(msg);
		return ;
	}

	BWindow::MessageReceived(msg);
}


bool
CommandTestWin::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	msgWindow->AllowQuit(true);
	return true;
}

#else

#include <kernel/image.h>

int main()
{
	int32			argc = 0;
	const char*		argv[3];

	// run "alert" command
	argv[argc++] = "/bin/alert";
	argv[argc++] = "Homer command was not compiled in debug mode\n(use -DDEBUG_COMMAND)";
	argv[argc] = NULL;

	status_t		st;
	thread_id		tid = load_image(argc, argv, NULL);
	wait_for_thread(tid, &st);

	return 0;
}

#endif /* DEBUG_COMMAND */
