//TextEdWindow.cpp

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <sys/types.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include <FilePanel.h>
#include <Resources.h>
#include <Path.h>
#include "DtinySnooze.h"
#include "DnumSpecificWindows.h"
#include "Preferences.h"
#include "myPreferences.h"
#include "warning.h"
#include "windowGuts.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "myCheckBox.h"
#include "floatGadget.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myPopUpMenu.h"
#include "myPictureButton.h"
#include "myColorControl.h"
#include "myStatusBar.h"
#include "myRadioView.h"
#include "myTextView.h"
#include "mySpacer.h"
#include "DmenuMsg.h"
#include "myroColour.h"
#include "verify.h"
#include "s2f.h"
#include "ToolBox2ToolPaletteWindow.h"
#include "ToolBox2TextEdWindow.h"
#include "ToolBox2App.h"

//ctor
TextEdWindow	::	TextEdWindow(	BRect paramBound,
								const char * paramWindowTitle,
								const char * paramScrollViewName,
								const char * paramNamePrefFrame)
			: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame,
							myApp->AppSignature,
							myApp->mpPreferenceSet),
				pToolPaletteWindow(NULL),
				mpTextView(NULL),
				mpToolPaletteButtonWidth(NULL),
				mpToolPaletteButtonHeight(NULL),
				mpDisplayFontCheckBox(NULL)
				
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(myApp->FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pTextEdLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////
		const float cfEditWidth = 300;
		const float cfEditHeight = 200;
		rgb_color textColor;
		myPrefs->GetPreferredMyTextViewHighColor(&textColor);
		const char * textBuf = "You will have to devise your method of allocating, filling and eventually deleting the real buffer";
		mpTextView = new MyTextView(	NULL, 
										textBuf, 
										cfEditWidth,
										cfEditHeight,
										pTextEdLayoutMatrix);
		mpTextView->SetFontAndColor(	myPrefs->GetPreferredFont(), 
										B_FONT_ALL, 
										&textColor);
		mpTextView->SetResizingMode(B_FOLLOW_ALL);
/////////////////////////////////////////////////
		LayoutMatrix *	pButtonSizeLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
/////////////////////
		mpToolPaletteButtonWidth = new FloatGadget(	myApp->GetToolPaletteButtonWidth(),
													"tpbWidth", 
													myApp->tpbWidth, 
													TPBWIDTHMSG,
													0,
													pButtonSizeLayoutMatrix);
		mpToolPaletteButtonWidth->SetResizingMode(B_FOLLOW_BOTTOM);
/////////////////
		mpToolPaletteButtonHeight = new FloatGadget(	myApp->GetToolPaletteButtonHeight(),
														"tpbHeight", 
														myApp->tpbHeight, 
														TPBHEIGHTMSG,
														0,
														pButtonSizeLayoutMatrix);
		mpToolPaletteButtonHeight->SetResizingMode(B_FOLLOW_BOTTOM);
////////////////
		LayoutMatrix *	pToolPalletteCBLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
////////////////////////////////////////////////
		mpDisplayFontCheckBox = new MyCheckBox(	"displayToolPalette", 
												myApp->DisplayTPCBoxLabel,
												myApp->GetDisplayToolPalette(),
												TOOLPALETTEDISPLAY,
												pToolPalletteCBLayoutMatrix);
		mpDisplayFontCheckBox->SetResizingMode(B_FOLLOW_BOTTOM);
//////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pTextEdLayoutMatrix->Calc(3, 3, calc_sem);
		pButtonSizeLayoutMatrix->Calc(3, pTextEdLayoutMatrix->bottom + 3, calc_sem);
		pToolPalletteCBLayoutMatrix->Calc(3, pButtonSizeLayoutMatrix->bottom + 3, calc_sem);
	}
	catch (...)
	{
		warning(myApp->CaughtTextEdWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(myApp->AppMenuLabel);
		menuItem = new BMenuItem(	myPrefs->AboutMenuLabel, 
									new BMessage(ABOUT_TEXTEDWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->PreferenceMenuLabel, 
									new BMessage(PREFSMSG));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myApp->CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myApp->QuitMenuLabel, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch (...)
	{
		warning(myApp->CaughtTextEdWindowCTOR);
		throw;
	}
	if (myApp->GetDisplayToolPalette())
	{
		OpenToolPaletteWindow();
	}
}//end


//dtor
TextEdWindow	::	~TextEdWindow() 
{
	myApp->pTextEdWindow = NULL;
	if (!myPrefs->bPrefChangesMade)
	{
		myApp->PostMessage(B_QUIT_REQUESTED);
	}
}//end


void
TextEdWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_TEXTEDWINDOW:	
		{
			BString warn = myApp->AboutTextEdWindowMsg1;
			warn += myApp->AboutTextEdWindowMsg2;
			warn += myApp->AboutTextEdWindowMsg3;
			warning(warn.String());
		}
		break;
		case TOOLPALETTEDISPLAY:
			myApp->SetDisplayToolPalette(mpDisplayFontCheckBox->Value());
			if (myApp->GetDisplayToolPalette())
			{
				if (!pToolPaletteWindow)
				{
					OpenToolPaletteWindow();
				}
				else
				{
					pToolPaletteWindow->Activate();
				}
			}
			else
			{
				if (pToolPaletteWindow)
				{
					pToolPaletteWindow->PostMessage(B_QUIT_REQUESTED);
				}
			}
		break;
		case TPBWIDTHMSG:
		{
			float fSize = s2f(mpToolPaletteButtonWidth->Text());
			if (fSize != myApp->GetToolPaletteButtonWidth())
			{
				bool failed = false;
				if (fSize < MINPBWIDTH)
				{
					warning(myApp->FailMinPBWidth);
					failed = true;
				}
				else if (fSize > MAXPBWIDTH)
				{
					warning(myApp->FailMaxPBWidth);
					failed = true;
				}
				else
				{
					myApp->SetToolPaletteButtonWidth(fSize);
					OpenToolPaletteWindow();
				}
				if (failed)
				{
					char fString[256];//debug how much storage do I need for a float???
					sprintf(fString, "%f", myApp->GetToolPaletteButtonWidth());
					mpToolPaletteButtonWidth->SetText(fString);
				}
			}
		}
		break;
		case TPBHEIGHTMSG:
		{
			float fSize = s2f(mpToolPaletteButtonHeight->Text());
			if (fSize != myApp->GetToolPaletteButtonHeight())
			{
				bool failed = false;
				if (fSize < MINPBWIDTH)
				{
					warning(myApp->FailMinPBHeight);
					failed = true;
				}
				else if (fSize > MAXPBWIDTH)
				{
					warning(myApp->FailMaxPBHeight);
					failed = true;
				}
				else
				{
					myApp->SetToolPaletteButtonHeight(fSize);
					OpenToolPaletteWindow();
				}
				if (failed)
				{
					char fString[256];//debug how much storage do I need for a float???
					sprintf(fString, "%f", myApp->GetToolPaletteButtonHeight());
					mpToolPaletteButtonHeight->SetText(fString);
				}
			}
		}
		break;
		case QUIT_APP:
			if (Verify(myApp->ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case PREFSMSG:
			myPrefs->OpenPreferencesPanel();
		break;
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
TextEdWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myApp->SetPreferredTextEdWindowRect(frame);
	float fSize = s2f(mpToolPaletteButtonWidth->Text());
	if (fSize != myApp->GetToolPaletteButtonWidth())
	{
		if (fSize < MINPBWIDTH)
		{
			warning(myApp->FailMinPBWidth);
		}
		else if (fSize > MAXPBWIDTH)
		{
			warning(myApp->FailMaxPBWidth);
		}
		else
		{
			myApp->SetToolPaletteButtonWidth(fSize);
		}
	}
	fSize = s2f(mpToolPaletteButtonHeight->Text());
	if (fSize != myApp->GetToolPaletteButtonHeight())
	{
		if (fSize < MINPBHEIGHT)
		{
			warning(myApp->FailMinPBHeight);
		}
		else if (fSize > MAXPBHEIGHT)
		{
			warning(myApp->FailMaxPBHeight);
		}
		else
		{
			myApp->SetToolPaletteButtonHeight(fSize);
		}
	}
	if (pToolPaletteWindow)
	{
		pToolPaletteWindow->PostMessage(B_QUIT_REQUESTED);
	}
	return(WindowGuts::QuitRequested());
}//end

void
TextEdWindow	::	OpenToolPaletteWindow(	void)
{
	int timeOut = 0;
	while (pToolPaletteWindow && (timeOut < 50)) 
	{
		if (pToolPaletteWindow->PostMessage(B_QUIT_REQUESTED))
		{
			pToolPaletteWindow = NULL;
		}
		else
		{
			snooze(TINYSNOOZE);
			timeOut++;
		}
	}
	if (!pToolPaletteWindow) 
	{
		try 
		{
			BRect holdRect;
			myApp->GetPreferredToolPaletteWindowRect(&holdRect);
			pToolPaletteWindow = new ToolPaletteWindow(	holdRect,
														NULL,//ToolPaletteWindowTitle,
														"titleWindow",
														"ToolPaletteWindowFrame");
			pToolPaletteWindow->Initialize();
		}
		catch (...)
		{
			warning(myApp->CaughtToolPaletteWindowCTOR);
			PostMessage(B_QUIT_REQUESTED);
		}
	}
}//end