//layoutMatrix.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "uInt32Gadget.h"
#include "floatGadget.h"
#include "stringGadget.h"
#include "warning.h"
#include "colorWell.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myPopUpMenu.h"
#include "myRadioView.h"
#include "myTextView.h"
#include "myListView.h"
#include "layoutMatrix.h"
#include "layoutMatrixItem.h"
#include "Preferences.h"
#include "myPreferences.h"
#include "myColorControl.h"
#include "mySpacer.h"
#include "windowGuts.h"

//ctor
LayoutMatrix	::	LayoutMatrix(	const uint32 ui32paramFlags, 
									const uint32 ui32paramRows, 
									const uint32 ui32paramColumns,
									WindowGuts * wpparamWindowGuts)
				: 	itemsList(new BList()),
					mpChildrenToAdd(new BList()),
					mpItemsToDraw(new BList()),
					mpLayoutMatrixItems(new BList()),
					bottom(0),
					right(0),
					rows(ui32paramRows), 
					columns(ui32paramColumns), 
					flags(ui32paramFlags)
{
	wpparamWindowGuts->AddToLayoutMatrixList(this);
}//end


//dtor
LayoutMatrix	::	~LayoutMatrix() 
{
	delete mpChildrenToAdd;
	delete mpItemsToDraw;
	LayoutMatrixItem * lmi = (LayoutMatrixItem *)mpLayoutMatrixItems->LastItem();
	while (lmi)
	{
		mpLayoutMatrixItems->RemoveItem((void *)lmi);
		delete lmi;
		lmi = (LayoutMatrixItem *)mpLayoutMatrixItems->LastItem();
	}
}//end


//calculate the view positions of all the MatrixLayoutItems
//on the items list with offsets based upon matrixLeft
//and matrixTop
void 
LayoutMatrix	::	Calc(	const float fparamMatrixLeft,  
							const float fparamMatrixTop,
							sem_id paramSemID) 
{
	int32 numItems = itemsList->CountItems();
	if (!numItems) return;
	if (acquire_sem(paramSemID) != B_NO_ERROR)
	{
		warning(myPrefs->FailAqSem);
		return;
	}
	bool hasPopUpMenu = false;
	TextItem *	scratchTextItem;
	BView view(BRect(0, 0, 32, 32), "NoShowView", B_FOLLOW_NONE, 0);
	//need to attach these items to a BView before they
	//can be Resize()ed and MoveTo()ed
	for (	int i = 0;
			i < numItems;
			i++)
	{
		((LayoutMatrixItem *)(itemsList->ItemAt(i)))->Calc();
	}
	float widest = 0;
	float tallest = 0;
	uint32 index = 0;
	for (	int i = 0;
			i < numItems;
			i++)
	{
		LayoutMatrixItem * lmi = (LayoutMatrixItem *)itemsList->ItemAt(index++);
		if (lmi->widthPref > widest) 
		{
			widest = lmi->widthPref;
		}
		if (lmi->heightPref > tallest) 
		{
			tallest = lmi->heightPref;
		}
	}
	if (flags & SAMESIZE) 
	{//SAMESIZE makes all items the same size as the largest
		index = 0;
		//Resize all items to match largest:
		for (	uint32 i = 0;
				i < rows;
				i++) 
		{
			for (	uint32 j = 0;
					j < columns;
					j++) 
			{
				LayoutMatrixItem * lmi = (LayoutMatrixItem *)itemsList->ItemAt(index++);
				switch (lmi->kind)
				{
					case KIND_MYSPACER:
					{
						MySpacer * scratchMySpacer = (MySpacer *)lmi->item;
						if (scratchMySpacer->bSAMEFromWidest)
						{
							scratchMySpacer->ResizeTo(widest, tallest);
						}
					break;
					}
					case KIND_MYBUTTON:
					{
						BButton * scratchMyButton = (BButton *)lmi->item;
						view.AddChild(scratchMyButton);
						scratchMyButton->ResizeTo(widest, tallest);
						view.RemoveChild(scratchMyButton);
					break;
					}
					case KIND_STRINGDRAWER:
					{
						BStringView * scratchMyStringView = (BStringView *)lmi->item;
						view.AddChild(scratchMyStringView);
						scratchMyStringView->ResizeTo(widest, tallest);
							view.RemoveChild(scratchMyStringView);
					break;
					}
					case KIND_MYCHECKBOX:
					{
						BCheckBox * scratchMyCheckBox = (BCheckBox *)lmi->item;
						view.AddChild(scratchMyCheckBox);
						scratchMyCheckBox->ResizeTo(widest, tallest);
						view.RemoveChild(scratchMyCheckBox);
					break;
					}
					case KIND_MYPICTUREBUTTON:
					{
						BPictureButton * scratchMyPictureButton = (BPictureButton *)lmi->item;
						view.AddChild(scratchMyPictureButton);
						scratchMyPictureButton->ResizeTo(widest, tallest);
						view.RemoveChild(scratchMyPictureButton);
					break;
					}
					case KIND_MYCOLORCONTROL:
					{
						BColorControl * scratchMyColorControl = (BColorControl *)lmi->item;
						view.AddChild(scratchMyColorControl);
						scratchMyColorControl->ResizeTo(widest, tallest);
						view.RemoveChild(scratchMyColorControl);
					break;
					}
					case KIND_MYSTATUSBAR:
					{
						BStatusBar * scratchMyStatusBar = (BStatusBar *)lmi->item;
						view.AddChild(scratchMyStatusBar);
						scratchMyStatusBar->ResizeTo(widest, tallest);
						view.RemoveChild(scratchMyStatusBar);
					break;
					}
					case KIND_UINT32GADG:
					{
						UInt32Gadget * scratchUInt32Gadget = (UInt32Gadget *)lmi->item;
						view.AddChild(scratchUInt32Gadget);
						scratchUInt32Gadget->ResizeTo(widest, tallest);
						view.RemoveChild(scratchUInt32Gadget);
					break;
					}
					case KIND_FLOATGADG:
					{
						FloatGadget * scratchFloatGadget = (FloatGadget *)lmi->item;
						view.AddChild(scratchFloatGadget);
						scratchFloatGadget->ResizeTo(widest, tallest);
						view.RemoveChild(scratchFloatGadget);
					break;
					}
					case KIND_STRINGGADG:
					{
						StringGadget * scratchStringGadget = (StringGadget *)lmi->item;
						view.AddChild(scratchStringGadget);
						scratchStringGadget->ResizeTo(widest, tallest);
						view.RemoveChild(scratchStringGadget);
					break;
					}
//					case KIND_TEXT: //nothing needed from this
//					case KIND_COLORWELLGADG:
				}
			}
		}
	}
	index = 0;
	//move every item based upon size and padding:
	const float hpad = 2;//horizontal spacing between items
	const float vpad = 2;//vertical spacing between items
	float localLeft;
	float localTop = vpad + fparamMatrixTop;
	float excessRight = 0, excessRightHold;
	float excessBottom = 0, excessBottomHold;
	for (	uint32 i = 0;
			i < rows;
			i++) 
	{
		localLeft = fparamMatrixLeft + hpad;
		float columnRight = 0;
		for (	uint32 j = 0;
				j < columns;
				j++) 
		{
			LayoutMatrixItem * lmi = (LayoutMatrixItem *)itemsList->ItemAt(index++);
			//debug below we need to consider those items not resized under SAME
			switch (lmi->kind) 
			{
				case KIND_MYPOPUPMENU:
				{
					hasPopUpMenu = true;
					scratchTextItem = ((MyPopUpMenu *)lmi->item)->GetTextItem();
					scratchTextItem->left = localLeft;
					MyPopUpMenu * scratchPopUpMenu = (MyPopUpMenu *)lmi->item;
					excessRightHold = lmi->widthPref + scratchPopUpMenu->fmLabelWidth;
					scratchPopUpMenu->SetLeft(scratchTextItem->left);
					scratchTextItem->top = localTop + lmi->heightPref;
					scratchPopUpMenu->SetTop(scratchTextItem->top - (lmi->heightPref / 2));
					if (scratchPopUpMenu->fmHeight > scratchPopUpMenu->textHeight)
					{
						excessBottomHold = scratchPopUpMenu->fmHeight;
					}
					else
					{
						excessBottomHold = scratchPopUpMenu->textHeight;
					}
				break;
				}
				case KIND_MYTEXTVIEW:
				{
					BTextView * scratchTextView = (BTextView *)lmi->item;
					scratchTextView->MoveTo(localLeft, localTop);
					excessRightHold = ((MyTextView *)scratchTextView)->fmWidth;
					excessBottomHold = ((MyTextView *)scratchTextView)->fmHeight;
				break;
				}
				case KIND_MYLISTVIEW:
				{
					BListView * scratchListView = (BListView *)lmi->item;
					scratchListView->MoveTo(localLeft, localTop);
					float fmWidth;
					float fmHeight;
					((BListView *)(lmi->item))->GetPreferredSize(&fmWidth, &fmHeight);
					excessRightHold = fmWidth;
					excessBottomHold = fmHeight;
				break;
				}
				case KIND_MYBUTTON:
				{
					BButton * scratchMyButton = (BButton *)lmi->item;
					view.AddChild(scratchMyButton);
					scratchMyButton->MoveTo(localLeft, localTop);
					excessRightHold = scratchMyButton->Bounds().Width();
					excessBottomHold = scratchMyButton->Bounds().Height();
					view.RemoveChild(scratchMyButton);
				break;
				}
				case KIND_MYSPACER:
				{
					MySpacer * scratchMySpacer = (MySpacer *)lmi->item;
					if (	(flags & SAMESIZE) 
							&& 
							!scratchMySpacer->bSAMEFromWidest)
					{
						excessRightHold = widest;
						excessBottomHold = tallest;
					}
					else
					{
						excessRightHold = scratchMySpacer->fPreferredWidth;
						excessBottomHold = scratchMySpacer->fPreferredHeight;
					}
				break;
				}
				case KIND_MYRADIOVIEW:
				{
					MyRadioView * scratchRadioView = (MyRadioView *)lmi->item;
					view.AddChild(scratchRadioView);
					scratchRadioView->MoveTo(localLeft, localTop);
					excessRightHold = scratchRadioView->Bounds().Width();
					excessBottomHold = scratchRadioView->Bounds().Height();
					view.RemoveChild(scratchRadioView);
				break;
				}
				case KIND_STRINGDRAWER:
				{
					BStringView * scratchMyStringView = (BStringView *)lmi->item;
					view.AddChild(scratchMyStringView);
					TextItem * scratchTextItem = ((MyStringDrawer *)lmi->item)->GetTextItem();
					scratchTextItem->left = localLeft;
					scratchTextItem->top = localTop + lmi->heightPref - ((MyStringDrawer *)lmi->item)->descender - vpad;
					scratchMyStringView->MoveTo(localLeft, localTop);
					excessRightHold = scratchMyStringView->Bounds().Width();
					lmi->widthPref = excessRightHold;
					excessBottomHold = scratchMyStringView->Bounds().Height();
					lmi->heightPref = excessBottomHold;
					view.RemoveChild(scratchMyStringView);
				break;
				}
				case KIND_MYCHECKBOX:
				{
					BCheckBox * scratchMyCheckBox = (BCheckBox *)lmi->item;
					view.AddChild(scratchMyCheckBox);
					scratchMyCheckBox->MoveTo(localLeft, localTop);
					excessRightHold = scratchMyCheckBox->Bounds().Width();
					excessBottomHold = scratchMyCheckBox->Bounds().Height();
					view.RemoveChild(scratchMyCheckBox);
					if (lmi->last)
					{//there must be a math/logic error somewhere which requires this extra spacing
						excessBottomHold += (2 * MATRIXVERTICALOFFSETGUTS);
					}
				break;
				}
				case KIND_MYPICTUREBUTTON:
				{
					BPictureButton * scratchMyPictureButton = (BPictureButton *)lmi->item;
					view.AddChild(scratchMyPictureButton);
					scratchMyPictureButton->MoveTo(localLeft, localTop);
					excessRightHold = scratchMyPictureButton->Bounds().Width();
					excessBottomHold = scratchMyPictureButton->Bounds().Height();
					view.RemoveChild(scratchMyPictureButton);
				break;
				}
				case KIND_MYCOLORCONTROL:
				{
					BColorControl * scratchMyColorControl = (BColorControl *)lmi->item;
					view.AddChild(scratchMyColorControl);
					scratchMyColorControl->MoveTo(localLeft, localTop);
					excessRightHold = scratchMyColorControl->Bounds().Width();
					excessBottomHold = scratchMyColorControl->Bounds().Height();
					if (lmi->last)
					{//there must be a math/logic error somewhere which requires this extra spacing
						excessBottomHold += MATRIXVERTICALOFFSETGUTS;
					}
					view.RemoveChild(scratchMyColorControl);
				break;
				}
				case KIND_MYSTATUSBAR:
				{
					BStatusBar * scratchMyStatusBar = (BStatusBar *)lmi->item;
					view.AddChild(scratchMyStatusBar);
					scratchMyStatusBar->MoveTo(localLeft, localTop);
					excessRightHold = scratchMyStatusBar->Bounds().Width();
					excessBottomHold = scratchMyStatusBar->Bounds().Height();
					view.RemoveChild(scratchMyStatusBar);
				break;
				}
				case KIND_UINT32GADG:
				{
					UInt32Gadget * scratchUInt32Gadget = (UInt32Gadget *)lmi->item;
					view.AddChild(scratchUInt32Gadget);
					scratchUInt32Gadget->MoveTo(localLeft, localTop);
					excessRightHold = scratchUInt32Gadget->Bounds().Width();
					excessBottomHold = scratchUInt32Gadget->Bounds().Height();
					view.RemoveChild(scratchUInt32Gadget);
				break;
				}
				case KIND_FLOATGADG:
				{
					FloatGadget * scratchFloatGadget = (FloatGadget *)lmi->item;
					view.AddChild(scratchFloatGadget);
					scratchFloatGadget->MoveTo(localLeft, localTop);
					excessRightHold = scratchFloatGadget->Bounds().Width();
					excessBottomHold = scratchFloatGadget->Bounds().Height();
					view.RemoveChild(scratchFloatGadget);
				break;
				}
				case KIND_STRINGGADG:
				{
					StringGadget * scratchStringGadget = (StringGadget *)lmi->item;
					view.AddChild(scratchStringGadget);
					scratchStringGadget->MoveTo(localLeft, localTop);
					excessRightHold = scratchStringGadget->Bounds().Width();
					excessBottomHold = scratchStringGadget->Bounds().Height();
					view.RemoveChild(scratchStringGadget);
				break;
				}
				case KIND_TEXT:
					scratchTextItem = (TextItem *)lmi->item;
					scratchTextItem->left = localLeft;
					scratchTextItem->top = localTop + lmi->heightPref;
					excessRightHold = lmi->widthPref;
					excessBottomHold = lmi->heightPref;
				break;
				case KIND_COLORWELLGADG:
					scratchTextItem = ((ColorWell *)lmi->item)->GetTextItem();
					scratchTextItem->left = localLeft;
					((ColorWell *)lmi->item)->SetLeft(((ColorWell *)lmi->item)->GetLeft() + localLeft);
					excessRightHold = lmi->widthPref;
					scratchTextItem->top = localTop + lmi->heightPref;
					((ColorWell *)lmi->item)->SetTop(((ColorWell *)(lmi->item))->descender + (scratchTextItem->top - ((((ColorWell *)lmi->item)->GetTop()) / 2)) - (lmi->heightPref / 2));
					excessBottomHold = lmi->heightPref + ((ColorWell *)(lmi->item))->descender;
				break;
			}
			excessRightHold += hpad;
			if (flags & SAMESIZE)
			{
				if (excessRightHold > excessRight)
				{
					excessRight = excessRightHold;
				}
			}
			else
			{
				excessRight = excessRightHold;
			}
			localLeft += excessRight;
			if (columns - 1) 
			{
				if (j != (columns - 1)) 
				{
					if (localLeft > columnRight) 
					{
						columnRight = localLeft;
					}
				}
				else 
				{
					columnRight = localLeft;
				}
			}
			else 
			{
				if (localLeft > columnRight) 
				{
					columnRight = localLeft;
				}
			}
			//right is stored so that another MatrixLayout
			//can know where a previous one ended up
		}
		if (columnRight > right)
		{
			right = columnRight;
		}
		excessBottomHold += vpad;
		if (flags & SAMESIZE)
		{
			if (excessBottomHold > excessBottom)
			{
				excessBottom = excessBottomHold;
			}
		}
		else
		{
			excessBottom = excessBottomHold;
		}
		localTop += excessBottom;
		if (rows - 1) 
		{
			if (i != (rows - 1)) 
			{
				if (localTop > bottom) 
				{
					bottom = localTop;
				}
			}
			else 
			{
				bottom = localTop;
			}
		}
		else 
		{
			if (localTop > bottom) 
			{
				bottom = localTop;
			}
		}
		//bottom is stored so that another MatrixLayout
		//can know where a previous one ended up
	}
	LayoutMatrixItem * lastLMI = (LayoutMatrixItem *)itemsList->LastItem();
	if (lastLMI->kind == KIND_MYPOPUPMENU)
	{
		MyPopUpMenu * scratchPopUpMenu = (MyPopUpMenu *)lastLMI->item;
		if (scratchPopUpMenu->fmHeight > scratchPopUpMenu->textHeight)
		{
			bottom += ((scratchPopUpMenu->fmHeight - scratchPopUpMenu->textHeight) / 2);
		}
		else
		{
			bottom += ((scratchPopUpMenu->textHeight - scratchPopUpMenu->fmHeight) / 2);
		}
	}
	if (hasPopUpMenu)
	{
		right += 30;
	}
	release_sem(paramSemID);
}//end


void
LayoutMatrix	::	AddToChildren(	void * item) 
{
	mpChildrenToAdd->AddItem(item);
}//end


void
LayoutMatrix	::	AddToDraw(	void * item) 
{
	mpItemsToDraw->AddItem(item);
}//end
