//myTextView.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "Preferences.h"
#include "myroColour.h"
#include "myTextView.h"
#include "myPreferences.h"
#include "layoutMatrix.h"
#include "warning.h"



MyTextView	::	~MyTextView() 
{
	//left blank
};//end


//ctor
MyTextView	::	MyTextView(	const char * paramName, 
							const char * paramText,
							float fparamMaxWidth,
							float fparamMaxHeight,
							LayoutMatrix * lpparamLayoutMatrix) 
				: 
					BTextView(	BRect(0,0,fparamMaxWidth,fparamMaxHeight), 
								paramName, 
								BRect(1,1,fparamMaxWidth + 1,fparamMaxWidth + 1), 
								B_FOLLOW_NONE, 
								B_WILL_DRAW),
					fmWidth(	fparamMaxWidth),
					fmHeight(	fparamMaxHeight)
{
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_MYTEXTVIEW);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
	lpparamLayoutMatrix->AddToChildren((void *)this);
	SetText(paramText);
	MakeResizable(false);
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyTextViewHighColor(&tempRgbColor);
	SetFontAndColor(myPrefs->GetPreferredFont(), B_FONT_ALL, &tempRgbColor);
}//end


void 
MyTextView	::	AttachedToWindow() 
{
	BTextView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyTextViewViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	myPrefs->GetPreferredMyTextViewHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyTextViewLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
}//end


void
MyTextView	::	MyGetPreferredSize(	float * fpparamWidth,
									float * fpparamHeight)
{
	*fpparamHeight = fmHeight;
	*fpparamWidth = fmWidth;
}//end