//******************************************************************************
//
//	File:		tsb.cpp
//
//	Copyright 1993-95, Be Incorporated
// Lots deleted and modified for completely different ends by
// Jesper Juul (jj@pobox.com).
//******************************************************************************


#include <Debug.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#ifndef _INTERFACE_DEFS_H
#include <InterfaceDefs.h>
#endif
#include <OS.h>
#include <Screen.h>
#include <KernelKit.h>

#include "tsb.h"
#include "lyp10.h"


/*------------------------------------------------------------*/


#define maxthreads 64

int size_x=384;
int size_y=384;


TShowBit	*tsbb;
long countdown;
sem_id cdsem;

class JFRACTAL * jfracg[maxthreads];
int jfracdone[maxthreads];
int cpucount;
thread_id threads[maxthreads];

uchar * palette2;


/*------------------------------------------------------------*/
long	niter = 256; 
/*------------------------------------------------------------*/

uchar	palette[256];

/*------------------------------------------------------------*/



/*------------------------------------------------------------*/




void	TShowBit::MouseDown(BPoint where)
{
	if (!this->Window()->IsFront()) {
		this->Window()->Activate(TRUE);
		this->Window()->UpdateIfNeeded();
	}

	if (busy)
		return;

	if ((modifiers() & B_SHIFT_KEY) == 0) {
		change_selection(where.x, where.y);
		if ((selection.bottom - selection.top) < 4)
			return;
	jfrac->zoom_setstart(selection.left+5,selection.top);
	jfrac->zoom_setend(selection.right+5,selection.bottom);
	 MovePenTo(50,50);

	 char s[367];
	 sprintf(s,"%d,%d - %d,%d\n",selection.left,selection.top,selection.right,selection.bottom);
	 DrawString(s);

	/*
	jfrac->zoom_setstart(0,0);
	jfrac->zoom_setend(jfrac->width/2,jfrac->height/2);
*/
	redraw_fractal();
	}
	else
	{
	 jfrac->zoom_out(where.x,where.y,2.0);
	 redraw_fractal();
	}
}

void TShowBit::FrameResized(float w,float h)
{
size_x=(int)w;
size_y=(int)h;
restart();
}

/*------------------------------------------------------------*/

void	TShowBit::redraw_fractal()
{
stop();

	selection.Set(-1000, -1000, -1000, -1000);
 
 	fractal();

}

/*------------------------------------------------------------*/

void	TShowBit::set_iter(long it)
{
	if (it != iter) {
	stop();
	
		iter = it;
		niter = it;
		selection.Set(-1000, -1000, -1000, -1000);
		jfrac->iterations=niter;
		fractal();
	}
}

void	TShowBit::setsize(int w,int h)
{
stop();
jfrac->width=w;
jfrac->height=h;
restart();
}

/*------------------------------------------------------------*/

void	TShowBit::set_palette(long code)
{
	rgb_color	c;
	long		i;
	
	BScreen screen( Window() );

stop();

	if (code == 0) {
		for (i = 0; i < 256; i++)
		{
			c.red = i ;
			c.green = i;
			c.blue = i;
			palette[255-i] = screen.IndexForColor(c);
		}
	}
	if (code == 1) {
		for (i = 0; i < 256; i++) {
			c.red = i ;
			c.green = i;
			c.blue = i;
			palette[i] = screen.IndexForColor(c);
		}
	}

	if (code == 2) {
		for (i = 0; i < 256; i++) {
		 if (i<128)
		  {
		   if (i<64)
		    c.red=i*4;
		   else
		    c.red=255-(i-64)*4;
		  }
		 else
		 {
			c.red = 0 ;
		 }

		 if (i>=128)
		  {
		   if (i<196)
		    c.green=(i&127)*4;
		   else
		    c.green=255-(i-196)*4;
		  }
		 else
		 {
			c.green = 0 ;
		 }
			c.blue = 0;
			palette[i] = screen.IndexForColor(c);
		}
	}

	if (code == 3) {
		for (i = 0; i < 256; i++) {
			c.red = 0;
			c.green = 0;
			c.blue = i;
			palette[255-i] = screen.IndexForColor(c);
		}
	}
	fractal();
}

/*------------------------------------------------------------*/

TShowBit::TShowBit(BRect r, long flags) :
	BView(r, "", flags, B_WILL_DRAW | B_PULSE_NEEDED|B_FRAME_EVENTS)
{
	BRect	bitmap_r;
	long	ref;
	long	i;
	char	*bits;

cdsem=create_sem(1,"lyap");
	
 for (i=0;i<maxthreads;i++)
 {
  jfracdone[i]=-1;
  threads[i]=-1;
 }
	
	system_info sysinfo;
	get_system_info(&sysinfo);
	cpucount = sysinfo.cpu_count;
	
	if (cpucount>maxthreads) cpucount=maxthreads;
	
jfrac=new JFRACTAL();
jfrac->type=ft_lyapunov;

palette2=palette;

jfracg[0]=jfrac;

for (i=1;i<cpucount;i++) jfracg[i]=new JFRACTAL();

 

	busy = FALSE;
	exit_now = FALSE;
	tsbb = this;
	bitmap_r.Set(0, 0, size_x - 1, size_y - 1);
	selection.Set(-1000, -1000, -1000, -1000);
	iter = 256;

	the_bitmap = new BBitmap(bitmap_r, B_COLOR_8_BIT);
	bits = (char *)the_bitmap->Bits();
	memset(bits, 0x00, size_x*the_bitmap->BytesPerRow());
	set_palette(0);
	
	docontrol();
	
}


void TShowBit::docontrol()
{

scroll_max=200;

bw=new BWindow(BRect(500,100,700,270),"Lyap controls",B_TITLED_WINDOW,B_NOT_CLOSABLE,B_CURRENT_WORKSPACE);

bmsb=new BScrollBar(BRect(10,50,190,50+B_H_SCROLL_BAR_HEIGHT),"scroll21",NIL,0,scroll_max,B_HORIZONTAL);
bw->AddChild(bmsb);
bw->AddChild(new BStringView(BRect(10,40,190,50),"hmm","Morph",B_FOLLOW_LEFT,B_WILL_DRAW));

bfsb=new BScrollBar(BRect(10,80,190,80+B_H_SCROLL_BAR_HEIGHT),"scroll22",NIL,0,scroll_max,B_HORIZONTAL);
bw->AddChild(bfsb);
bw->AddChild(new BStringView(BRect(10,70,190,80),"hmm","First X",B_FOLLOW_LEFT,B_WILL_DRAW));

bcsb=new BScrollBar(BRect(10,110,190,110+B_H_SCROLL_BAR_HEIGHT),"scroll23",NIL,0,scroll_max,B_HORIZONTAL);
bw->AddChild(bcsb);
bw->AddChild(new BStringView(BRect(10,100,190,110),"hmm","Contrast",B_FOLLOW_LEFT,B_WILL_DRAW));

bvs=new BStringView(BRect(50,10,150,40),"hmm","",B_FOLLOW_LEFT,B_WILL_DRAW);
bw->AddChild(bvs);

bcb=new BCheckBox(BRect(10,140,190,150),"arne","Buffered update",0,B_FOLLOW_LEFT,B_WILL_DRAW);
bcb->SetValue(B_CONTROL_OFF);
bw->AddChild(bcb);

setcontrols();
bw->Show();

}

void TShowBit::setcontrols()
{

bmsb->SetProportion(0.1);
bmsb->SetValue(scroll_max/2);

bfsb->SetProportion(0.1);
bfsb->SetValue(scroll_max/2);

bcsb->SetProportion(0.1);
bcsb->SetValue(scroll_max/2);
}

/*------------------------------------------------------------*/

TShowBit::~TShowBit()
{
int i;

stop();

  for (i=0;i<cpucount;i++) delete(jfracg[i]);
	delete	the_bitmap;
	
	delete_sem(cdsem);
	
}

/*------------------------------------------------------------*/

void TShowBit::Draw(BRect update_rect)
{
	DrawBitmap(the_bitmap, BPoint(0, 0));
}

void TShowBit::stop()
{
int i;
int cd=100;
int res;

if (busy)
{

  for (i=0;i<cpucount;i++) jfracg[i]->exit=exit_quit;
  
  do
  {
  res=FALSE;
  for (i=0;i<cpucount;i++)
   {
    if (jfracdone[i]>=0) res=true;
   }
   if (res) snooze(10000);
  }
  while((!res)&&(--cd>0));
  }
  killthreads();  
  busy=FALSE;
}

void TShowBit::killthreads()
{
int i;
for (i=0;i<cpucount;i++)
 {
  if (threads[i]>0) kill_thread(threads[i]);
  threads[i]=-1;
 }
}

long	__lcalcall(void *arg)
{
int num=*(int *)arg;

	jfracg[num]->lyap(palette2,cpucount,num);

   *(int *)arg=-1;
   acquire_sem(cdsem);
   if (--countdown<=0)
    {
     //tsbb->drawit();
     //tsbb->shouldweredraw();
    }
   release_sem(cdsem);   
	return B_NO_ERROR;
}

void TShowBit::restart()
{
int i;

stop();

	busy = TRUE;
	jfrac->setsize((char *)the_bitmap->Bits(),size_x,size_y,the_bitmap->BytesPerRow());

	BScreen screen( Window() );
	uchar * u=(uchar *)the_bitmap->Bits();
	rgb_color	c;
	
	c.red = 255;
	c.green = 255;
	c.blue = 255;
	uchar p=screen.IndexForColor(c);

for (i=0;i<size_y;i++)
 {
  *u=p;
  u+=the_bitmap->BytesPerRow();
 }

countdown=cpucount;
     
for (i=0;i<cpucount;i++)
 {
  jfracdone[i]=i;
  *jfracg[i]=*jfrac;
  threads[i]=spawn_thread(__lcalcall, "lcalc1", B_LOW_PRIORITY, &jfracdone[i]);
	resume_thread(threads[i]);
  }
}

/*------------------------------------------------------------*/



/*------------------------------------------------------------*/

void	TShowBit::fractal()
{
int i;

if (busy) return;

switch(jfrac->type)
{
case ft_lyapunov:

restart();

/*
jfrac->lyap(palette,1,0);
		
	//busy = FALSE;
	t1_done = 1;
	t2_done = 1;
	*/
break;

case ft_mandelbrot:
break;
}
}

/*
long TShowBit::calcall_entry(void *arg)
{
TShowBit * obj=(TShowBit *) arg;
return obj->calcall(&jfracdone[i]);
}

long TShowBit::calcall(void *arg)
{
int num=*(int *)arg;

	jfracg[num]->lyap(palette2,cpucount,num);

   *(int *)arg=-1;
   
	return B_NO_ERROR;
}
*/


/*------------------------------------------------------------*/

void TShowBit::drawit()
{
 Draw(BRect(0,0,0,0));
	 char s[367];
	 sprintf(s,"%d,%d - %d,%d\n",selection.left,selection.top,selection.right,selection.bottom);
	 DrawString(s);

}

void	TShowBit::Pulse()
{
int i;
bool res=true;
//	PRINT(("pulsing (%d)\n", busy));
	if (busy) {
	if (bcb->Value()!=B_CONTROL_ON) drawit();
		switch(jfrac->type)
		 {
		  case ft_lyapunov:
		  for (i=0;i<cpucount;i++) 
		   {
		   if (jfracdone[i]>=0) res=false;
		   }
		   if (res)
		   {
			busy = FALSE;
			exit_now = FALSE;
			drawit();
			}
			
		  break;
		  
		  case ft_mandelbrot:

		break;
		}
	}


shouldweredraw();
}

void TShowBit::shouldweredraw()
{
 
bool again=false;

if ((!busy)||(bcb->Value()!=B_CONTROL_ON))
{
if ((bmsb->Value()!=lastmscrollpos))	 
	 {
	  jfrac->morph_min=(double)bmsb->Value()/(double)(scroll_max/2);
	  lastmscrollpos=(long)bmsb->Value();
	  again=true;
	 }

if ((bfsb->Value()!=lastfscrollpos))	 
	 {
	  jfrac->firstx_min=(double)bfsb->Value()/(double)(scroll_max);
	  lastfscrollpos=(long)bfsb->Value();
	  again=true;
	 }

if ((bcsb->Value()!=lastcscrollpos))	 
	 {
	  jfrac->contrast=128*pow(((double)bcsb->Value()/(double)(scroll_max/2)),4);
	  lastcscrollpos=(long)bcsb->Value();
	  again=true;
	 }
}

if (again) restart();
}

/*------------------------------------------------------------*/

long	TShowBit::limit_v(long v)
{
	if (v > (size_y - 1))
			v = (size_y - 1);

	if (v < 0)
			v = 0;
	return(v);
}

/*------------------------------------------------------------*/

long	TShowBit::limit_h(long v)
{
	if (v > (size_x - 1))
			v = size_x - 1;

	if (v < 0)
			v = 0;
	return(v);
}

/*------------------------------------------------------------*/

BRect	TShowBit::sort_rect(BRect *aRect)
{
	BRect	tmp_rect;
	long	tmp;

	tmp_rect = *aRect;
	if (tmp_rect.bottom < tmp_rect.top) {
		tmp = (long)tmp_rect.top;
		tmp_rect.top = tmp_rect.bottom;
		tmp_rect.bottom = tmp;
	}

	if (tmp_rect.left > tmp_rect.right) {
		tmp = (long)tmp_rect.right;
		tmp_rect.right = tmp_rect.left;
		tmp_rect.left = tmp;
	}

	tmp_rect.top = limit_v(tmp_rect.top);
	tmp_rect.left = limit_h(tmp_rect.left);
	tmp_rect.bottom = limit_v(tmp_rect.bottom);
	tmp_rect.right = limit_h(tmp_rect.right);

	return(tmp_rect);
}

/*------------------------------------------------------------*/

void	TShowBit::clip(long *h, long *v)
{
	if (*h > (size_x - 1))
			*h = (size_x - 1);
	if (*h < 0)
			*h = 0;
	if (*v > (size_y - 1))
			*v = size_y - 1;
	if (*v < 0)
			*v = 0;
}

/*------------------------------------------------------------*/

char	TShowBit::has_selection()
{
	if (((selection.bottom - selection.top) + (selection.right - selection.left)) < 5) 
		return 0;
	else
		return 1;
}

/*------------------------------------------------------------*/

void	TShowBit::change_selection(long h, long v)
{
	ulong	buttons;
	long	h0;
	long	v0;
	BRect	new_select;
	BRect	old_select;
	BRect	tmp_rect;
	long	max;
	long	width, height;
	
	clip(&h, &v);
	new_select.top = v;
	new_select.left = h;
	old_select = selection;

	SetDrawingMode(B_OP_INVERT);

	do {
		BPoint where;
		GetMouse(&where, &buttons);
		h0 = (long)where.x;
		v0 = (long)where.y;
		width = h0 - h;
		height = v0 - v;
		max= ((v0>v) ^ (height < width)) ? height : width;

		h0 = h+max; v0 = v+max;

		clip(&h0, &v0);
		new_select.right = h0;
		new_select.bottom = v0;

		if ((old_select.top != new_select.top) || 
		    (old_select.bottom != new_select.bottom) ||
		    (old_select.right != new_select.right) ||
		    (old_select.left != new_select.left)) {
		
			tmp_rect = sort_rect(&new_select);
			StrokeRect(tmp_rect);

			tmp_rect = sort_rect(&old_select);
			StrokeRect(tmp_rect);

			old_select = new_select;
			Flush();
		}

		snooze(20000);
	} while(buttons);

	selection = sort_rect(&new_select);
	if (!has_selection()) {
		StrokeRect(selection);
		selection.Set(-1000, -1000, -1000, -1000);
	} 
	SetDrawingMode(B_OP_COPY);
}
