#include <StorageKit.h>

#define	FMODE B_WRITE_ONLY|B_CREATE_FILE|B_ERASE_FILE

#define MSG_MIME_TYPE "application/x-Be.vnd-message"

status_t
SaveMessage (
	BMessage *msg,
	BDirectory *dir,
	const char *filename
)
{
	status_t st = B_OK;

	ssize_t size;
	BNodeInfo noddy;
	BFile newfile;

// create new file
	if ( (st = newfile.SetTo (dir, filename, FMODE)) != B_NO_ERROR)
		;

// init Node Info
	else if ( (st = noddy.SetTo (&newfile)) != B_NO_ERROR)
		;

// set MIME type
	else if ( (st = noddy.SetType(MSG_MIME_TYPE)) != B_NO_ERROR)
		;

// Flatten the message
	else if ( (st = msg->Flatten(&newfile, &size)) != B_NO_ERROR)
		;

	return st;
}

/*
// extract directory
	entry_ref ref;
	msg->FindRef("directory", &ref);
	BDirectory dir;
	dir.SetTo(&ref);
*/
