#ifndef PULSEVIEW_H
#define PULSEVIEW_H

enum {
	PROGRESS_WIDTH	= 142,
	PROGRESS_HEIGHT	= 16
};

#pragma export on

class TPulseView : public BView {
	public:
		TPulseView (BMessage *archive)
			: BView(archive)
		{
			do_init();
		}
		TPulseView (BRect r)
			: BView(r, "PulseView", B_FOLLOW_NONE, B_WILL_DRAW)
		{
			do_init();
		}
		~TPulseView()
		{
			kill_thread (computeThread);
			delete [] prevTicks;
			delete [] currentPositions;
		}
		void do_init ();
		static int32 ComputeCPUTime(void * data);
		virtual status_t Archive(BMessage *data, bool deep) const; 
		static TPulseView *Instantiate(BMessage *data);
		virtual	void Draw (BRect /*updateRect*/);
		
	private:
		double *prevTicks;
		int *currentPositions;
		int numCPUs;
		thread_id computeThread;
};

#pragma export off

#endif // PULSEVIEW_H
