#include "Nino.h"

Nino::Nino()
{
	bufferReady = create_sem(0, "buffer ready");
	bufferUsed = create_sem(0, "buffer used");
	
	adcStream = new BADCStream();
	dacStream = new BDACStream();
	
	adcSubscriber = new BSubscriber("Nino ADC reader");
	dacSubscriber = new BSubscriber("Nino DAC writer");
	
	adcSubscriber->Subscribe(adcStream);
	dacSubscriber->Subscribe(dacStream);
	
	adcSubscriber->EnterStream(	NULL, false,
								this, adc_reader,
								NULL, true);
	dacSubscriber->EnterStream(	NULL, false,
								this, dac_writer,
								NULL, true);
}

Nino::~Nino()
{
	dacSubscriber->ExitStream(true);
	delete_sem(bufferReady);
	delete_sem(bufferUsed);
	adcSubscriber->ExitStream(true);
	
	adcSubscriber->Unsubscribe();
	dacSubscriber->Unsubscribe();
	
	delete adcSubscriber;
	delete dacSubscriber;
	delete adcStream;
	delete dacStream;
}
	
	