// NINO
// Noise In - Noise Out

class Nino
{
public:
	Nino();
	~Nino();
	
	short		*adc_buffer;
	
	sem_id		bufferReady;
	sem_id		bufferUsed;
	
	BADCStream	*adcStream;
	BDACStream	*dacStream;
	
	BSubscriber	*adcSubscriber;
	BSubscriber	*dacSubscriber;
};

static bool
adc_reader(void *arg, char *buf, size_t count, void *header)
{
	Nino *myNino = (Nino*) arg;
	
	myNino->adc_buffer = (short*) buf;
	release_sem (myNino->bufferReady);
	acquire_sem (myNino->bufferUsed);
	return true;
}

static bool
dac_writer(void *arg, char *buf, size_t count, void *header)
{
	Nino *myNino = (Nino*) arg;
	short *dac_buffer = (short*) buf;
	acquire_sem (myNino->bufferReady);
	
//	for(int i = 0; i * sizeof(short) < count; i++)
//	{
//		int32 sample = (int32) dac_buffer[i] + myNino->adc_buffer[i];
//		sample += ;
//		if(sample >= 0x7fff) sample = 0x7fff;
//		if(sample <= -0x7fff) sample = -0x7fff;
//		dac_buffer[i] = (short) sample;
//	}
	int c = 0;
	for(int i = 0; i * sizeof(short) < count; i++)
	{
		int32 sample = (int32) /*dac_buffer[i] + */
			(myNino->adc_buffer[i++] / 5 +
			 myNino->adc_buffer[i++] / 5 +
			 myNino->adc_buffer[i++] / 5 +
			 myNino->adc_buffer[i++] / 5 +
			 myNino->adc_buffer[i] / 5);
			
		if(sample >= 0x7fff) sample = 0x7fff;
		if(sample <= -0x7fff) sample = -0x7fff;
		
		dac_buffer[c++] = (short) sample;
		dac_buffer[c++] = (short) sample;
		dac_buffer[c++] = (short) sample;
		dac_buffer[c++] = (short) sample;
	}
	
	release_sem(myNino->bufferUsed);
	return true;
}