/*-------------------------------------------------------------------------
!  Diese Datei sorgt dafür, daß der Level 1 des PLP (PSION Link Protokolls)
!  korrekt gelesen wird! 
!  Wird eine Bestätigung gelesen, wird diese Bestätigung an den
!  Write-Prozess weitergegeben (über den ControllPort)
!  
!  Außerdem wird analysiert, für welchen Port die Nachricht ist und
!  entsprechend an die Threads verteilt.
+-----------------------------------------------------------------------*/

#define SEARCHING	0
#define START_FOUND	1
#define END_FOUND	2
#define CRC_1		3
#define COMPLETE	4

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "messages.h"
#include "thread.h"
#include "ReadSerial.h"
#include "WriteSerial.h"
#include "PsiNCPWindow.h"
#include "PsionNCP.h"
#include "p_file.h"

#define MAXBLOCK 320	// Ein Block wird maximal 307 Bytes lang

port_id 		pid_o, pid_c;
NUCB			nucb[NC_MAX_USER];

// Die folgende Routine liest die Bytes direkt aus der geöffneten Schnittstelle
// Es wird in einen Buffer gelesen und dann byte für byte in einen anderen
// Buffer übertragen

int32 PsiRead(void *psiptr) {
	BSerialPort 	*psion = (BSerialPort *)psiptr;
	unsigned char	buffer[128], *q, *message=NULL, *msg_end=NULL;
	unsigned char	block[MAXBLOCK], *z;		
	bool 			esc;
	int				status;
	size_t			r, anz, len;
	unsigned short	crc_calc, crc_read=0;
	unsigned char	bef[10];
	NUCB			*n;
	
	pid_o = find_port("WritePsion");
	pid_c = find_port("WriteControl");
	if (pid_o < B_NO_ERROR || pid_c < B_NO_ERROR) exit_thread(pid_o);
	
	srandom(system_time());		// Zufallsgenerator neu starten!
	init_ncp();					// Alle Ports gefunden, also können wir loslegen!
	write_port(pid_o, PSION_MSG, "\x20", 1);	// Hello Meldung schicken

	z = block;
	esc = false;
	status = SEARCHING;			// Wir müssen erst den Anfang finden!
	
	while(true) {
		psion->WaitForInput();	// Lets wait until a Byte arrives!
		r = psion->Read(buffer, 128);
		if (r > 0 && r <= 128) {
//printf("PSION->PC: ");
//for (int i = 0; i < r; printf("%02x ", buffer[i++])) ;
//printf("\n");
//printf("PSION->PC: ");
//for (int i = 0; i < r; i++) printf("%c ", buffer[i] >= 32 && buffer[i] <= 127 ? buffer[i] : '.' ) ;
//printf("\n");
			q = buffer;
			anz = 0;
			while ((anz < r) && (z < &block[MAXBLOCK])) {
				if (status == END_FOUND) {		// ersten Teil der CRC-Summe lesen
					crc_read = (*q++ << 8);		// Das erste Byte einer ankommenden CRC ist das hochwertige!
					status++;					// Status um eins erhöhen!
					if (++anz >= r) break;		// Evtl. am Ende?
				}
				if (status == CRC_1) {			// zweiten Teil addieren
					crc_read |= *q++;			// Das zweite Byte der ankommenden CRC ist das niederwertige!

					len = z-block;				// Länge der empfangenen Nachricht berechnen
					crc_calc = Calccrc(0, block, len);	// CRC-Summe berechnen
					if (crc_calc == crc_read) {			// ist die CRC-Summe ok, dann dürfen wir weitermachen!

						switch (*block & 0xf0) {
							case 0x00: 									// Frame acknowledge erhalten
//								printf("Frame ACK erhalten für %d\n", *block);
								write_port(pid_c, PSION_ACK, block, 1);	// An den Sendethread weitergeben!
								break;
							case 0x10:										// Link disconnect bekommen. Gegner hat Übertagung beendet.
								printf("???: Link DISC erhalten\n");
								nucb[0].flags = NC_TERMINATING;				// Wir müssten so richtig alles aufräumen!
																			// An jeden eine Disconn. Msg schicken!
								break;
							case 0x20:										// Link request bekommen.
								printf("???: Link REQ erhalten\n");
								write_port(pid_o, PSION_MSG, "\x00", 1);	// Bestätigen und neue Verbindung aufbauen
								nucb[0].flags = NC_LINK_ACTIVE;				// Connected
								break;
							case 0x30:										// Daten sind angekommen
//printf("Daten erhalten Länge:%d\n", len);
								bef[0] = *block & 0x0f;
								write_port(pid_o, PSION_SACK, bef, 1); 		// Daten bestaetigen
								if (block[1] >= 1 && block[1] < NC_MAX_USER) {
									n = &nucb[block[1]];
									if ((n->flags & NC_LINK_ACTIVE) && (n->pid > B_NO_ERROR)) {
									
										if (block[3] > 1) {					// Eine Nachricht besteht aus mehr als 1 Block!
											if (n->flags & NC_READ_QUEUED) {	// Ist das eine Nachricht auf die wir bereits warten?
											} else {
												n->flags |= NC_READ_QUEUED;		// merken wir uns, daß da noch was kommt
												msg_end = message = (unsigned char *)malloc(block[3] * MAXBLOCK);
											}
											if (message != NULL) {
												memcpy(msg_end, &block[4], len-4);
												msg_end += (len-4);
											}
										} else {
											if (n->flags & NC_READ_QUEUED) {
												if (message != NULL) {
													memcpy(msg_end, &block[4], len-4);
													msg_end += (len-4);
												}
												write_port(n->pid, msg_end-message, message, msg_end-message);
												free(message);
												message = NULL;
												n->flags &= ~NC_READ_QUEUED;	// Flag wieder löschen!
											} else {
												write_port(n->pid, len-4, &block[4], len-4);	// Daten weitergeben aber ohne Sequenzid und ohne Kanalid
											}
										}
									} else printf("Port %d nicht geöffnet!\n", block[1]);
								} else if (block[1] == 0) {					// es ist eine NCP-Nachricht!
									NCP_Message(&block[2], len-2);
								}
								break;
						}
					} else printf("CRC falsch! Calc:%04x != read:%04x\n", crc_calc, crc_read);
					status = SEARCHING;			// Alles erledigt, daher setzen wir den Status wieder zurück
					z = block;					// Muß nicht sein, aber wir können den Block wieder vorne beginnen.
					if (++anz >= r) break;		// Evtl. am Ende?
				}
				
				if (esc) {
					esc = false;
					switch(*q++) {
						case 0x10:	*z++ = 0x10;
									break;
						case 0x02:	z = block;
									status = START_FOUND;
									break;
						case 0x03:	status = END_FOUND;
         							break;
         				default: 	status = SEARCHING;		// Alles zurücksetzen!
         							break;
					}
					if (++anz >= r) break;
				}

				if (status <= START_FOUND) {		// Nur wenn wir Daten lesen, müssen wir auf das ESC achten
					if (*q == 0x10) {
						q++;
						esc = true;
					} else {
						*z++ = *q++;
					}
					if (++anz >= r) break;
				}
			}
		}
	}
}

// Diese Funktion soll alle NCP-Nachrichten verarbeiten. 
// Dazu wird der komplett empfangene Buffer verarbeitet!

void NCP_Message(unsigned char *buffer, size_t laenge) {
	size_t			anz;
	unsigned char	*b, info_msg[8], remote_id, local_id, message;
	char			*c, addon_name[15];	// Add-ons vom Psion können maximal 8 Zeichen lang sein!
	NUCB			*n;
	time_t			secs;
	int 			i;
	
	printf(" NCP-Message: ");
	for (anz = 0; anz < laenge; printf("%02x ", buffer[anz++])) ;
	printf("\n");
	printf("       ASCII: ");
	for (anz = 0; anz < laenge; anz++) printf(" %c ", buffer[anz] > ' ' ? buffer[anz] : '.');
	printf("\n");

	b = buffer;							// 1.Byte = betroffener Kanal vom PSION!
	if (*b >= 0 && *b < NC_MAX_USER) {
		remote_id = *b;
		message = b[1];
		local_id = b[2];
//		printf("Message: %d\n", message);
		switch (message) {	  			// 2.Byte = Inter controler message
	        case NCON_MSG_CHANNEL_CLOSED:
	        case NCON_MSG_CHANNEL_DISCONNECT:
				if (local_id >= 0 && local_id < NC_MAX_USER) {
					n = &nucb[local_id];
		        	discon_channel ( n );
		        }
	            break;
	        case NCON_MSG_CONNECT_RESPONSE:
	        	printf("msg.connect.resp\n");
				if (local_id >= 0 && local_id < NC_MAX_USER) {
					n = &nucb[local_id];
	        		n->flags |= NC_LINK_ACTIVE;
	        		n->remote_id = remote_id;	// Die gegnerische ID eintragen!
					n->ch_crc = random() & ID_MASK;

					int32 msg_nr = PSION_START + n->ch_crc + (n->local_id << MOVE_CHAN);// Den Filedeskriptor für den Kanal berechnen
					write_port(n->pid, msg_nr, NULL, 0);								// und dem anfordernden Programm über den Port mitteilen!

   					BMessage *msg = new BMessage(MSG_NCP_CONN);			// Teilen wir der Oberfläche auch noch etwas mit. Dazu wird eine BMessage generiert
   					msg->AddString("Portname", n->name);				// In der der Portname enthalten ist
					msg->AddInt8("Portnummer", n->local_id);			// Und in der die Portnummer enthalten ist
   					myWindow->PostMessage(msg);							// Schicken wir die Message an das Fenster
			    }
	        	break;
			case NCON_MSG_CONNECT_TO_SERVER:
				*addon_name='\0';
				strncat(addon_name, (char *)&b[2], 14);			// Maximal 14 Zeichen kopieren!

				n = NULL;
				for (i = NC_MAX_USER-1; i >= 0; i--) {	// Wir fangen oben an, damit wir den ersten freien erhalten :-)
					if (nucb[i].flags & NC_LINK_ACTIVE) {
						if (strcmp(addon_name, nucb[i].name) == 0 && nucb[i].thrid >= B_NO_ERROR) {	// Link läuft schon!
							n = &nucb[i];					// Darf eigentlich nicht passieren!
							kill_thread(n->thrid);			// daher: Thread Killen
							delete_port(n->pid);			//        Port killen
							printf("NCP ERROR: Thread + Port gekillt\n");
							break;
						}
					} else n = &nucb[i];					// Freie Links merken!
				}

				n->flags = NC_LINK_ACTIVE;	// Link aktivieren
				n->remote_id = remote_id;	// Channelid merken
				strcpy(n->name, addon_name);

				c = strchr(addon_name, '.');			// Text bis zum ersten "." als add-on-Name hernehmen
				if (c != NULL) *c = '\0';				// wenn ein . enthalten ist, dann den String abschneiden

				n->ch_crc = random() & ID_MASK;
				printf ("ch_crc = %i\n", n->ch_crc);
				
   				info_msg[0] = 0;						// Die Nachricht zum NCP muß vorbereitet werden! 0-> Kanal zum NCP
   				info_msg[1] = 0xff;						// Localchannelid erstmal mit Fehlerwert belegen
   				info_msg[2] = NCON_MSG_CONNECT_RESPONSE;// Antwort auf die Connectmessage!
   				info_msg[3] = n->remote_id;				// remotechannelid. Damit der PSION weiss, um welchen Kanal es geht!
   				info_msg[4] = E_FILE_NXIST;				// Fehler aufgetreten

				n->pid = create_port(5, addon_name);										// Einen Port eröffenen, der den gleichen Namen hat, wie der add-on-Name
				n->thrid = myWindow->addOnView->StartAddOnServerThread( addon_name );

				if (n->thrid >= B_NO_ERROR) {												// wenn alles geklappt hat
					int32 msg_nr = PSION_START + n->ch_crc + (n->local_id << MOVE_CHAN);// Den Filedeskriptor für den Kanal berechnen
					write_port(n->pid, msg_nr, NULL, 0);								// und dem ADD-ON über den Port mitteilen!
					BMessage *msg = new BMessage(MSG_NCP_CONN);							// Teilen wir der Oberfläche auch noch etwas mit. Dazu wird eine BMessage generiert
					msg->AddString("Portname", addon_name);								// In der der Portname enthalten ist
					msg->AddInt8("Portnummer", n->local_id);							// Und in der die Portnummer enthalten ist
					myWindow->PostMessage(msg);											// Schicken wir die Message an das Fenster
							
	   				info_msg[1] = n->local_id;	// Localchannelid
					info_msg[4] = 0;			// Doch kein Fehler aufgetreten!
				}
   				
   				if (info_msg[4] != 0) discon_channel( n );	// Es trat ein Fehler auf, also Kanal löschen
   						
   				write_port(pid_o, PSION_CMD, info_msg, 5);
   				
				break;
			case NCON_MSG_NCP_INFO:
//			    result=0; /* completed ok */
//			    pcb->remotencpver=(*p++);
//			    remid=(*p)+((ULONG)(*(p+1))<<8)+((ULONG)(*(p+2))<<16)+((ULONG)(*(p+3))<<24);
//			    if (pcb->remotestartdate && (pcb->remotestartdate!=remid))
//			    { /* check were not talking to different controller */
//			         FailAllUsers(pcb,E_GEN_RECEIVER,NUFLAG_DISCONNECTED);
//			         pcb->remotestartdate=remid;
//			    }
//			    else
//			    { /* re-connect all channels TEMPDISC'ed when link failed */
//			         pcb->remotestartdate=remid;
//			         for (i=1,pnucb=(&pcb->usertable[1]);i<NC_MAX_USERCB;i++,pnucb++)
//			              pnucb->flags&=~NUFLAG_TEMPDISC;
//				}
//				if (pcb->remotencpver<2) /* Version 1 loads process - we dont */
//				{ /* cant talk to remote properly */
// 				     result=E_GEN_FAIL;
//				}
//				completeCtrl(pcb,result);   /* complete channel that P_FSTARTed */
				secs = real_time_clock();
				info_msg[0] = 0x00;
				info_msg[1] = 0x00;
				info_msg[2] = NCON_MSG_NCP_INFO;
				info_msg[3] = NC_VERSION_NUMBER;
				info_msg[4] = secs & 0xff;
				info_msg[5] = (secs >> 8) & 0xff;
				info_msg[6] = (secs >> 16) & 0xff;
				info_msg[7] = secs >> 24;
				write_port(pid_o, PSION_CMD, info_msg, 8);

//				thr_id = spawn_thread(StartRFSVServer, "StartRFSVServer", B_NORMAL_PRIORITY, NULL);
//				if (thr_id >= B_NO_ERROR) resume_thread(thr_id);
				
				myWindow->addOnView->StartAllClients();	// We have to start all Client add-ons
				
				break;
		}
	}
}

// init_ncp sorgt dafür, daß die richtigen Werte im nucb[0] eingetragen werden.
// sobald diese Werte enthalten sind, ist der NCP erreichbar!

void init_ncp(void) {
	int i;
	for (i = 0; i < NC_MAX_USER; i++) {	// Alles auf Startwerte setzen!
		nucb[i].flags = 0;
		nucb[i].local_id = i;
		nucb[i].thrid = B_BAD_THREAD_ID ;	// Kein Thread zum killen da!
	}

	nucb[0].flags = NC_LINK_ACTIVE;	// Port aktivieren, da hardcoded.
	nucb[0].pid = -1;				// Kein eigener Port vorhanden!
	nucb[0].ch_crc = 0;				// 0 als CRC-Nummer, damit die Kommandos gültig sind!
	nucb[0].thrid = B_BAD_THREAD_ID;// kein eigener Thread!
	nucb[0].img_id = -1;			// kein eigenes Add-on
	nucb[0].Run = NULL;				// Keine Startfunktion!
	nucb[0].local_id = 0;			// Der locale Port ist IMMER 0
	nucb[0].remote_id = 0;			// Ebenso ein fremder Port!
	strcpy(nucb[0].name, "NCP");	// Der Name ist frei erfunden und lautet NCP

	BMessage *msg = new BMessage(MSG_NCP_CONN);
	msg->AddString("Portname", "NCP");
	msg->AddInt8("Portnummer", 0);
	myWindow->PostMessage(msg);
}

// discon_all geht alle Channel durch und löscht die entsprechenden threads

void discon_all ( void )
{
	int i;
	for (i = NC_MAX_USER-1; i > 0; discon_channel(&nucb[i--])) ;	// Alle Ports schließen, außer den NCP-Port!
	write_port(pid_o, PSION_DISC, NULL, 0);	// Disconnect an den PSION schicken
											// Der ShreibThread kümmert sich auch darum, daß der NCP gestoppt wird!
											// und die serielle Schnittstelle geschlossen wird.
}

// discon_channel räumt den Kanal auf, der über NUCB angegeben ist

void discon_channel ( NUCB *n ) {
	unsigned char info_msg[4];

	if (n->flags & NC_LINK_ACTIVE) {	// Wir tun nur etwas, wenn es was zu tun gibt 
		if (n->thrid >= B_NO_ERROR ) {		// Läuft hier für den Kanal ein eigener Thread?

			info_msg[0] = 0;							// Die Nachricht zum NCP muß vorbereitet werden! 0-> Kanal zum NCP
			info_msg[1] = n->local_id;					// Localchannelid
			info_msg[2] = NCON_MSG_CHANNEL_DISCONNECT;	// Wir wollen Disconnecten
			info_msg[3] = n->remote_id;					// remotechannelid. Damit der PSION weiss, um welchen Kanal es geht!

		   	write_port(pid_o, PSION_CMD, info_msg, 4);	// send the Message to the NCP that it should disconnect all!

			snooze(100000);								// give them 1/10 Second to react to the message!
			
			if (n->pid >= B_NO_ERROR) {		// the existing Port should also be deleted, when it is open from this thread.
				delete_port(n->pid);		// delete it
				n->pid = B_BAD_PORT_ID;		// and remember that it is deleted.
			}

			kill_thread(n->thrid);			// when the thread is always running, we simple kill him
			n->thrid = B_BAD_THREAD_ID;		// and also remember the deletion.
		}

		if (n->img_id > 0) {				// War der Kanal ein add-on das geladen wurde?
			unload_add_on(n->img_id);		// Wenn ja, dann können wir das wieder aus dem Speicher entfernen!
			n->img_id = B_ERROR;			// und wieder merken.
		}

		BMessage *msg = new BMessage(MSG_NCP_DISC);	// Informieren wir das Statusfenster darüber, daß ein Kanal gelöscht wurde
		msg->AddInt8("Portnummer", n->local_id);	// Welcher Kanal war das eigentlich?
		myWindow->PostMessage(msg);					// Und ab die Post!

		n->flags &= ~NC_LINK_ACTIVE;		// Bereinigung gelaufen, also Kanal als frei markieren!
	}
}
