//============================================================================
// RfsvServerAddOn.cpp
// © Michael Pieper 14. Feb. 1999
//   last modification: Michael Pieper 9.Oct.1999
//============================================================================
//
//	This addon exports the C-Function "RunServer", which is started, when
//  the PSION asks for the "SYS$RFSV"-Server
//
//============================================================================

#include "RfsvServer.h"
#include "RfsvServerAddOn.h"
#include "ConfigView.h"

//============================================================================
extern "C" _EXPORT char InfoVersion[]="0.85  " B_UTF8_COPYRIGHT "1999-2000 by Michael Pieper";
extern "C" _EXPORT char InfoLine1[]="RFSV = Remote File SerVer";
extern "C" _EXPORT char InfoLine2[]="publishes BeOS filesystem infos";
extern "C" _EXPORT char InfoLine3[]="for the PSION 3c file-application";

extern "C" _EXPORT int32 RunServer( void );
extern "C" _EXPORT BView *ConfigView( BRect frame );
extern "C" _EXPORT int32 Initialise( void );

//============================================================================
// 

CONFIG_VAR	configs;							// here we reserve memory for the CONFIG_VAR

//============================================================================
// This Function is a Routine, which can initialize some global functions or variables

int32 Initialise( void ) {
	
	configs.debug = true;
	strcpy(configs.debugFile, "/var/log/rfsv-server.log");
	return 0;
}


//============================================================================
// We have to start the RFSV-Server

int32 RunServer( void )
{
	RfsvServer* rfsvServer;
  	rfsvServer = new RfsvServer( &configs );	// creating and running the RFSV-Server

	delete rfsvServer;				// When it returns, then clean up!
  	return 0;
}

//============================================================================
// We have to return a ConfigurationView. Every Message must be sent to
// the View itself, that we can do something with the Message!

BView *ConfigView( BRect frame )
{
	AddOnConfigView* configView;
  	configView = new AddOnConfigView( frame, &configs );

  	return configView;
}
