
#ifndef _PSINCP_THREAD_
#define _PSINCP_THREAD_

#include <KernelKit.h>

// Die nachfolgende Struktur dient dazu für jeden User eine Struktur bereitzustellen wodurch
// dieser weiß, mit wem er kommunizieren muß

#define WRITE_PORT "WritePsion"		// Name des Ports in dem Daten an den PSION geschickt werden sollen
#define CTRL_PORT  "WriteControl"	// Name des Ports für Controlzwecke

#define NC_VERSION_NUMBER   2       /* were version 2 */
#define NC_MAX_MSG_LEN		297		/* Längste Message-Inhalt ohne Sequenzid, Kanalid's und ohne Framenr */
#define NC_MAX_USER         8       /* Max number of connected users */
#define NC_MSG_SIZE         8       /* Max inter controller msg size */

typedef struct                  	/* Network User control block */
{
	uint16			flags;			/* controlling flags */
	uint16			ch_crc;			/* Eine Nummer, die als filedeskriptor dient	*/
	port_id			pid;			/* Portid über die Daten empfangen werden!	*/
	thread_id		thrid;			/* Threadid, der dafür sorgt, daß die Daten berarbeitet werden */
	unsigned char	remote_id;		/* Kanalid auf dem PSION, an den die Nachricht geschickt werden muß	*/
	unsigned char	local_id;		/* Kanalid auf dem BeOS, ist identisch mit dem Index von NUCB	*/
    char			name[16];		/* name dieses Clienten */

    image_id		img_id;			/* ImageID des Add-Ons!					*/
    int32			(*Run)(void *);	/* Funktion, die das Add-On startet			*/
} NUCB;
 
extern NUCB nucb[8];


/* NUCB flags defines */
/*#define NUFLAG_WRITE_HELD           0x01
#define NUFLAG_WRITE_OUTSTANDING    0x02
#define NUFLAG_CONNECT_REQUEST      0x08
#define NUFLAG_DISCONNECTED         0x10
#define NUFLAG_ALLOCATED            0x20
#define NUFLAG_CHANNEL_CLOSED       0x40
#define NUFLAG_DISCONNECT_REQUEST   0x80
#define NUFLAG_TEMPDISC             0x100
#define NUFLAG_NO_CONNECTION        (NUFLAG_TEMPDISC|NUFLAG_DISCONNECTED)*/

/* NCB flag defines */
#define NC_LINK_ACTIVE      0x01
#define NC_READ_QUEUED      0x02
#define NC_WRITE_QUEUED     0x04
#define NC_CONNECT_QUEUED   0x08
#define NC_TERMINATING      0x10

/* Inter controller message types */
#define NCON_MSG_DATA_XOFF          1
#define NCON_MSG_DATA_XON           2
#define NCON_MSG_CONNECT_TO_SERVER  3
#define NCON_MSG_CONNECT_RESPONSE   4
#define NCON_MSG_CHANNEL_CLOSED     5
#define NCON_MSG_NCP_INFO           6       /* MUST BE 6 for older versions*/
#define NCON_MSG_CHANNEL_DISCONNECT 7
#define NCON_MSG_NCP_END            8


//typedef struct nudata           /* Network user data control block */
//    {
//    struct nudata *pnudata;     /* next control blk in list */
//    UWORD reclen;               /* amount in buffer */
//    UBYTE recbuf[1];            /* expands as required (for C offset) */
//    } NUDATA;
//
//typedef struct                  /* Network User control block */
//    {
//    P_ICB icb;                  /* I/O control block */
//    UWORD flags;                /* controlling flags */
//    P_RQPKT read;               /* read request block */
//    P_RQPKT write;              /* write request block */
//    P_RQPKT super;              /* supervisory read request blk */
//    UBYTE localchanid;          /* local channel id number */
//    UBYTE remotechanid;         /* remote channel id number */
//    UBYTE *pncb;                /* Network handle */
//    UBYTE *handler;             /* Network client wait handler handle */
//    NUDATA *pnudata;            /* Network users queued data */
//    UWORD nclen;                /* amount in the Network Controller msg buffer */
//    UBYTE ncbuf[NC_MSG_SIZE];   /* message buffer */
//    UWORD recvbytes;            /* Number of bytes received (>1K) */
//    UWORD xmitbytes;            /* Number of bytes xmitted (>1K) */
//    ULONG recvK;                /* Number of K received */
//    ULONG xmitK;                /* Number of K transmitted */
//    UBYTE name[16];             /* name of this client */
//    } NUCB;
//
///*************************************************************************/
//
///* Inter Network user message types */
//#define NU_MSG_WRITECOMPLETE        1
//#define NU_MSG_WRITEPARTIAL         2
//
///* NCB flag defines */
//#define NC_LINK_ACTIVE      0x01
//#define NC_READ_QUEUED      0x02
//#define NC_WRITE_QUEUED     0x04
//#define NC_CONNECT_QUEUED   0x08
//#define NC_TERMINATING      0x10
//
//typedef struct
//    {
//    P_ICB icb;              /* I/O channel control blk */
//    TASK_ENTRY task;        /* Task control block */
//    UWORD flags;            /* Controlling flags */
//    WORD ctrlmsgqueue;      /* Network users have controller messages queued */
//    WORD ctrllastxmit;      /* Network users last transmitted a ctrl msg */
//    WORD usermsgqueue;      /* Network users have queued write requests */
//    WORD userlastxmit;      /* Network users last transmitted a user msg */
//    UWORD maxfrmsize;       /* maximum frame we can transmit/receive */
//    WORD wstat;             /* Write completion status */
//    WORD rstat;             /* Read completion status */
//    UWORD wlen;             /* Write length */
//    UWORD rlen;             /* Read length */
//
//    UWORD remotencpver;     /* the remote NCP version number */
//    ULONG startdate;        /* NCP start up date (logon id) */
//    ULONG remotestartdate;  /* the remote NCP logon id */
//
//    UWORD expediatedlen;    /* amount in expediated buf to transmit */
//    UBYTE expediatedbuf[NC_MSG_SIZE];
//    NUCB *lastnucb;         /* last network user to do a write */
//    NUCB *ctrlnucb;         /* Controller channel NUCB */
//    UBYTE rbuf[P_MAXILEN];   /* read buffer */
//    UBYTE wbuf[P_MAXILEN];   /* write buffer */
//    NUCB usertable[NC_MAX_USERCB];
//    } NCB;
//
//typedef struct
//    {
//    UBYTE name[18];     /* Name to associate this channel by */
//    NUCB **ppchan;      /* where to write back User channel */
//    } NCP_OPEN;

#endif