//Note: The type code is the four letter code displayed by Resourcer
//      with single quotation marks around it.
//      For instance, CSTR would be written as 'CSTR'

#include <storage/Resources.h>
status_t get_app_resource(type_code type,long id,void** buffer,size_t *lengthFound);
status_t get_app_resource(type_code type,const char *name,void** buffer,size_t *lengthFound);

status_t get_app_resource(type_code type,long id,void** buffer/*<-- do not initialize*/,size_t *lengthFound) {
	char *fiddle;
	if (be_app->AppResources()->GetResourceInfo(type,id,&fiddle,lengthFound) == false)
		return B_ERROR;
	*buffer = new unsigned char[*lengthFound];
	if (be_app->AppResources()->ReadResource(type,id,*buffer,0,*lengthFound) != B_OK)
		return B_ERROR;
	return B_OK;
}

status_t get_app_resource(type_code type,const char *name,void** buffer/*<-- do not initialize*/,size_t *lengthFound) {
	long id;
	if (be_app->AppResources()->GetResourceInfo(type,name,&id,lengthFound) == false)
		return B_ERROR;
	*buffer = new unsigned char[*lengthFound];
	if (be_app->AppResources()->ReadResource(type,id,*buffer,0,*lengthFound) != B_OK)
		return B_ERROR;
	return B_OK;
}