/*
 *  CPU.h - 6510 emulation
 *
 *  SIDPlayer (C) 1996-1998 Christian Bauer
 */

#ifndef _CPU_H
#define _CPU_H

class MOS6581;


// Class for 6510 emulation
class MOS6510 {
public:
	MOS6510();

	void Emulate(uint16 startadr, uint8 ra, uint8 rx, uint8 ry);

	uint8 *RAM;			// Pointer to main RAM
	MOS6581 *TheSID;	// Pointer to SID

protected:
	uint8 read_byte(uint16 adr);
	uint16 read_word(uint16 adr);
	void write_byte(uint16 adr, uint8 byte);

	uint8 read_zp(uint16 adr);
	uint16 read_zp_word(uint16 adr);
	void write_zp(uint16 adr, uint8 byte);

	uint8 pop_byte(void);
	uint16 pop_word(void);
	void push_byte(uint8 byte);
	void pop_flags(void);
	void push_flags(bool b_flag);

	void jump(uint16 adr);

	void do_adc(uint8 byte);
	void do_sbc(uint8 byte);

	uint8 n_flag, z_flag;
	bool v_flag, d_flag, i_flag, c_flag;
	uint8 a, x, y, sp;
	uint8 *pc, *pc_base;

	bool stack_underflow;	// Stack underflow, stop emulation
};

#endif
