#include "SKeyMessage.h"
#include "SKeyApp.h"
#include "SKeyWindow.h"
#include "Preferences.h"

#include <Application.h>
#include <storage/Resources.h>

#define ABOUT_MESS "S/Key One Time Password Generator\n\
Copyright" B_UTF8_COPYRIGHT " 1997 Brian Cully <shmit@kublai.com>\n\n\
This program comes with ABSOLUTELY NO WARRANTY. This is free software, \
you are welcome to redistribute it and modify it under the terms of the \
conditions of the GNU General Public License.\n\n\
The RSA Data Security, Inc. MD4 Message-Digest Algorithm and \
RSA Data Security, Inc. MD5 Message-Digest Algorithm are \
Copyright " B_UTF8_COPYRIGHT " 1990-1992 RSA Data Security."

SKeyApp::SKeyApp()
	    : BApplication("application/x-kublai-skey")
{
	prefs = new Preferences("x-kublai-skey");
	settings = new PreferenceSet(*prefs, "settings", true);

	if (prefs->InitCheck()) {
		prefs = NULL;
		settings = NULL;
	}
	if (settings->InitCheck()) {
		settings = NULL;
	}
}

void SKeyApp::AboutRequested()
{
	BAlert *about_box = new BAlert("", ABOUT_MESS, "OK", NULL, NULL, B_WIDTH_AS_USUAL,
								   B_INFO_ALERT);

	if (about_box)
		about_box->Go();
}

void SKeyApp::MessageReceived(BMessage *msg)
{
	switch (msg->what) {
	case SKEY_PREFS_MSG:
		BRect pos;
		bool md;

		// TODO: Make sure this data exists.
		msg->FindRect("position", &pos);
		msg->FindBool("md", &md);
		WritePrefs(pos, md);
		break;
	default:
		BApplication::MessageReceived(msg);
	}
}

bool SKeyApp::QuitRequested()
{
	return TRUE;
}

void SKeyApp::ReadyToRun()
{
	app_info info; 
	BRect win_pos;
	bool md4;

	if (GetAppInfo(&info) != B_OK) {
		BAlert *oops = new BAlert("", "Can't find myself!", "Argh", NULL,
								   NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT);
					
		oops->Go();
		return;
	}

	/* Scarf preferences. */
	const void *data;
	size_t size;
	uint32 type;

	if (settings->GetData(SKEY_WINPOS_RES, data, size, type) || type != B_RECT_TYPE)
		win_pos.Set(100, 100, 500, 210);
	else
		memcpy(&win_pos, data, size);

	if (settings->GetData(SKEY_MD_RES, data, size, type) || type != B_BOOL_TYPE)
		md4 = true;
	else
		memcpy(&md4, data, size);

	SKeyWindow *win = new SKeyWindow(win_pos, md4);
}

void SKeyApp::WritePrefs(BRect frame, bool md4)
{
	settings->SetData(SKEY_WINPOS_RES, &frame, sizeof(frame), B_RECT_TYPE);
	settings->SetData(SKEY_MD_RES, &md4, sizeof(md4), B_BOOL_TYPE);
	settings->Save();
}