#include "Mlm78.h"


Mlm78::Mlm78(void)
{
	fSensorDevice = new BFile("/dev/misc/lm78", B_READ_ONLY);
	VCore;
	V33 = 0.0;
	Vp5 = 0.0;
	Vm5 = 0.0;
	Vp12 = 0.0;
	Vm12 = 0.0;
	MotherboardTemp = 0.0;
	ChassisFan = 0.0;
	CPUFan = 0.0;
	PowerFan = 0.0;
}

Mlm78::~Mlm78(void)
{
	delete fSensorDevice;
}

status_t Mlm78::InitCheck(void)
{
	return fSensorDevice->InitCheck();
}

Mlm78::operator () (void)
{
	char buffer[256];
	char *buf = buffer;
	ssize_t len;
	len = fSensorDevice->Read(buf, 256);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%fV", &VCore);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%fV", &V33);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%fV", &Vp5);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%fV", &Vm5);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%fV", &Vp12);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%fV", &Vm12);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%f deg", &MotherboardTemp);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%f rpm", &ChassisFan);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%f rpm", &CPUFan);
	buf = strchr(buf,':')+1;
	sscanf(buf, "%f rpm", &PowerFan);
}
