/* AmArrangeToolTarget.h
 * Copyright (c)2000 by Eric Hackborn.
 * All rights reserved.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 06.29.00		hackborn
 * Created this file
 */
#ifndef AMPUBLIC_AMARRANGETOOLTARGET_H
#define AMPUBLIC_AMARRANGETOOLTARGET_H

#include <be/interface/View.h>
#include <ArpBuild.h>
#include "AmPublic/AmRange.h"
#include "AmPublic/AmTimeConverter.h"
class AmArrangeSelectionsI;
class AmArrangeWindowI;
class AmPhraseEvent;
class AmTrack;

/***************************************************************************
 * AM-ARRANGE-TOOL-TARGET
 * This utility class provides all the behaviour that tools editing arrange
 * views need to function.  This is analogous to the AmToolTarget, but
 * simplified, since arrange views only work on phrases, not on events.
 ***************************************************************************/
class AmArrangeToolTarget
{
public:
	/* The default 0 is provided as a convenience in certain situations,
	 * but be aware that until you set a valid view and time converter
	 * this class will not function.
	 */
	AmArrangeToolTarget(AmArrangeWindowI* win = 0, BView* view = 0, const AmTimeConverter* mtc = 0);
	virtual ~AmArrangeToolTarget();
	
	void			SetOverViewWindow(AmArrangeWindowI* win);
	BView*			View() const;
	void			SetView(BView* view);
	const AmTimeConverter* TimeConverter() const;
	void			SetTimeConverter(const AmTimeConverter* mtc);
		
	/*---------------------------------------------------------
	 * PHRASE ACCESSING
	 *---------------------------------------------------------*/
	/* Answer the phrase event exactly at the point supplied.
	 */
	AmPhraseEvent*	PhraseEventAt(const AmTrack* track, BPoint where) const;

	/*---------------------------------------------------------
	 * SELECTION
	 *---------------------------------------------------------*/
	/* Clients should never delete the answered selections object.  If
	 * they want to clear the selections, they should send 0 to SetSelections().
	 */
	AmArrangeSelectionsI*	Selections() const;
	/* Clients should never get the selections, modify them, and do nothing
	 * else -- they should always call set if they've changed them.
	 */
	void					SetSelections(AmArrangeSelectionsI* selections);

protected:
	AmArrangeWindowI*			mWin;
	BView*						mView;
	const AmTimeConverter*		mMtc;
};

#endif
