/* AmBankI.h
 * Copyright (c)1996 - 1998 by Eric Hackborn.
 * All rights reserved.
 *
 * This class stores one bank of patch names.  A bank is currently
 * at most 128 patches.  I think some synthesizers don't obey this limit,
 * so that might change.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	• None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 08.10.98		hackborn
 * Mutated this file from its original incarnation.
 */


#ifndef AMPUBLIC_AMBANKI_H
#define AMPUBLIC_AMBANKI_H

#ifndef ARPKERNEL_ARPREF_H
#include <ArpKernel/ArpRef.h>
#endif

#ifndef _SUPPORT_DEFS_H
#include <be/support/SupportDefs.h>
#endif

#ifndef __BSTRING__
#include <be/support/String.h>
#endif

class AmBankI : public ArpRefableI {
	public:
		virtual ~AmBankI() { }

		virtual uint32 BankNumber() const = 0;
		
		virtual BString PatchName(uint32 patchNumber) const = 0;
		virtual uint32 CountPatches() const = 0;
};

#endif /* ARP_MIDI_BANK_H */
