/* AmTrackViewI.h
 * Copyright (c)2000 by Eric Hackborn.
 * All rights reserved.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 05.17.00		hackborn
 * Created this file.
 */

#ifndef AMPUBLIC_AMTRACKVIEWI_H
#define AMPUBLIC_AMTRACKVIEWI_H

#include <be/support/String.h>
#include "AmPublic/AmTimeConverter.h"
#include "AmPublic/AmTrackRef.h"

/*************************************************************************
 * AM-TRACK-VIEW-I
 * Most Sequitur views that display track data are required to implement
 * this interface.  Implementors should just take and use what pieces apply.
 *************************************************************************/
class AmTrackViewI
{
public:
	virtual ~AmTrackViewI()										{ }

	/* Set my track ref.  This is required.
	 */
	virtual void SetTrackRef(AmTrackRef trackRef) = 0;
	/* Set my time converter.  This is optional.  Implementors
	 * are supplied a pointer in cases where the time converter
	 * is coming from a parent that wants to share.
	 */
	virtual void SetTimeConverter(const AmTimeConverter* mtc)	{ }
	/* Some implementors will want to keep track of what generated
	 * this view.
	 */
	virtual void SetFactoryKey(const BString& signature, const BString& name) { }
	/* Some implementors will generate messages that configure their
	 * current state.  These implementors will be supplied configuration
	 * data.
	 */
	virtual void SetConfiguration(const BMessage* config)		{ }
};

#endif 
