/* AmViewFactory.h
 * Copyright (c)1998-2000 by Eric Hackborn.
 * All rights reserved.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 11.22.98		hackborn
 * Added the ArpNoView.  See that class for comments.
 *
 * 10.28.98		hackborn
 * Created this file
 */

#ifndef AMPUBLIC_AMVIEWFACTORY_H
#define AMPUBLIC_AMVIEWFACTORY_H

#include <be/interface/View.h>
#include <be/support/List.h>
#include "AmPublic/AmDefs.h"
#include "AmPublic/AmViewPropertyI.h"
#include "AmPublic/AmSongRef.h"
#include "AmPublic/AmTrackRef.h"
#include "AmPublic/AmTimeConverter.h"
class AmArrangeSelectionsI;

#define SZ_FACTORY_SIGNATURE	"factory signature"
#define SZ_FACTORY_VIEW_NAME	"factory view name"

enum {
	AM_STOP_MSG		= 'aStp'
};

/***************************************************************************
 * AM-VIEW-FACTORY
 * This object acts as an interface between the window classes and the
 * views for displaying and editing events.  Currently, it is only responsible
 * for generating new views of various types.  In the future, it will be
 * responsible for handling specific pieces of communication that occur
 * between the Sequitur window classes and the views it generates.
 ***************************************************************************/
#define STR_AMVIEWFACTORY		"AmViewFactory"

class AmViewFactory
{
public:
	AmViewFactory();
	virtual ~AmViewFactory()					{ }

	/* Subclasses can respond with a string that represents the type of data
	 * they can handle.  The currently defined types are:
	 *		"MIDI"
	 *		"Audio"
	 */
	virtual const char* EventMetaType() const = 0;
		
	BString&		Signature()							{ return mSignature; }
	BList&			OverViewNames()						{ return mOverViewNames; }
	/* Clients can use this method to iterate over the subclasses collection
	 * of data view names, based on the given view type.
	 */
	virtual BString	DataNameAt(uint32 index, TrackViewType type) const = 0;
	/* Subclasses can override this to set the preferred data name to be
	 * any of the strings supplied in DataNameAt().  By default, the priamry
	 * data name at 9 is answered.
	 */
	virtual BString	PreferredDataName() const;

	virtual BView*	NewArrangeView(	AmSongRef songRef,
									AmTrackRef trackRef,
									const AmTimeConverter* mtc,
									const AmViewPropertyI* property) = 0;

	virtual BView*	NewDataView(	AmSongRef songRef,
									AmTrackRef trackRef,
									const AmTimeConverter* mtc,
									const AmViewPropertyI* property,
									TrackViewType type) = 0;

	virtual BView*	NewInfoView(	AmSongRef songRef,
									AmTrackRef trackRef,
									const AmViewPropertyI* property,
									TrackViewType type) = 0;

protected:
	void SetSignature(const char *signature)		{ mSignature = signature; }
	bool AddOverViewName(const char *overViewName);

private:
	BString		mSignature;
	BList		mOverViewNames;
};

/******************************************************************
 * AM-ARRANGE-WINDOW-I
 * A window which will contain overview objects is expected to
 * implement this interface.
 ******************************************************************/
class AmArrangeWindowI
{
public:
	/* Clients should never delete the answered selections object.  If
	 * they want to clear the selections, they should send 0 to SetSelections().
	 */
	virtual AmArrangeSelectionsI*	Selections() const = 0;
	/* Clients should never get the selections, modify them, and do nothing
	 * else -- they should always call set if they've changed them.
	 */
	virtual void					SetSelections(AmArrangeSelectionsI* selections) = 0;
};

/*************************************************************************
 * ARP-NO-VIEW 
 * This is a small class used to generate new 'error' views --
 * views that indicate to the user something was wrong trying to generate
 * the view that has been requested.  For example, if a track uses an
 * AmViewFactory that is not loaded, this class can be instantiated
 * to inform the user.  Typically, a BStringView with the problem is added
 * as a child of this view.
 *************************************************************************/
class ArpNoView : public BView
{
public:
	ArpNoView(	BRect frame,
				const char *name,
				uint32 resizeMask,
				uint32 flags);

	virtual void AttachedToWindow();
	virtual void Draw(BRect updateRect);
};


#endif 
