/* ArpRandomFlow.h
 * Copyright (c)2000 by Eric Hackborn
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 08.14.00		hackborn
 * Created this file
 */

#include <be/app/Message.h>
#include <be/interface/View.h>
#include "AmPublic/AmFilterI.h"

/*****************************************************************************
 * ARP-RANDOM-FLOW-FILTER
 * This filter generates a control change with each note on.
 *****************************************************************************/
class ArpRandomFlowFilterAddOn;

class ArpRandomFlowFilter : public AmFilterI
{
public:
	ArpRandomFlowFilter(ArpRandomFlowFilterAddOn* addon,
						AmFilterHolderI* holder,
						const BMessage* config);
	virtual ~ArpRandomFlowFilter();
	
	virtual AmEvent* HandleEvent(AmEvent* event, const am_filter_params* params = NULL);
	virtual BView* NewEditView(BPoint requestedSize) const;
	
	virtual status_t GetConfiguration(BMessage* values) const;
	virtual status_t PutConfiguration(const BMessage* values);
	virtual status_t Configure(ArpVectorI<BView*>& panels);

private:
	ArpRandomFlowFilterAddOn*	mAddOn;
	AmFilterHolderI*			mHolder;
	/* This determines the length that one control change fades into
	 * another.  If the value is zero, then the fade is immediate
	 * (i.e., a new control change is generated on the incoming event's
	 * time).  If the value is negative, then the previous control change
	 * fades into the new one, and reaches at the start of the event.
	 * If the value is positive, then the old control change starts fading
	 * into the new one as soon as the event starts.
	 *
	 * This value is not stored in PPQN or anything else.  It's stored
	 * as a range of -100 to 100, then divided by 25 and mutlipled by
	 * the PPQN.  I.e., the maximum fade time is 1 measure in 4/4 time.
	 */
	int32						mFade;
	uint8						mPrevControlValue;
	/* The control number that gets generated with each note on.
	 */
	uint8						mControlNumber;
	/* When generating a random control value, this is the range I'm
	 * confined to.
	 */
	uint8						mMinValue, mMaxValue;

	uint8						RandomControlValue() const;
};

/*****************************************************************************
 * ARP-RANDOM-FLOW-FILTER-ADD-ON
 *****************************************************************************/
class ArpRandomFlowFilterAddOn : public AmFilterAddOn
{
public:
	ArpRandomFlowFilterAddOn(const void* cookie)
		: AmFilterAddOn(cookie)
	{
	}
	
	virtual VersionType Version(void) const				{ return VERSION_CURRENT; }
	virtual const char* Name() const					{ return "Random Control"; }
	virtual const char* ClassName() const				{ return "arp:RandomControl"; }
	virtual const char* ShortDescription() const		{ return "THIS FILTER IS OBSOLETE, USE PANDEMIC INSTEAD"; }
	virtual const char* Author() const					{ return "Eric Hackborn"; }
	virtual void		GetVersion(int32* major, int32* minor) const;
	virtual type Type() const							{ return NORMAL_FILTER; }
	virtual BBitmap* Image(BPoint requestedSize) const;
	virtual AmFilterI* NewInstance(	AmFilterHolderI* holder,
									const BMessage* config = 0);
};
