/*
 * AddExt.cpp
 * This code was written by Tim Vernum.
 * It has been placed in the public domain.
 */

/*
   This program is a simple commandline app for BeOS that allows one to associate
   an extension with a given mime-type
 */

#include <err.h>
#include <stdio.h>
#include <string.h>

#include <Mime.h>

const int kErrUsage = -1 ;
const int kErrSetFailed = 1 ;
const int kErrGetFailed = 2 ;

int Usage( char * name )
{
	fprintf( stderr, "%s: <mime-type> <extentions>\n", name ) ;
	return kErrUsage ;
}

int main( int argc, char ** argv )
{
	bool bSet = false ;
	int mime = 1 ;
	int ext = 2 ;
		
	if( argc < 3 )
		return Usage( argv[0] ) ;

	if( argv[1][0] == '-' && argv[1][1] == 's' )
	{
		bSet = true ;
		mime ++ ;
		ext ++ ;
		if( ext >= argc )
			return Usage( argv[0] ) ;
	}
	
	BMimeType mimetype( argv[mime] ) ;
	BMessage msg ;
	status_t s ;
	
	if( !bSet )
	{
		s = mimetype.GetFileExtensions( &msg ) ;
	
		if( s != B_OK  && s != B_ENTRY_NOT_FOUND )
		{
			fprintf( stderr, "Error: Cannot get existing extensions: %s\n", strerror( s ) ) ;
			return kErrGetFailed ;
		}
	}
	
	type_code type ;
	int32 count ;
	if( msg.GetInfo( "extensions", &type, &count ) != B_OK )
		count = 0 ;
		
	for( int32 i=ext; i<argc; i++ )
	{
		for( int32 j=0; j<count ; j++ )
		{
			const char * existingExt ;
			if( msg.FindString( "extensions", j, &existingExt ) == B_OK 
			 && strcmp( existingExt, argv[i] ) == 0 )
				goto nextArg ;
		}
		msg.AddString( "extensions", argv[i] ) ;

nextArg:	;

	}
	
	s = mimetype.SetFileExtensions( &msg ) ;
	if( s != B_OK )
	{
		fprintf( stderr, "Error: Cannot set extensions: %s\n", strerror( s ) ) ;
		return kErrSetFailed ;
	}
	
	return 0 ;
}

	
		