/* ram_drive.c a merge of mine and Carlos' code*/

/* Version 5.00 This version combines Carlos working code and my comments to hopefully make a better driver */
/* I have added dymanicly allocate memory so as not to use too much memory. */

/* From Carlos Hasan: To test the driver, copy the binary to  
~/config/add-ons/kernel/drivers/bin/ramdrive, and make a link in  
~/config/add-ons/kernel/drivers/dev/disk/virtual/.  */

/* Btw, if you don't have another PC to debug the driver through the serial line and dprintf(), do the following:

- Press F1 when you boot BeOS, and enable the output console
- Open a Terminal window and type:

	tail -f /var/log/syslog

You will see the messages printed with dprintf() in your Terminal. */

/* Notes for E.C.P. ------------  IT WORKS GREAT NOW !!!!!!!!!!!!!!!!!!!!!!! 

How to get it to partition and work with 16MB and greater.  The compiler will place the binary in ~/config/add-ons/kernel/drivers/bin/ as 
per Carlos Hasan's instructions.  However, the name of the file has been changed to "ram", when I use "ramdisk" as the file name I found 
that DriveSetup kept seeing a drive called "ram"!   So I decide to go along with DriveSetup and give a drive named "ram".
In ~/config/add-ons/kernel/drivers/dev/disk/virtual/ I created a link to the binary also called "ram".  Then when you use the DriveSetup 
you will find a entry for the ramdrive called "ram" and partition it.  Then initilize the partition.  It should work fine.  

                Earl Colby Pottinger                                    */

#include <OS.h>
#include <Drivers.h>
#include <KernelExport.h>
#include <Mime.h>
#include <stdlib.h>
#include <Errors.h>
#include <string.h>

status_t vd_open(const char *name, uint32 flags, void **cookie);
status_t vd_free(void *cookie);
status_t vd_close(void *cookie);
status_t vd_control(void *cookie, uint32 msg, void *buf, size_t size);
status_t vd_read(void *cookie, off_t pos, void *buf, size_t *count);
status_t vd_write(void *cookie, off_t pos, const void *buf, size_t *count);

enum { RAM_SECTORS =     512, /* Number of blocks per track */
       RAM_TRACKS =       32, /* Number of cylinders per platter */
       RAM_HEADS =         8, /* Number of surfaces */
       RAM_BLOCK_SIZE =  512, /* Bytes per sector. Set to 512 to support DOS formatting */
       RAM_SECTORS_SUM = ((RAM_SECTORS)*(RAM_TRACKS)*(RAM_HEADS)), /* Number of sectors in the RAMDrive. */
       RAM_DRIVE_SIZE =  ((RAM_SECTORS_SUM)*(RAM_BLOCK_SIZE)),     /* size of the RAMDrive in bytes */ 
       CHUNK =         65536, /* Size of memory chunks to allocate. */
       CHUNKY,                /* Chunk+1.  Used for testing read/writes to allocated chunks. */
       INDEXS = ((RAM_DRIVE_SIZE)/(CHUNK)) } ;

/* null-terminated array of device names supported by this driver */
static const char *vd_name[] = { "disk/virtual/ram", NULL } ;

/* Buffers and pointers needed for reading and writing to drive. */
static uchar* Buffer_Index[INDEXS]; /* Index Array of allocated RAMDISK storage buffers. */
static long i;                      /* Counter. */
static bool BLOCK_IO = TRUE;        /* Flag */

/* static const uchar icon_disk[B_LARGE_ICON * B_LARGE_ICON]; */
uchar icon_disk [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0x00,
	0x15,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x00,0x15,
	0x3f,0x15,0x15,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x3f,
	0x15,0x15,0x15,0x16,0x15,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0x00,0x15,0x3f,0x15,
	0x15,0x15,0x16,0x15,0x15,0x15,0x16,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x00,0x15,0x3f,0x15,0x15,
	0x15,0x16,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x3f,0x15,0x15,0x15,
	0x16,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x16,0x3f,0x0e,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0x00,0x15,0x3f,0x15,0x15,0x15,0x16,
	0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x16,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x00,0x15,0x3f,0x15,0x15,0x15,0x16,0x15,
	0x15,0x15,0x16,0x15,0x15,0x15,0x16,0x3f,0x00,0x3f,0x3f,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x3f,0x15,0x15,0x15,0x16,0x15,0x15,
	0x15,0x16,0x15,0x15,0x15,0x16,0x3f,0x00,0x00,0x00,0x3f,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x00,0xff,0x00,0x15,0x3f,0x15,0x15,0x15,0x16,0x15,0x15,0x15,
	0x16,0x15,0x15,0x15,0x16,0x00,0x00,0x00,0x00,0x00,0x15,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x00,0x3f,0x00,0x15,0x3f,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x16,
	0x15,0x15,0x15,0x16,0x3f,0x00,0x3f,0x3f,0x00,0x00,0x15,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x00,0x00,0x15,0x3f,0x15,0x15,0x16,0x16,0x15,0x15,0x15,0x16,0x15,
	0x16,0x15,0x15,0x3f,0x00,0x00,0x00,0x3f,0x00,0x00,0x15,0x00,0x0f,0xff,0xff,0xff,
	0xff,0xff,0xff,0x00,0x15,0x3f,0x15,0x15,0x16,0x16,0x15,0x15,0x15,0x16,0x15,0x15,
	0x15,0x16,0x00,0x00,0x00,0x00,0x00,0x15,0x00,0x00,0x15,0x00,0x0f,0xff,0xff,0xff,
	0xff,0xff,0x00,0x15,0x3f,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x16,0x16,0x15,0x15,
	0x15,0x3f,0x00,0x3f,0x3f,0x00,0x00,0x15,0x00,0x00,0x15,0x00,0x0f,0xff,0xff,0xff,
	0xff,0xff,0x00,0x3f,0x3f,0x15,0x15,0x16,0x15,0x15,0x15,0x16,0x15,0x15,0x16,0x15,
	0x3f,0x00,0x00,0x00,0x3f,0x00,0x00,0x15,0x00,0x0f,0x00,0x0f,0xff,0xff,0xff,0xff,
	0xff,0xff,0x00,0x00,0x15,0x3f,0x3f,0x15,0x16,0x15,0x16,0x15,0x15,0x15,0x15,0x00,
	0x00,0x00,0x00,0x00,0x16,0x00,0x00,0x15,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x00,0x15,0x00,0x00,0x15,0x3f,0x3f,0x16,0x15,0x15,0x15,0x16,0x3f,0x00,
	0x3f,0x3f,0x00,0x00,0x15,0x00,0x00,0x15,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x00,0x15,0x38,0x35,0x00,0x00,0x15,0x3f,0x3f,0x15,0x15,0x3f,0x00,0x00,
	0x00,0x3f,0x00,0x00,0x15,0x00,0x0f,0x00,0x0f,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x00,0x00,0x35,0x35,0xeb,0x2c,0x00,0x00,0x15,0x3f,0x3f,0x0e,0x0f,0x00,
	0x00,0x16,0x00,0x00,0x15,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x00,0x00,0x2c,0x2c,0x15,0x15,0x00,0x00,0x15,0x0f,0x00,0x16,
	0x00,0x15,0x00,0x00,0x15,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x00,0x00,0x15,0x0f,
	0x00,0x15,0x00,0x0f,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x00,0x0f,0x00,
	0x00,0x16,0x00,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x0f,0x00,0x0f,
	0x00,0x15,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0e,0x0f,
	0x0f,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff } ;

/* static const uchar icon_disk_mini[B_MINI_ICON * B_MINI_ICON]; */
uchar icon_disk_mini [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x3f,0x15,0x00,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x3f,0x15,0x15,0x15,0x16,0x00,0x00,0xff,0xff,
	0xff,0xff,0xff,0xff,0x00,0x00,0x3f,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x00,0xff,
	0xff,0xff,0x00,0x00,0x00,0x3f,0x15,0x15,0x15,0x16,0x15,0x15,0x00,0x00,0x00,0xff,
	0xff,0xff,0x00,0x00,0x3f,0x15,0x15,0x15,0x16,0x15,0x15,0x3f,0x15,0x00,0x00,0xff,
	0xff,0xff,0x00,0x3f,0x15,0x15,0x15,0x16,0x16,0x15,0x00,0x00,0x08,0x00,0xff,0xff,
	0xff,0x00,0x3f,0x15,0x15,0x15,0x16,0x15,0x15,0x3f,0x15,0x00,0x00,0x00,0xff,0xff,
	0xff,0x00,0x3f,0x3f,0x15,0x16,0x15,0x15,0x00,0x00,0x08,0x00,0xff,0x00,0xff,0xff,
	0xff,0x00,0x0e,0x34,0x3f,0x3f,0x16,0x3f,0x15,0x00,0x00,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0x00,0x00,0x2a,0x0e,0x3f,0x0e,0x09,0x00,0xff,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x00,0x00,0x0e,0x09,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff } ;

/* Device Hooks - The hook functions specified in the device_hooks function returned by the driver's find_device() function handle requests 
made by devfs (and through devfs, from user applications). These are described in this section. 
The structure itself looks like this: 
      typedef struct { 
            device_open_hook open; 
            device_close_hook close; 
            device_free_hook free; 
            device_control_hook control; 
            device_read_hook read; 
            device_write_hook write; 
            device_select_hook select; 
            device_deselect_hook deselect; 
            device_readv_hook readv; 
            device_writev_hook writev; 
      } device_hooks;
In all cases, return B_OK if the operation is successfully completed, or an appropriate error code if not. */

/* function pointers for the device hooks entry points */
static device_hooks vd_devices = 
{ vd_open,    /* -> open entry point */
  vd_close,   /* -> close entry point */
  vd_free,    /* -> free cookie */
  vd_control, /* -> control entry point */
  vd_read,    /* -> read entry point */
  vd_write,   /* -> write entry point */
  NULL,       /* my_device_select,   -> select entry point */
  NULL,       /* my_device_deselect, -> deselect entry point */
  NULL,       /* my_device_readv,    -> posix read entry point */
  NULL } ;    /* my_device_writev    -> posix write entry point */ 
  
/* init_hardware - This function is called when the system is booted, which lets the driver detect and reset the hardware it controls. The 
function should return B_OK if the initialization is successful; otherwise, an appropriate error code should be returned. If this function 
returns an error, the driver won't be used.*/

status_t init_hardware (void) { 
 long i;  
 dprintf("<<<< RAMDISK: Init Hardware >>>>\n"); 
 for (i=0; i<INDEXS; i++) { 
     Buffer_Index[i]=NULL; } /* Clear index allocations buffer */
 return B_OK; } ;

/* init_driver - optional function - called every time the driver is loaded. Drivers are loaded and unloaded on an as-needed basis. When a 
driver is loaded by devfs, this function is called to let the driver allocate memory and other needed system resources. Return B_OK if 
initialization succeeds, otherwise return an appropriate error code. <<<what happens if this returns an error?>>> */

status_t init_driver(void) { 
 dprintf("<<<< RAMDISK: init_driver() >>>>\n");
 return B_OK; } ;

/* uninit_driver - This function is called by devfs just before the driver is unloaded from memory. This lets the driver clean up after 
itself, freeing any resources it allocated. */

void uninit_driver(void) { 
 dprintf("<<<< RAMDISK: uninit_driver() >>>>\n"); 
 return; } ;

/* publish_devices - return a null-terminated array of devices supported by this driver.  Devfs calls publish_devices() to learn the names, 
relative to /dev, of the devices the driver supports. The driver should return a NULL-terminated array of strings indicating all the 
installed devices the driver supports. For example, an ethernet device driver might return: 
    static char *devices[] = { "net/ether", NULL };
In this case, devfs will then create the pseudo-file /dev/net/ether, through which all user applications can access the driver.  Since only 
one instance of the driver will be loaded, if support for multiple devices of the same type is desired, the driver must be capable of 
supporting them. If the driver senses (and supports) two ethernet cards, it might return: 
    static char *devices[] = { "net/ether1", "net/ether2", NULL }; */

const char** publish_devices() { 
   dprintf("<<<< RAMDISK: publish_devices() >>>>\n"); 
 return vd_name; } ;

/* find_device - return ptr to device hooks structure for a	given device name. When a device published by the driver is accessed, devfs 
communicates with it through a series of hook functions that handle the requests.The find_device() function is called to obtain a list of 
these hook functions, so that devfs can call them. The device_hooks structure returned lists out the hook functions. The device_hooks 
structure, and what each hook does, is described in the next section. */

device_hooks* find_device(const char* name) { 
   dprintf("<<<< RAMDISK: find_device() >>>>\n"); 
 return &vd_devices; } ;

/* api_version - This variable defines the API version to which the driver was written, and should be set to B_CUR_DRIVER_API_VERSION at 
compile time. The value of this variable will be changed with every revision to the driver API; the value with which your driver was 
compiled will tell devfs how it can communicate with the driver. */

 int32 api_version = B_CUR_DRIVER_API_VERSION;

/* open_hook() - status_t open_hook(const char *name, uint32 flags, void **cookie) 
This hook function is called when a program opens one of the devices supported by the driver. The name of the device (as returned by 
publish_devices()) is passed in name, along with the flags passed to the Posix open() function. cookie points to space large enough for you 
to store a single pointer. You can use this to store state information specific to the open() instance. If you need to track information on 
a per-open() basis, allocate the memory you need and store a pointer to it in *cookie. */
/* my_device_open - handle open() calls */

status_t vd_open(const char *dname, uint32 flags, void **cookie) { 
   dprintf("<<<< RAMDISK: open(%s) >>>>\n", dname); 
 return B_NO_ERROR; } ;

/* free_hook() - status_t free_hook(void *cookie) 
This hook is called once all pending transactions on an open (but closing) instance of your driver are completed. This is where your driver 
should release instancewide system resources. free_hook() doesn't correspond to any Posix function. */
/* my_device_free - called after the last device is closed, and after all i/o is complete. */

status_t vd_free (void *cookie) { 
   dprintf("<<<< RAMDISK: free() >>>>\n"); 
 return B_NO_ERROR; } ;

/* close_hook() - status_t close_hook(void *cookie) 
This hook is called when an open instance of the driver is closed using the close() Posix function. Note that because of the multithreaded 
nature of the BeOS, it's possible there may still be transactions pending, and you may receive more calls on the device. For that reason, 
you shouldn't free instance-wide system resources here.  Instead, you should do this in free_hook(). However, if there are any blocked 
transactions pending, you should unblock them here. */
/* my_device_close - handle close() calls */

status_t vd_close(void *cookie) { 
   dprintf("<<<< RAMDISK: close() >>>>\n"); 
 return B_NO_ERROR; } ;

/* read_hook() - status_t read_hook(void *cookie, off_t position, void *data, size_t *len) 
This hook handles the Posix read() function for an open instance of your driver. Implement it to read len bytes of data starting at the 
specified byte position on the device, storing the read bytes at data. Exactly what this does is device-specific (disk devices would read 
from the specified offset on the disk, but a graphics driver might have some other interpretation of this request). Before returning, you 
should set len to the actual number of bytes read into the buffer. Return B_OK if data was read (even if the number of returned bytes is 
less than requested), otherwise return an appropriate error. */
/* my_device_read - handle read() calls */

status_t vd_read(void *cookie, off_t pos, void *buf, size_t *count) { 
 off_t i; size_t len; long index; long x = 0; long y = 0; uchar* buffer; status_t ret = B_NO_ERROR; 
   //dprintf("<<<< RAMDISK: read() raw position on disk (%ld) >>>>\n",(long)pos);
 index = pos / CHUNK; pos = pos - (index * CHUNK); len = (*count);
 while (len > 0) {                           // If there is data, read from RAMDISK buffers.
       //dprintf("<<<< READ: index=(%ld)  offset=(%ld)  lenght=(%ld) >>>>\n",(long)index,(long)pos,(long)len);
       buffer = Buffer_Index[index];         // Get pre-allocated read buffer.
       if (buffer == NULL) {                 // Test if buffer exists already.
          dprintf("<<<< Create a read buffer. >>>>\n");
          buffer = malloc(CHUNK);            // If none, allocate a new one.
          Buffer_Index[index] = buffer;      // Save pointer to buffer for future use.
          if (buffer == NULL) { 
             dprintf("<<<< Failed creating a write buffer! >>>>\n");
             ret = B_ERROR; len=0; }         // Failed!  No buffer could be created.
          else { 
             for (i=0; i<CHUNK; i++) {       // Zero out the contents of the new buffer.
                 *(buffer+i) = (uchar)0; } ; /*end_for*/ 
          } ; /*end_else_&_if* (buffer == NULL)*/
       } ; /*end_if (buffer == NULL)*/
       if (ret == B_NO_ERROR) {              // Read buffer is available.
          if ((pos+len) < CHUNKY) {          // Remaining data is all inside inside this buffer.
             memcpy(buf+x, buffer+pos, len); // Copy data from buffer. 
             len = 0;                        // Flag, end of data to copied.
          } /*end_if (pos+len) < CHUNKY)*/
          if ((pos+len) > CHUNK) {           // Remaining data is larger than this buffer.
             y = CHUNK-pos;                  // How much data remains in this buffer.
             memcpy(buf+x, buffer+pos, y);   // Copy data from buffer to the end of this buffer.
             len = len - y;                  // Reduce lenght by amount already transfered.
             x = x + y;                      // Increase read buffer pointer by amount already transfered.
             index++;                        // Index to next read buffer.
             pos = 0;                        // Point to start of next buffer.
           } ; /*end_if* ((pos+len) > CHUNK) */
        } ; /* end_if (ret == B_NO_ERROR) */
 } /*end_while*/
 return ret; }                               /* Return error status. */

/* write_hook() - status_t write_hook(void *cookie, off_t position, void *data, size_t len) 
This hook handles the Posix write() function for an open instance of your driver. Implement it to write len bytes of data starting at the 
specified byte position on the device, from the buffer pointed to by data. Exactly what this does is device-specific (disk devices would 
write to the specified offset on the disk, but a graphics driver might have some other interpretation of this request). Return B_OK if data 
was read (even if the number of returned bytes is less than requested), otherwise return an appropriate error. */ 
/* my_device_write - handle write() calls */

status_t vd_write(void *cookie, off_t pos, const void *buf, size_t *count) { 
 off_t i; size_t len; long index; long x; long y; uchar* buffer; status_t ret = B_NO_ERROR; 
   //dprintf("<<<< RAMDISK: write() position (%ld) >>>>\n",(long)pos);
 index = pos / CHUNK; pos = pos - (index * CHUNK); len = (*count); x = 0;
 while (len > 0) {                           // If there is data, write to RAMDISK buffers.
       //dprintf("<<<< WRITE: index=(%ld)  offset=(%ld)  lenght=(%ld) >>>>\n",(long)index,(long)pos,(long)len);
       buffer = Buffer_Index[index];         // Get pre-allocated write buffer.
       if (buffer == NULL) {                 // Test if buffer exists already.
          dprintf("<<<< Create a write buffer. >>>>\n");
          buffer = malloc(CHUNK);            // If none, allocate a new one.
          Buffer_Index[index] = buffer;      // Save pointer to buffer for future use.
          if (buffer == NULL) { 
             dprintf("<<<< Failed creating a write buffer! >>>>\n");
             ret = B_ERROR; len=0; }         // Failed!  No buffer could be created.
          else { 
             for (i=0; i<CHUNK; i++) {       // Zero out the contents of the new buffer.
                 *(buffer+i) = (uchar)0; } ; /*end_for*/ 
          } ; /*end_else_&_if* (buffer == NULL)*/
       } ; /*end_if (buffer == NULL)*/
       if (ret == B_NO_ERROR) {              // Write buffer is available.
          if ((pos+len) < CHUNKY) {          // Remaining data is all inside inside this buffer.
             memcpy(buffer+pos, buf+x, len); // Copy data from buffer. 
             len = 0;                        // Flag, end of data to copied.
          } /*end_if (pos+len) < CHUNKY)*/
          if ((pos+len) > CHUNK) {           // Remaining data is larger than this buffer.
             y = CHUNK-pos;                  // How much data remains in this buffer.
             memcpy(buffer+pos, buf+x, y);   // Copy data from buffer to the end of this buffer.
             len = len - y;                  // Reduce lenght by amount already transfered.
             x = x + y;                      // Increase read buffer pointer by amount already transfered.
             index++;                        // Index to next read buffer.
             pos = 0;                        // Point to start of next buffer.
           } ; /*end_if* ((pos+len) > CHUNK) */
        } ; /*end_if (ret == B_NO_ERROR)*/
 } /*end_while*/
 return ret; }                               /* Return error status. */

/* readv_hook() - status_t readv_hook(void *cookie, off_t position, const struct iovec *vec, size_t count, size_t *len) 
This hook handles the Posix readv() function for an open instance of your driver. This is a scatter/gather read function; given an array of 
iovec structures describing address/length pairs for a group of destination buffers, your implementation should fill each successive buffer 
with bytes, up to a total of len bytes. The vec array has count items in it. As with read_hook(), set len to the actual number of bytes 
read, and return an appropriate result code. */

/* static status_t my_device_readv(void *cookie, off_t position, const iovec *vec, size_t count, size_t *len)
{ dprintf("<<<< MY_Device_ReadV >>>>\n"); return B_OK; } */

/* writev_hook() - status_t writev_hook(void *cookie, off_t position, const struct iovec *vec, size_t count, size_t *len) 
This hook handles the Posix writev() function for an open instance of your driver. This is a scatter/gather write function; given an array 
of iovec structures describing address/length pairs for a group of source buffers, your implementation should write each successive buffer 
to disk, up to a total of len bytes. The vec array has count items in it. Before returning, set len to the actual number of bytes written, 
and return an appropriate result code. */

/* static status_t my_device_writev(void *cookie, off_t position, const iovec *vec, size_t count, size_t *len)
{ dprintf("<<<< MY_Device_WriteV >>>>\n"); return B_OK; } */

/* select_hook() , deselect_hook() */
/* These hooks are reserved for future use. Set the corresponding entries in your device_hooks structure to NULL. */

/* status_t my_device_select(void *cookie, uint8 event, uint32 ref, selectsync *sync) 
{ dprintf("MY_Device_Select\n"); return B_OK; }

status_t my_device_deselect(void *cookie, uint8 event, selectsync *sync) 
{ dprintf("MY_Device_DeSelect\n"); return B_OK; } */

/* control_hook() - status_t control_hook(void *cookie, uint32 op, void *data, size_t len) 
This hook handles the ioctl() function for an open instance of your driver. The control hook provides a means to perform operations that 
don't map directly to either read() or write(). It receives the cookie for the open instance, plus the command code op and the data and len 
arguments specified by ioctl()'s caller. These arguments have no inherent relationship; they're simply arguments to ioctl() that are 
forwarded to your hook function. Their definitions are defined by the driver. Common command codes can be found in be/drivers/Drivers.h.  
The len argument is only valid when ioctl() is called from user space; the kernel always sets it to 0. */ 
/* my_device_control - handle ioctl calls */

status_t vd_control(void *cookie, uint32 ioctl, void *arg1, size_t len)
{ device_geometry *dinfo; device_icon *dicon; partition_info *pinfo; 
  dprintf("<<<< RAMDISK: Device_Control\n");      /* generic mass storage device IO control codes */
  switch (ioctl) {
  
/* geometry structure for the B_GET_GEOMETRY opcode 
typedef struct {
	uint32	bytes_per_sector;		 sector size in bytes 
	uint32	sectors_per_track;		 # sectors per track 
	uint32	cylinder_count;			 # cylinders 
	uint32	head_count;				 # heads 
	uchar	device_type;			 type 
	bool	removable;				 non-zero if removable 
	bool	read_only;				 non-zero if read only
	bool	write_once;				 non-zero if write-once 
} device_geometry; */

  case B_GET_BIOS_GEOMETRY: 
       dprintf("(Get BIOS Geometry) >>>>\n");         /* Gets the BIOS settings. Not useful for a RAMDISK I think? Testing. */
  case B_GET_GEOMETRY: 
       dprintf("(Get Drive Geometry) >>>>\n");        /* Get real drive geometry. */
       dinfo = (device_geometry *) arg1;              /* Fills out the specified device_geometry structure to describe the device. */
       dinfo->bytes_per_sector = RAM_BLOCK_SIZE; 
       dinfo->sectors_per_track = RAM_SECTORS; 
       dinfo->cylinder_count = RAM_TRACKS; 
       dinfo->head_count = RAM_HEADS; 
       dinfo->device_type = B_DISK; 
       dinfo->removable = FALSE; 
       dinfo->read_only = FALSE; 
       dinfo->write_once = FALSE;
       return B_OK;                                   /* Function supported. Returns device geometry. */    

/* partition_info structure used by B_GET_PARTITION_INFO and B_SET_PARTITION 
    typedef struct {
	off_t	offset;					offset (in bytes) 
	off_t	size;					size (in bytes) 
	int32	logical_block_size;		logical block size of partition 
	int32	session;				id of session 
	int32	partition;				id of partition 
	char	device[256];			path to the physical device 
} partition_info; */

  case B_GET_PARTITION_INFO:
       dprintf("(Get Partition) >>>>\n"); 
       pinfo = (partition_info *) arg1;           /* Returns a partition_info structure for the device. */
       dprintf("pinfo->offset = %ld >>>>\n",       (long)pinfo->offset);
       dprintf("pinfo->size = %ld >>>>\n",         (long)pinfo->size);
       dprintf("pinfo->logical_block_size = %ld >>>>\n", pinfo->logical_block_size );
       dprintf("pinfo->session = %ld >>>>\n",            pinfo->session);
       dprintf("pinfo->partition = %ld >>>>\n",          pinfo->partition);
       dprintf("pinfo->device = %s >>>>\n",              pinfo->device);
       return B_ERROR;                            /* Function is not presently supported. */

  case B_SET_PARTITION:
       dprintf("(Set Partition) >>>>\n");         /* Set a partition_info structure for the device. */
       pinfo = (partition_info *) arg1;
       dprintf("pinfo->offset = %ld >>>>\n",       (long)pinfo->offset);
       dprintf("pinfo->size = %ld >>>>\n",         (long)pinfo->size);
       dprintf("pinfo->logical_block_size = %ld >>>>\n", pinfo->logical_block_size );
       dprintf("pinfo->session = %ld >>>>\n",            pinfo->session);
       dprintf("pinfo->partition = %ld >>>>\n",          pinfo->partition);
       dprintf("pinfo->device = %s >>>>\n",              pinfo->device);
       return B_ERROR;                            /* Function is not presently supported. */

  case B_FORMAT_DEVICE: 
       dprintf("(Low-level Format) >>>>\n");      /* Low-Level formats the drive if boolean data is true, If it's false , <<<unclear>>> */ 
       if (!*((char *) arg1)) return B_NO_ERROR;  /* Boolean flag = false, do not format. */
       for (i=0; i<INDEXS; i++) {                   /* Boolean flag = true, do low-level format. */
           if (Buffer_Index[i] != NULL) {         /* Test if a buffer is allocated. */
              free(Buffer_Index[i]);              /* Free allocated buffer. */
              Buffer_Index[i] = NULL;             /* Clear allocation's index pointer. */
           } /* endif */
        } /* endfor */
        return B_OK;                              /* Function supported. */

  case B_GET_ICON: 
       dprintf("(B_GET_ICON)\n");                 /* Returns a ICON_info structure for the device. */
       dicon = (device_icon *) arg1;              /* Pointer to ICON_info structure. */
       switch (dicon->icon_size) {

       case B_LARGE_ICON: 
            dprintf("(LARGE) >>>>\n"); 
            memcpy(dicon->icon_data, icon_disk, B_LARGE_ICON * B_LARGE_ICON); 
            return B_OK;                          /* Function supported. Returns large icon image. */ 
       case B_MINI_ICON: 
            dprintf("(SMALL) >>>>\n"); 
            memcpy(dicon->icon_data, icon_disk_mini, B_MINI_ICON * B_MINI_ICON); 
            return B_OK;                          /* Function supported. Returns small icon image. */ 
       default:           
            dprintf("(ICON?) >>>>\n"); 
            memcpy(dicon->icon_data, icon_disk_mini, B_MINI_ICON * B_MINI_ICON); 
            return B_BAD_TYPE; }                  /* Unknown icon size, returns small icon image. */

  case B_GET_DEVICE_SIZE: 
       dprintf("(GET_DEVICE_SIZE) >>>>\n");       /* A size_t indicating the device size in bytes. */
       *(size_t*)arg1 = RAM_DRIVE_SIZE;           /* Returns a size_t indicating the device size in bytes. */
       return B_OK      ;                         /* Function supported. Signals valid drive size. */

  case B_SET_DEVICE_SIZE:
       dprintf("(SET_DEVICE_SIZE) >>>>\n");       /* A size_t indicating the device size in bytes. */
     //RAM_DRIVE_SIZE = arg1;                     /* Reads a size_t indicating the device size in bytes. */
       return B_NO_ERROR;                         /* Function is under test. */    

  case B_SET_NONBLOCKING_IO:
       dprintf("(SET_NONBLOCKING_IO) >>>>\n"); 
      //BLOCK_IO = FALSE;                         /* Disable device blocking */
       return B_ERROR;                            /* Function is not allowed. */    

  case B_SET_BLOCKING_IO:
       dprintf("(SET_BLOCKING_IO) >>>>\n"); 
       BLOCK_IO = TRUE;                           /* Enable device blocking */
       return B_NO_ERROR;                         /* Function is under test. */    

  case B_GET_READ_STATUS:
       dprintf("(GET_READ_STATUS) >>>>\n");       /* Returns true if the device can read without blocking, otherwise false. */
       *(size_t*)arg1 = FALSE;                    /* Return, needs blocking. */
       return B_NO_ERROR;                         /* Function is not presently supported. */    

  case B_GET_WRITE_STATUS: 
       dprintf("(Write Status) >>>>\n");          /* Returns true if the device can write without blocking, otherwise false. */
       *(size_t*)arg1 = FALSE;                    /* Return, needs blocking. */
       return B_NO_ERROR;                         /* Function is under test. */    

  case B_GET_MEDIA_STATUS: 
       dprintf("(Media Status) >>>>\n");          /* Gets the status of the media in the device */
       *(status_t*)arg1 = B_OK;                   /* by placing a status_t at the location pointed to. */ 
       return B_NO_ERROR;                         /* Function is under test. */

  case B_EJECT_DEVICE: 
       dprintf("(Eject Disk) >>>>\n");            /* Ejects the device. Not useful for a RAMDISK. */
       *(status_t*)arg1 = B_OK;                   /* by placing a status_t at the location pointed to. */ 
       return B_NO_ERROR;                         /* Function is under test. */

  case B_LOAD_MEDIA: 
       dprintf("(Load Media) >>>>\n");            /* Loads the media, if this is supported. */
       *(status_t*)arg1 = B_OK;                   /* Return a B_OK status_t at the location pointed to. */ 
       return B_NO_ERROR;                         /* Function is under test. */

  case B_FLUSH_DRIVE_CACHE: 
       dprintf("(Flush Cache) >>>>\n");           /* Flushes the drive's cache. Not useful for a RAMDISK. */
       *(status_t*)arg1 = B_OK;                   /* Return a B_OK status_t at the location pointed to. */ 
       return B_NO_ERROR;                         /* Function is under test. */

  case B_GET_DRIVER_FOR_DEVICE: 
       dprintf("(Get Driver Path) >>>>\n");       /* Returns the path of the driver executable handling the device. */
       return B_ERROR;                            /* Function is not presently supported. */

  case B_GET_BIOS_DRIVE_ID:         
       dprintf("(BIOS ID) >>>>\n");               /* Gets the BIOS settings. Not useful for a RAMDISK. */
       return B_ERROR;                            /* Function not supported. */

  case B_GET_NEXT_OPEN_DEVICE: 
       dprintf("(Next Open Device) >>>>\n");      /* ??? */
       return B_ERROR;                            /* Function not supported. */

  case B_ADD_FIXED_DRIVER: 
       dprintf("(Add fixed driver) >>>>\n");      /* Private Function. */
       return B_ERROR;                            /* Function not supported. */

  case B_REMOVE_FIXED_DRIVER: 
       dprintf("(Remove fixed driver) >>>>\n");   /* Private Function. */
       return B_ERROR;                            /* Function not supported. */

  case 10199:
       dprintf("(Special Call 10199 >>>>\n");      
       *(size_t*)arg1 = B_OK;                 
       return B_NO_ERROR;                         

  default: 
       dprintf("Driver Control(%ld) unknown\n", ioctl); /* No match found. */           
       *(status_t*)arg1 = B_OK;                   /* Return a B_OK status_t at the location pointed to. */ 
       return B_ERROR; /* Error for unknown function or unsupportted function. */ } }