//scrolling main window


#include "windowGuts.h"
#include "mainWindow.h"
#include <memory>
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButtonGadg.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myApp.h"

//ctor
MainWindow	::	MainWindow(	BRect			paramBound,
							const char *	ccpparamWindowTitle,
							const char *	ccpparamScrollViewName,
							const char *	ccpparamNamePrefFrame)
			: 
				WindowGuts(	paramBound, 
							ccpparamWindowTitle, 
							ccpparamScrollViewName,
							ccpparamNamePrefFrame),
				savePanel(NULL), 
				saveMessenger(NULL), 
				loadPanel(NULL), 
				loadMessenger(NULL), 
				fileBuffer(NULL)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning("Could not create_sem.\n");
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		BWindow bw(	BRect(0,0,1,1), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					B_WILL_ACCEPT_FIRST_CLICK);
		auto_ptr<LayoutMatrix> apLayoutMatrix(new LayoutMatrix(&bw, SAMESIZE, 1, 1));//rows,columns
		LayoutMatrix *	pholdLayoutMatrix = apLayoutMatrix.get();
		apLayoutMatrix.release();
		AddToLayoutMatrixList(pholdLayoutMatrix);
///////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> loadButtonMsg(new BMessage(SCROLL_LOAD));
		auto_ptr<MyButtonGadg> apLoadButton(new MyButtonGadg(	BRect(0, 20, 1, 1), 
																"localLoadButton", 
																"Load file which needs wrapping...", 
																loadButtonMsg.get(), 
																B_FOLLOW_NONE, 
																B_WILL_DRAW));
		loadButtonMsg.release();
		MyButtonGadg * pLoadButton = apLoadButton.get();
		apLoadButton.release();
		pLoadButton->SetFont(((MyApp *)be_app)->GetPreferredFont());
		pholdLayoutMatrix->AddToChildren((void *)pLoadButton);
		auto_ptr<LayoutMatrixItem> apLoadButtonLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pLoadButton, 
																			pholdLayoutMatrix->itemsList,
																			KIND_BBUTTON));
		LayoutMatrixItem * pLoadButtonLayoutMatrixItem = apLoadButtonLayoutMatrixItem.get();
		pLoadButtonLayoutMatrixItem->Calc(((MyApp *)be_app)->GetPreferredFont());
///////////////////////////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, true, calc_sem);
	}
	catch (...)
	{
		warning("caught debug\n");
		//release_sem(calc_sem);//when throwing
		//need to throw again, but don't know how, yet
	}
	BMenuItem *	menuItem;
	BMenu *		firstMenu = new BMenu("File");
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(ABOUT_MAINWINDOW));
		menuItem = new BMenuItem(	"about...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		return;
	}
	firstMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(SCROLL_LOAD));
		menuItem = new BMenuItem(	"Load file which needs word wrapping...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		return;
	}
	firstMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(SCROLL_PREFS));
		menuItem = new BMenuItem(	"Preferences...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		return;
	}
	firstMenu->AddItem(menuItem);
	pMenuBar->AddItem(firstMenu);
}//end


//dtor
MainWindow	::	~MainWindow() 
{
	delete savePanel;
	delete saveMessenger;
	delete loadPanel;
	delete loadMessenger;
	delete [] fileBuffer;
	((MyApp *)be_app)->pMainWindow = NULL;
}//end


void
MainWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_MAINWINDOW:	
		{
			warning("about main window\n");
		break;
		}
		case SCROLL_LOADFROMPANEL:	
		{
			entry_ref ref;
			if (pparamMessage->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t tdebug;
				if ((tdebug = file.InitCheck()) == B_NO_ERROR) 
				{
					if ((tdebug = file.GetSize(&fileSize)) == B_NO_ERROR) 
					{
						try 
						{
							fileBuffer = new char[fileSize];
							file.Read(fileBuffer, fileSize);
							uint32 anchor = 0, currentPos, testPos, i, j, wrapAt = 60;
							wrapAt = ((MyApp *)be_app)->GetPreferredWrapAt();
							bool needed = true, set, hasSpace, setCR;
							do 
							{
							   setCR = false;
							   hasSpace = false;
							   for (i = 0; i < wrapAt; i++) 
							   {
							      currentPos = anchor + i;
							      if (fileBuffer[currentPos] == '\n') 
							      {
							         anchor = currentPos + 1;
							         i = wrapAt;
							         setCR = true;
							      }
							      else 
							      {
							         if (fileBuffer[currentPos] == ' ') 
							         {
							            hasSpace = true;
							         }
							      }
							   }
							   if (!setCR) 
							   {
							      if (!hasSpace) 
							      {
							         anchor++;
							      }
							      else 
							      {
							         currentPos = anchor + wrapAt;
							         set = false;
							         for (j = 0; ((set == false) && (j < wrapAt)); j++) 
							         {
							            testPos = currentPos - j;
							            if (fileBuffer[testPos] == ' ') 
							            {
							               fileBuffer[testPos] = '\n';
							               anchor = testPos;
							               set = true;
							               j = wrapAt;/*may be redundant*/
							            }
							         }
							         if (!set) 
							         {
							         	anchor ++;
							         }
							      }
							   }
							   if (anchor > (fileSize - wrapAt)) 
							   {
							   		needed = false;
							   }
							} while (needed);
							if (!savePanel) 
							{
								try 
								{
									saveMessenger = new BMessenger(this);
								}
								catch (...) 
								{
									warning("New failed.\n");
									saveMessenger = NULL;
									return;
								}
								try 
								{
									savePanel = new BFilePanel(B_SAVE_PANEL, saveMessenger, NULL, B_FILE_NODE, false, new BMessage(SCROLL_SAVEFROMPANEL), NULL, false, true);
									savePanel->Show();
								}
								catch (...) 
								{
									warning("failMemory\n");
									savePanel = NULL;
									return;
								}
							}
							else 
							{
								savePanel->Show();
							}
						}
						catch (...) 
						{
							warning("failCharString\n");
						}
					}
					else 
					{
						warning("Incorrect GetSize\n");
					}
				}
				else 
				{
					warning("Incorrect InitCheck\n");
				}
			}
			else 
			{
				warning("Incorrect findref\n");
			}
		break;
		}
		case SCROLL_PREFS:
		{
			((MyApp *)be_app)->OpenPreferencesPanel();
		break;
		}
		case SCROLL_LOAD:
		{
			if (!loadPanel) 
			{
				try 
				{
					loadMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning("failMemory\n");
					loadMessenger = NULL;
					return;
				}
				try 
				{
					loadPanel = new BFilePanel(B_OPEN_PANEL, loadMessenger, NULL, B_FILE_NODE, false, new BMessage(SCROLL_LOADFROMPANEL), NULL, false, true);
					loadPanel->Show();
				}
				catch (...) 
				{
					warning("failMemory\n");
					loadPanel = NULL;
					return;
				}
			}
			else 
			{
				loadPanel->Show();
			}
		break;
		}
		case SCROLL_SAVEFROMPANEL: 
		{
			entry_ref ref;
			const char * fileName;
			if (pparamMessage->FindRef("directory", &ref) >= B_OK) 
			{ 
				if (pparamMessage->FindString("name", &fileName) >= B_OK) 
				{
					BFile file;
					BDirectory dir = BDirectory(&ref);
					status_t result = file.SetTo(&dir, fileName, B_WRITE_ONLY | B_CREATE_FILE | B_ERASE_FILE);
					if (result >= B_OK) 
					{
						if (fileSize == file.Write(fileBuffer, fileSize)) 
						{
							return;
						}
						else 
						{
							warning("write wrong size\n");
						}
					}
					else 
					{
						warning("Incorrect file.setto\n");
					}
				}
				else 
				{
					warning("Incorrect name\n");
				}
			}
			else 
			{
				warning("Incorrect dir\n");
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
MainWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	((MyApp *)be_app)->SetPreferredWordWrapWindowRect(frame);
	if (((MyApp *)be_app)->bPrefChangesMade)
	{
		((MyApp *)be_app)->bPrefChangesMade = false;
		be_app->PostMessage(REOPEN);
	}
	else
	{
		be_app->PostMessage(B_QUIT_REQUESTED);
	}
	return(WindowGuts::QuitRequested());
}//end