//functions of MyButtonGadgA unimplemented test bed

#include "myButtonGadgA.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myApp.h"
#include "warning.h"
#include "textItem.h"
#include "layoutMatrix.h"


MyButtonGadgA	::	~MyButtonGadgA() 
{
	delete mpLabelTextItem;
};//end


//ctor--just initialize
MyButtonGadgA	::	MyButtonGadgA(	const char *	cparamName, 
									BMessage *		pparamButtonMessage,
									uint32			ui32paramMode, 
									uint32			ui32paramFlags,
									TextItem *		pparamLabelTextItem) 
				: 
					BView(	BRect(0, 0, 10, 10), 
							cparamName, 
							ui32paramMode, 
							ui32paramFlags),
					BButton(	BRect(0, 0, 10, 10),
								cparamName,
								pparamLabelTextItem->text,
								pparamButtonMessage,
								B_FOLLOW_NONE, 
								B_WILL_DRAW),
					mpLabelTextItem(pparamLabelTextItem)
{
	BView::SetViewColor(B_TRANSPARENT_32_BIT);
	BButton::SetViewColor(B_TRANSPARENT_32_BIT);
	//pfColorFuncToUse = ((MyApp *)be_app)->SetPreferredHighColor;
}//end


void 
MyButtonGadgA	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	((MyApp *)be_app)->GetPreferredViewColor(&tempRgbColor);//needs its own prefs:(
	BView::SetHighColor(tempRgbColor);//note setting high to view
	((MyApp *)be_app)->GetPreferredLowColor(&tempRgbColor);
	BView::SetLowColor(tempRgbColor);
	((MyApp *)be_app)->GetPreferredHighColor(&tempRgbColor);
	BView::SetViewColor(tempRgbColor);//and view to high--just for test
}//end


void 
MyButtonGadgA	::	Draw(	BRect rect) 
{
	BView::Draw(rect);
	BView::SetPenSize(1);
	BView::MovePenTo(top, left);
	rgb_color	originalColor(BView::HighColor());
	rgb_color	newColor(originalColor);
	//tricks
	BView::DrawString(mpLabelTextItem->text);
	BView::SetHighColor(originalColor);
}//end


void 
MyButtonGadgA	::	MessageReceived(	BMessage * /*pparamMessage*/) 
{
	warning("finally\n");
}//end


TextItem *
MyButtonGadgA	::	GetTextItem(void)
{
	return mpLabelTextItem;
}//end



void
MyButtonGadgA	::	SetTop(	float fparamTop)
{
	top = fparamTop;
}//end


float
MyButtonGadgA	::	GetTop(	void)
{
	return top;
}//end


void
MyButtonGadgA	::	SetLeft(	float fparamLeft)
{
	left = fparamLeft;
}//end


float
MyButtonGadgA	::	GetLeft(	void)
{
	return left;
}//end