//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “Actions.h”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	A list of Actions to be handled by the Buff class.
	(see UBuffer.cpp for more details.)
*/
//====//====//====//====//====//====//====//====//====//====//

#ifndef ACTIONS_H
	#define ACTIONS_H

	enum YAction{
		A_UNHANDLED=0,
		A_NOTHING,

		A_FIRST_MOVE=512,
		A_MOVE_TOP,A_MOVE_BOTTOM,
		A_MOVE_UP,A_MOVE_DOWN,
		A_MOVE_LEFT,A_MOVE_RIGHT,
		A_PAGE_UP,A_PAGE_DOWN,
		A_START_LINE,A_END_LINE,
		A_MOVE_TO,
		A_LAST_MOVE,

		A_SCROLL_TOP,A_SCROLL_BOTTOM,
		A_SCROLL_UP,A_SCROLL_DOWN,

		A_DELETE_LEFT,A_DELETE_RIGHT,
		A_QUOTE_PASTE,
		A_FIND_BACK,A_FIND_FORWARD,
		A_FIND_DIALOG,A_ENTER_FIND_STRING,
		A_REPLACE_THIS,
		A_TRANSPOSE_CHARS,
		A_RECENTER_SCROLL,
		A_SCROLL_TOP_BLOCK,
		A_ESCAPE_CHAR,A_RAW_CHAR,
		A_START_DRAG,A_FINISH_DRAG,
		A_PREV_ERROR,
		A_NEXT_ERROR,
		A_RESET_ERROR,
		A_PREV_WINDOW,
		A_NEXT_WINDOW,
		A_MAKE,A_MAKE_RUN,

		A_SELECT_NONE,

		A_INDENT,A_UNDENT,
		A_QUOTE,A_UNQUOTE,

		A_UNDO,A_REDO,
		A_KILL_SELECTION,
		A_KILL_LINE,
		A_CUT_LINE,
		A_COPY_LINE,

		A_CTRL_CHAR3,
		A_CTRL_CHAR26,
		A_GOTO_LINEX,
		A_GOTO_LINEY,
		A_GOTO_PLACE,

		A_WORDWRAP_NOW,
		A_SAVE,A_SAVE_AS,

		A_NEW_BUFFER,A_DISCARD_BUFFER,A_REVERT_BUFFER,
		A_OPEN_PANEL,A_OPEN_SUFFIX,A_OPEN_SELECTION,

		A_BROWSE,A_LAUNCH,A_TERMHERE,

		A_NEXT_BUFF,A_PREV_BUFF,
		A_WINDOW_TO_FRONT,A_WINDOW_TO_BACK,
		A_WINDOW_ZOOM,A_NEW_WINDOW,

		A_SAVE_ALL,A_SAVE_CHANGED,

		A_FOLD,A_UNFOLD,A_FOLD_ALL,A_UNFOLD_ALL,

		A_SHOW_MSG,A_SPLIT_LINE,
		A_MAX_ACTION=4096
	};

#endif
