//
//	BeOS code for amp-0.7.6, (C) 1997 Andy Lo A Foe	 	
//

#include <MediaKit.h>
#include <KernelKit.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Converter.h"

#include "amp.h"
#include "transform.h"
#include "audioIO.h"
#include "audio.h"

#define END_OF_STREAM	'eost'

BSubscriber			*the_sub;			// Be Audio Subscriber
BDACStream			*the_stream;		// DAC stream
Converter			*converter;			// Converter class
char				streambuf[8192];	// Temporary buffer for stream
static	int			au_vol = 100;		// Audio level

//
// printout is copied from buffer.c for now.
// The next version will probably use ifdefs (ugly, but..)
//

void printout(void)
{
int j;

        if (nch==2)
                j=32 * 18 * 2;
        else
                j=32 * 18;

        if (A_WRITE_TO_FILE) {
#ifndef NO_BYTE_SWAPPING
        short *ptr = (short*) sample_buffer;
	int i = j;

                for (;i>=0;--i)
                        ptr[i] = ptr[i] << 8 | ptr[i] >> 8;
#endif

                fwrite(sample_buffer, sizeof(short), j, out_file);
        }

        if (A_AUDIO_PLAY) {
#ifdef OS_BeOS
				if (converter)
					converter->Write((char*)sample_buffer, j * sizeof(short));
#else
#ifdef LINUX_REALTIME
                rt_printout((short*) sample_buffer, j * sizeof(short));
#else /* LINUX_REALTIME */
                if (AUDIO_BUFFER_SIZE==0)
                        audioWrite((char*)sample_buffer, j * sizeof(short));
                else
                        audioBufferWrite((char*)sample_buffer, j * sizeof(short));
#endif /* LINUX_REALTIME */
#endif /* OS_BeOS */
        }
}

// Fake Buffer functions, just to keep the sources clean,
// buffer.c should not be included in the link process...

int AUDIO_BUFFER_SIZE;

int
audioBufferOpen(int frequency, int stereo, int volume)
{
	audioOpen(frequency, stereo, volume);
}


inline void
audioBufferWrite(char *buf,int bytes)
{
	audioWrite(buf, bytes);
}


void
audioBufferClose()
{
	audioClose();
}


bool stream_func(void *arg, char *buf, size_t count, void *header)
{
	bool result;
	if (converter)
	{
		result = converter->Read(streambuf, count);
		if (result) {
			short *b=(short *)streambuf;
			short *o=(short *)buf;
			for (int i=0; i < count/2; i++) {
   		   	 	int v=((int)b[i]*au_vol)/100 + o[i];
   	    	    o[i]=(v>32767) ? 32767 : ((v < -32767) ? -32767 : v);	
			}
		}
	} 	
	return result;
}


void audioOpen(int frequency, int stereo, int volume)
{
	the_sub = new BSubscriber("amp DAC writer");
	the_stream = new BDACStream();
	
	converter = new Converter(AUDIO_BUFFER_SIZE);
	
	the_sub->Subscribe(the_stream);
	
	the_stream->SetSamplingRate(44100);
	
	converter->SetInStream(frequency,stereo);
	
	
	// Set up volume
	if (volume != -1)
		audioSetVolume(volume);
		
	// Enter the stream
	the_sub->EnterStream(NULL, TRUE, NULL, stream_func, NULL, TRUE);
}


void audioSetVolume(int volume)
{
	if (volume > 128)	// This allows for a modest volume boost
		volume = 128;
	au_vol = volume;
}


void audioClose()
{
	converter->Done(TRUE);

	while (the_sub->IsInStream()) { //  Ugly, but it works ;-)
		snooze(50000);
	}
	the_sub->Unsubscribe();
	
    delete converter;
    converter = NULL;   
     
    delete the_sub;
    delete the_stream;
}


// audioWrite is called from the player thread

int audioWrite(char *buffer, int count)
{
  	if (converter)
  		converter->Write(buffer,count);
    return 0;
}

