
#ifndef __autil_string_map__
#define __autil_string_map__

#include <string>
#include <iostream>
#include <hash_map>
#include "hash_string.hh"

class StringMap {
private:
  typedef hash_map<string,string,hash_string<string> > Data;
  Data data;
public:
  typedef Data::const_iterator const_iterator;
  typedef const_iterator       iterator;
  typedef Data::value_type     value_type;

  StringMap();
  virtual ~StringMap();

  const_iterator begin() const;
  const_iterator end()   const;

  virtual bool insert(const string & key, const string & value);
  // note: insert will NOT overwrite an existing entry
  virtual bool replace(const string & key, const string & value);
  virtual bool remove(const string & key);
  const string & operator[] (const string & key) const {return lookup(key);}
  const string & lookup (const string & key) const;
  bool have(const string & key) const;

  void merge(const StringMap & other);

  virtual bool read_in_stream(istream &, char delim = '\n');
  virtual bool read_in_file(const string &);
  virtual bool read_in_string(const string &);

  virtual bool write_to_stream(ostream &) const;
  virtual bool write_to_file(const string &) const;
};

#endif
