/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.util.Random;
import kaffe.util.Ptr;

public class BigInteger
extends Number
implements Comparable {
    private static final long serialVersionUID = -8287574255936472291L;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private Ptr number;

    private static byte[] randBytes(int n, Random random) {
        if (n < 0) {
            throw new IllegalArgumentException("numBits < 0");
        }
        int n2 = n % 8;
        byte[] byArray = new byte[n / 8 + (n2 > 0 ? 1 : 0)];
        random.nextBytes(byArray);
        if (n2 > 0) {
            byArray[0] = (byte)(byArray[0] & ~(-1 << 8 - n2));
        }
        return byArray;
    }

    public static BigInteger valueOf(long l) {
        return new BigInteger(l);
    }

    public BigInteger add(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.add0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger subtract(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.sub0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger multiply(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.mul0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger divide(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.div0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger remainder(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.rem0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        BigInteger bigInteger3 = new BigInteger();
        BigInteger.divrem0(bigInteger2, bigInteger3, this, bigInteger);
        return new BigInteger[]{bigInteger2, bigInteger3};
    }

    public BigInteger pow(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.pow0(this, n);
        return bigInteger;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.gcd0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger abs() {
        BigInteger bigInteger = new BigInteger();
        bigInteger.abs0(this);
        return bigInteger;
    }

    public BigInteger negate() {
        BigInteger bigInteger = new BigInteger();
        bigInteger.neg0(this);
        return bigInteger;
    }

    public int signum() {
        return this.compareTo(ZERO);
    }

    public BigInteger mod(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.mod0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = new BigInteger();
        bigInteger3.modpow0(this, bigInteger, bigInteger2);
        return bigInteger3;
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.modinv0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger shiftLeft(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(bigInteger, n);
        bigInteger.mul0(this, bigInteger);
        return bigInteger;
    }

    public BigInteger shiftRight(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(bigInteger, n);
        bigInteger.div0(this, bigInteger);
        return bigInteger;
    }

    public BigInteger and(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.and0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger or(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.or0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger xor(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.xor0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger not() {
        BigInteger bigInteger = new BigInteger();
        bigInteger.not0(this);
        return bigInteger;
    }

    public BigInteger andNot(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.and0(this, bigInteger);
        bigInteger2.not0(bigInteger2);
        return bigInteger2;
    }

    public boolean testBit(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(this, n);
        return BigInteger.cmp0(bigInteger, this) == 0;
    }

    public BigInteger setBit(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(this, n);
        return bigInteger;
    }

    public BigInteger clearBit(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.clrbit0(this, n);
        return bigInteger;
    }

    public BigInteger flipBit(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(bigInteger, n);
        bigInteger.xor0(bigInteger, this);
        return bigInteger;
    }

    public int getLowestSetBit() {
        return this.scansetbit0();
    }

    public int bitLength() {
        return this.bitLength0();
    }

    public int bitCount() {
        if (this.compareTo(ZERO) < 0) {
            return this.negate().hamDist0(ZERO);
        }
        return this.hamDist0(ZERO);
    }

    public boolean isProbablePrime(int n) {
        return this.probablyPrime0(n) != 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((BigInteger)object);
    }

    public int compareTo(BigInteger bigInteger) {
        int n = BigInteger.cmp0(this, bigInteger);
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public boolean equals(Object object) {
        return object instanceof BigInteger && this.compareTo((BigInteger)object) == 0;
    }

    public BigInteger min(BigInteger bigInteger) {
        int n = this.compareTo(bigInteger);
        if (n > 0) {
            return bigInteger;
        }
        return this;
    }

    public BigInteger max(BigInteger bigInteger) {
        int n = this.compareTo(bigInteger);
        if (n < 0) {
            return bigInteger;
        }
        return this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString(int n) {
        return this.toString0(n);
    }

    public String toString() {
        return this.toString(10);
    }

    public byte[] toByteArray() {
        int n;
        byte[] byArray = new byte[1 + this.bitLength0() / 8];
        BigInteger bigInteger = this.abs();
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.setbit0(bigInteger2, 32);
        int n2 = BigInteger.cmp0(this, ZERO);
        if (n2 < 0) {
            this.sub0(bigInteger, ONE);
        }
        int n3 = byArray.length;
        while (n3 > 4) {
            n = bigInteger.toInt0();
            byArray[--n3] = (byte)n;
            byArray[--n3] = (byte)(n >> 8);
            byArray[--n3] = (byte)(n >> 16);
            byArray[--n3] = (byte)(n >> 24);
            this.div0(bigInteger, bigInteger2);
        }
        n = bigInteger.toInt0();
        switch (n3) {
            case 4: {
                byArray[--n3] = (byte)n;
                n >>= 8;
            }
            case 3: {
                byArray[--n3] = (byte)n;
                n >>= 8;
            }
            case 2: {
                byArray[--n3] = (byte)n;
                n >>= 8;
            }
            case 1: {
                byArray[--n3] = (byte)n;
            }
        }
        if (n2 < 0) {
            n3 = byArray.length;
            while (n3-- > 0) {
                byArray[n3] = ~byArray[n3];
            }
        }
        return byArray;
    }

    public int intValue() {
        return this.toInt0();
    }

    public long longValue() {
        return (long)this.toInt0() | (long)this.shiftRight(32).toInt0();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public double doubleValue() {
        return this.toDouble0();
    }

    protected void finalize() throws Throwable {
        this.finalize0();
        super.finalize();
    }

    private native void init0();

    private native void finalize0();

    private native void assignBytes0(int var1, byte[] var2);

    private native void assignString0(String var1, int var2);

    private native void assignLong0(long var1);

    private native void add0(BigInteger var1, BigInteger var2);

    private native void sub0(BigInteger var1, BigInteger var2);

    private native void mul0(BigInteger var1, BigInteger var2);

    private native void div0(BigInteger var1, BigInteger var2);

    private native void rem0(BigInteger var1, BigInteger var2);

    private native void abs0(BigInteger var1);

    private native void neg0(BigInteger var1);

    private native void pow0(BigInteger var1, int var2);

    private native void gcd0(BigInteger var1, BigInteger var2);

    private native void mod0(BigInteger var1, BigInteger var2);

    private native void modpow0(BigInteger var1, BigInteger var2, BigInteger var3);

    private native void modinv0(BigInteger var1, BigInteger var2);

    private native void and0(BigInteger var1, BigInteger var2);

    private native void or0(BigInteger var1, BigInteger var2);

    private native void xor0(BigInteger var1, BigInteger var2);

    private native void not0(BigInteger var1);

    private native void clrbit0(BigInteger var1, int var2);

    private native void setbit0(BigInteger var1, int var2);

    private native int scansetbit0();

    private native int probablyPrime0(int var1);

    private native int bitLength0();

    private native int hamDist0(BigInteger var1);

    private static native int cmp0(BigInteger var0, BigInteger var1);

    private static native void initialize0();

    private static native void divrem0(BigInteger var0, BigInteger var1, BigInteger var2, BigInteger var3);

    private native String toString0(int var1);

    private native double toDouble0();

    private native int toInt0();

    /* synthetic */ void access$0() {
        this.init0();
    }

    /* synthetic */ void access$1(int n, byte[] byArray) {
        this.assignBytes0(n, byArray);
    }

    public BigInteger(byte[] byArray) {
        this();
        int n;
        if (byArray.length == 0) {
            throw new NumberFormatException("val.length == 0");
        }
        int n2 = n = (byArray[0] & 0x80) == 0 ? 1 : -1;
        if (n == -1) {
            int n3 = byArray.length;
            while (n3-- > 0) {
                byArray[n3] = ~byArray[n3];
            }
        }
        this.assignBytes0(n, byArray);
        if (n == -1) {
            this.add0(this, ONE);
        }
    }

    public BigInteger(int n, byte[] byArray) {
        this();
        switch (n) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new NumberFormatException("signum < -1 || signum > 1");
            }
        }
        if (byArray.length != 0) {
            this.assignBytes0(n, byArray);
            if (n == 0 && BigInteger.cmp0(this, ZERO) != 0) {
                throw new NumberFormatException("signum == 0 && magnitude[i] != 0");
            }
        }
    }

    public BigInteger(String string, int n) {
        this();
        this.assignString0(string, n);
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(int n, Random random) {
        this(1, BigInteger.randBytes(n, random));
    }

    public BigInteger(int n, int n2, Random random) {
        this();
        if (n < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        byte[] byArray = new byte[(n + 7) / 8];
        int n3 = 8 - n % 8;
        byte by = (byte)(~(-1 << n3));
        byte by2 = (byte)(256 >> n3);
        BigInteger bigInteger = new BigInteger(2L);
        block0: while (true) {
            random.nextBytes(byArray);
            byArray[0] = (byte)(byArray[0] & by | by2);
            if (n > 2) {
                int n4 = byArray.length - 1;
                byArray[n4] = (byte)(byArray[n4] | 1);
            }
            this.assignBytes0(1, byArray);
            if (this.probablyPrime0(n2) == 1) break;
            long l = this.longValue() - 1L;
            if (n < 64) {
                l |= -1L << n;
            }
            do {
                this.add0(this, bigInteger);
                if ((l += 2L) == 0L && this.bitLength0() > n) continue block0;
            } while (this.probablyPrime0(n2) == 0);
            break;
        }
    }

    private BigInteger(long l) {
        this();
        this.assignLong0(l);
    }

    private BigInteger() {
        this.init0();
    }

    static {
        System.loadLibrary("math");
        BigInteger.initialize0();
        ZERO = new BigInteger();
        ONE = new BigInteger(1L);
    }

    class DefaultSerialization {
        private int bitCount;
        private int bitLength;
        private int firstNonzeroByteNum;
        private int lowestSetBit;
        private int signum;
        private byte[] magnitude;

        private void readDefaultObject() {
            BigInteger.this.access$0();
            BigInteger.this.access$1(this.signum, this.magnitude);
        }

        private void writeDefaultObject() {
            this.bitCount = -1;
            this.bitLength = -1;
            this.firstNonzeroByteNum = -2;
            this.lowestSetBit = BigInteger.this.getLowestSetBit();
            this.signum = BigInteger.this.signum();
            this.magnitude = BigInteger.this.toByteArray();
        }

        DefaultSerialization() {
        }
    }
}

