/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Random;

public class SecureRandom
extends Random {
    static final String ENGINE_CLASS = "SecureRandom";
    private final Provider provider;
    private final SecureRandomSpi engine;

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        Security.Engine engine = Security.getCryptInstance(ENGINE_CLASS, string);
        return new SecureRandom((SecureRandomSpi)engine.engine, engine.provider);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Security.Engine engine = Security.getCryptInstance(ENGINE_CLASS, string, string2);
        return new SecureRandom((SecureRandomSpi)engine.engine, engine.provider);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void setSeed(byte[] byArray) {
        if (this.engine != null) {
            this.engine.engineSetSeed(byArray);
        }
    }

    public void setSeed(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(l >> n * 8);
            ++n;
        }
        this.setSeed(byArray);
    }

    public void nextBytes(byte[] byArray) {
        this.engine.engineNextBytes(byArray);
    }

    protected final int next(int n) {
        byte[] byArray = new byte[(n + 7) / 8];
        this.nextBytes(byArray);
        return byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000 | byArray[3] << 24 & 0xFF000000;
    }

    public static byte[] getSeed(int n) {
        return SecureRandom.getSeed(n);
    }

    public byte[] generateSeed(int n) {
        return this.engine.engineGenerateSeed(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SecureRandom() {
        try {
            Security.Engine engine = Security.getCryptInstance(ENGINE_CLASS);
            this.provider = engine.provider;
            this.engine = (SecureRandomSpi)engine.engine;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("no " + ENGINE_CLASS + " found");
        }
    }

    public SecureRandom(byte[] byArray) {
        this();
        this.setSeed(byArray);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this.engine = secureRandomSpi;
        this.provider = provider;
    }
}

