/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractListIterator;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final Comparator REVERSE_COMPARATOR = new 1();

    public static void sort(List list) {
        Collections.sort(list, Arrays.DEFAULT_COMPARATOR);
    }

    public static void sort(List list, Comparator comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        int n = objectArray.length - 1;
        while (n >= 0) {
            list.set(n, objectArray[n]);
            --n;
        }
    }

    public static int binarySearch(List list, Object object) {
        return Collections.binarySearch(list, object, Arrays.DEFAULT_COMPARATOR);
    }

    public static int binarySearch(List list, Object object, Comparator comparator) {
        if (list instanceof AbstractSequentialList) {
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                if (comparator.compare(iterator.next(), object) == 0) {
                    return n;
                }
                ++n;
            }
            return ~n;
        }
        return Arrays.binarySearch(list.toArray(), object, comparator);
    }

    public static void reverse(List list) {
        ListIterator listIterator = list.listIterator(0);
        ListIterator listIterator2 = list.listIterator(list.size());
        int n = list.size() / 2;
        while (n > 0) {
            Object object = listIterator.next();
            Object object2 = listIterator2.previous();
            listIterator.set(object2);
            listIterator2.set(object);
            --n;
        }
    }

    public static void shuffle(List list) {
        Collections.shuffle(list, new Random());
    }

    public static void shuffle(List list, Random random) {
        ListIterator listIterator = list.listIterator(list.size());
        int n = list.size() - 1;
        while (n > 1) {
            int n2 = random.nextInt(n + 1);
            Object object = listIterator.previous();
            if (n2 != n) {
                Object object2 = list.get(n2);
                list.set(n2, object);
                list.set(n, object2);
            }
            --n;
        }
    }

    public static void fill(List list, Object object) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
            listIterator.set(object);
        }
    }

    public static void copy(List list, List list2) {
        if (list.size() < list2.size()) {
            throw new IndexOutOfBoundsException();
        }
        ListIterator listIterator = list.listIterator();
        ListIterator listIterator2 = list2.listIterator();
        while (listIterator2.hasNext()) {
            listIterator.next();
            listIterator.set(listIterator2.next());
        }
    }

    public static Object min(Collection collection) {
        return Collections.min(collection, Arrays.DEFAULT_COMPARATOR);
    }

    public static Object min(Collection collection, Comparator comparator) {
        if (collection.size() == 0) {
            throw new NoSuchElementException();
        }
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (comparator.compare(object2, object) >= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Object max(Collection collection) {
        return Collections.max(collection, Arrays.DEFAULT_COMPARATOR);
    }

    public static Object max(Collection collection, Comparator comparator) {
        if (collection.size() == 0) {
            throw new NoSuchElementException();
        }
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (comparator.compare(object2, object) <= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return new UMCollection(collection);
    }

    public static Set unmodifiableSet(Set set) {
        return new UMSet(set);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet sortedSet) {
        return new UMSortedSet(sortedSet);
    }

    public static List unmodifiableList(List list) {
        return new UMList(list);
    }

    public static Map unmodifiableMap(Map map) {
        return new UMMap(map);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap sortedMap) {
        return new UMSortedMap(sortedMap);
    }

    public static Collection synchronizedCollection(Collection collection) {
        return new SyncCollection(collection);
    }

    public static Set synchronizedSet(Set set) {
        return new SyncSet(set);
    }

    public static SortedSet synchronizedSortedSet(SortedSet sortedSet) {
        return new SyncSortedSet(sortedSet);
    }

    public static List synchronizedList(List list) {
        return new SyncList(list);
    }

    public static Map synchronizedMap(Map map) {
        return new SyncMap(map);
    }

    public static SortedMap synchronizedSortedMap(SortedMap sortedMap) {
        return new SyncSortedMap(sortedMap);
    }

    public static Set singleton(Object object) {
        return new AbstractSet(object){
            private final /* synthetic */ Object val$o;
            private final Object object;

            public int size() {
                return 1;
            }

            public Iterator iterator() {
                return Collections.nCopies(1, this.val$o).iterator();
            }
            {
                this.object = this.val$o = object;
                this.constructor$0();
            }

            public void constructor$0() {
            }
        };
    }

    public static List singletonList(Object object) {
        return new CopyList(1, object);
    }

    public static Map singletonMap(Object object, Object object2) {
        HashMap hashMap = new HashMap(1);
        hashMap.put(object, object2);
        return Collections.unmodifiableMap(hashMap);
    }

    public static List nCopies(int n, Object object) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return EMPTY_LIST;
        }
        return new CopyList(n, object);
    }

    public static Comparator reverseOrder() {
        return REVERSE_COMPARATOR;
    }

    public static Enumeration enumeration(Collection collection) {
        return new Enumeration(collection){
            private final /* synthetic */ Collection val$c;
            private final Iterator i;

            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            public Object nextElement() {
                return this.i.next();
            }
            {
                this.val$c = collection;
                this.i = this.val$c.iterator();
                this.constructor$0();
            }

            public void constructor$0() {
            }
        };
    }

    private Collections() {
    }

    private static class EmptySet
    extends AbstractSet
    implements Serializable {
        public int size() {
            return 0;
        }

        public Iterator iterator() {
            EmptySet emptySet = this;
            if (emptySet == null) {
                throw null;
            }
            return new Iterator(emptySet){
                private final /* synthetic */ EmptySet this$0;

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new IllegalStateException();
                }
                {
                    this.this$0 = emptySet;
                    this.constructor$0(emptySet);
                }

                public void constructor$0(EmptySet emptySet) {
                }
            };
        }

        EmptySet() {
        }
    }

    private static class EmptyList
    extends AbstractList
    implements Serializable {
        public int size() {
            return 0;
        }

        public Object get(int n) {
            throw new IndexOutOfBoundsException();
        }

        EmptyList() {
        }
    }

    private static class EmptyMap
    extends AbstractMap
    implements Serializable {
        public Set entrySet() {
            return EMPTY_SET;
        }

        EmptyMap() {
        }
    }

    private static class CopyList
    extends AbstractList
    implements Serializable {
        private final Object o;
        private final int num;

        public int size() {
            return this.num;
        }

        public Object get(int n) {
            if (n < 0 || n >= this.num) {
                throw new IndexOutOfBoundsException();
            }
            return this.o;
        }

        public int indexOf(Object object) {
            boolean bl = this.o == null ? object == null : this.o.equals(object);
            if (bl) {
                return 0;
            }
            return -1;
        }

        public int lastIndexOf(Object object) {
            boolean bl = this.o == null ? object == null : this.o.equals(object);
            if (bl) {
                return this.num - 1;
            }
            return -1;
        }

        public ListIterator listIterator(int n) {
            if (n < 0 || n > this.num) {
                throw new IndexOutOfBoundsException();
            }
            return new AbstractListIterator(this, this.num - n);
        }

        public List subList(int n, int n2) {
            if (n < 0 || n2 > this.num) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            return Collections.nCopies(n2 - n, this.o);
        }

        CopyList(int n, Object object) {
            this.num = n;
            this.o = object;
        }
    }

    private static class SyncCollection
    implements Collection,
    Serializable {
        protected final Collection c;

        public synchronized int size() {
            return this.c.size();
        }

        public synchronized boolean isEmpty() {
            return this.c.isEmpty();
        }

        public synchronized boolean contains(Object object) {
            return this.c.contains(object);
        }

        public synchronized Iterator iterator() {
            return this.c.iterator();
        }

        public synchronized Object[] toArray() {
            return this.c.toArray();
        }

        public synchronized Object[] toArray(Object[] objectArray) {
            return this.c.toArray(objectArray);
        }

        public synchronized boolean add(Object object) {
            return this.c.add(object);
        }

        public synchronized boolean remove(Object object) {
            return this.c.remove(object);
        }

        public synchronized boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        public synchronized boolean addAll(Collection collection) {
            return this.c.addAll(collection);
        }

        public synchronized boolean removeAll(Collection collection) {
            return this.c.removeAll(collection);
        }

        public synchronized boolean retainAll(Collection collection) {
            return this.c.retainAll(collection);
        }

        public synchronized void clear() {
            this.c.clear();
        }

        public synchronized boolean equals(Object object) {
            return this.c.equals(object);
        }

        public synchronized int hashCode() {
            return this.c.hashCode();
        }

        SyncCollection(Collection collection) {
            this.c = collection;
        }
    }

    private static class SyncSet
    extends SyncCollection
    implements Set,
    Serializable {
        SyncSet(Set set) {
            super(set);
        }
    }

    private static class SyncSortedSet
    extends SyncSet
    implements SortedSet,
    Serializable {
        public synchronized Comparator comparator() {
            return ((SortedSet)this.c).comparator();
        }

        public synchronized SortedSet subSet(Object object, Object object2) {
            return ((SortedSet)this.c).subSet(object, object2);
        }

        public synchronized SortedSet headSet(Object object) {
            return ((SortedSet)this.c).headSet(object);
        }

        public synchronized SortedSet tailSet(Object object) {
            return ((SortedSet)this.c).tailSet(object);
        }

        public synchronized Object first() {
            return ((SortedSet)this.c).first();
        }

        public synchronized Object last() {
            return ((SortedSet)this.c).last();
        }

        SyncSortedSet(SortedSet sortedSet) {
            super(sortedSet);
        }
    }

    private static class SyncList
    extends SyncCollection
    implements List,
    Serializable {
        public synchronized void add(int n, Object object) {
            ((List)this.c).add(n, object);
        }

        public synchronized boolean addAll(int n, Collection collection) {
            return ((List)this.c).addAll(n, collection);
        }

        public synchronized Object get(int n) {
            return ((List)this.c).get(n);
        }

        public synchronized int indexOf(Object object) {
            return ((List)this.c).indexOf(object);
        }

        public synchronized int lastIndexOf(Object object) {
            return ((List)this.c).lastIndexOf(object);
        }

        public synchronized ListIterator listIterator() {
            return ((List)this.c).listIterator();
        }

        public synchronized ListIterator listIterator(int n) {
            return ((List)this.c).listIterator(n);
        }

        public synchronized Object remove(int n) {
            return ((List)this.c).remove(n);
        }

        public synchronized Object set(int n, Object object) {
            return ((List)this.c).set(n, object);
        }

        public synchronized List subList(int n, int n2) {
            return ((List)this.c).subList(n, n2);
        }

        SyncList(List list) {
            super(list);
        }
    }

    private static class SyncMap
    implements Map,
    Serializable {
        protected final Map m;

        public synchronized int size() {
            return this.m.size();
        }

        public synchronized boolean isEmpty() {
            return this.m.isEmpty();
        }

        public synchronized boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        public synchronized boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        public synchronized Object get(Object object) {
            return this.m.get(object);
        }

        public synchronized Object put(Object object, Object object2) {
            return this.m.put(object, object2);
        }

        public synchronized void putAll(Map map) {
            this.m.putAll(map);
        }

        public synchronized void clear() {
            this.m.clear();
        }

        public synchronized Set keySet() {
            return this.m.keySet();
        }

        public synchronized Set entrySet() {
            return this.m.entrySet();
        }

        public synchronized Collection values() {
            return this.m.values();
        }

        public synchronized boolean equals(Object object) {
            return this.m.equals(object);
        }

        public synchronized int hashCode() {
            return this.m.hashCode();
        }

        public synchronized Object remove(Object object) {
            return this.m.remove(object);
        }

        SyncMap(Map map) {
            this.m = map;
        }
    }

    private static class SyncSortedMap
    extends SyncMap
    implements SortedMap,
    Serializable {
        public synchronized Comparator comparator() {
            return ((SortedMap)this.m).comparator();
        }

        public synchronized SortedMap subMap(Object object, Object object2) {
            return ((SortedMap)this.m).subMap(object, object2);
        }

        public synchronized SortedMap headMap(Object object) {
            return ((SortedMap)this.m).headMap(object);
        }

        public synchronized SortedMap tailMap(Object object) {
            return ((SortedMap)this.m).tailMap(object);
        }

        public synchronized Object firstKey() {
            return ((SortedMap)this.m).firstKey();
        }

        public synchronized Object lastKey() {
            return ((SortedMap)this.m).lastKey();
        }

        SyncSortedMap(SortedMap sortedMap) {
            super(sortedMap);
        }
    }

    private static class UMCollection
    implements Collection,
    Serializable {
        protected final Collection c;

        public int size() {
            return this.c.size();
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        public Iterator iterator() {
            return new UMIterator(this.c.iterator());
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.c.toArray(objectArray);
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            return this.c.equals(object);
        }

        public int hashCode() {
            return this.c.hashCode();
        }

        UMCollection(Collection collection) {
            this.c = collection;
        }
    }

    private static class UMSet
    extends UMCollection
    implements Set,
    Serializable {
        UMSet(Set set) {
            super(set);
        }
    }

    private static class UMSortedSet
    extends UMSet
    implements SortedSet,
    Serializable {
        public Comparator comparator() {
            return ((SortedSet)this.c).comparator();
        }

        public SortedSet subSet(Object object, Object object2) {
            return new UMSortedSet(((SortedSet)this.c).subSet(object, object2));
        }

        public SortedSet headSet(Object object) {
            return new UMSortedSet(((SortedSet)this.c).headSet(object));
        }

        public SortedSet tailSet(Object object) {
            return new UMSortedSet(((SortedSet)this.c).tailSet(object));
        }

        public Object first() {
            return ((SortedSet)this.c).first();
        }

        public Object last() {
            return ((SortedSet)this.c).last();
        }

        UMSortedSet(SortedSet sortedSet) {
            super(sortedSet);
        }
    }

    public static class UMList
    extends UMCollection
    implements List,
    Serializable {
        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public Object get(int n) {
            return ((List)this.c).get(n);
        }

        public int indexOf(Object object) {
            return ((List)this.c).indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return ((List)this.c).lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return new UMListIterator(((List)this.c).listIterator());
        }

        public ListIterator listIterator(int n) {
            return new UMListIterator(((List)this.c).listIterator(n));
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public List subList(int n, int n2) {
            return new UMList(((List)this.c).subList(n, n2));
        }

        UMList(List list) {
            super(list);
        }
    }

    private static class UMMap
    implements Map,
    Serializable {
        protected final Map m;

        public int size() {
            return this.m.size();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        public Object get(Object object) {
            return this.m.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            return new UMSet(this.m.keySet());
        }

        public Set entrySet() {
            return new UMSet(this.m.entrySet());
        }

        public Collection values() {
            return new UMCollection(this.m.values());
        }

        public boolean equals(Object object) {
            return this.m.equals(object);
        }

        public int hashCode() {
            return this.m.hashCode();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        UMMap(Map map) {
            this.m = map;
        }
    }

    private static class UMSortedMap
    extends UMMap
    implements SortedMap,
    Serializable {
        public Comparator comparator() {
            return ((SortedMap)this.m).comparator();
        }

        public SortedMap subMap(Object object, Object object2) {
            return new UMSortedMap(((SortedMap)this.m).subMap(object, object2));
        }

        public SortedMap headMap(Object object) {
            return new UMSortedMap(((SortedMap)this.m).headMap(object));
        }

        public SortedMap tailMap(Object object) {
            return new UMSortedMap(((SortedMap)this.m).tailMap(object));
        }

        public Object firstKey() {
            return ((SortedMap)this.m).firstKey();
        }

        public Object lastKey() {
            return ((SortedMap)this.m).lastKey();
        }

        UMSortedMap(SortedMap sortedMap) {
            super(sortedMap);
        }
    }

    private static class UMIterator
    implements Iterator {
        protected final Iterator i;

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return this.i.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        UMIterator(Iterator iterator) {
            this.i = iterator;
        }
    }

    private static class UMListIterator
    extends UMIterator
    implements ListIterator {
        public boolean hasPrevious() {
            return ((ListIterator)this.i).hasPrevious();
        }

        public Object previous() {
            return ((ListIterator)this.i).previous();
        }

        public int nextIndex() {
            return ((ListIterator)this.i).nextIndex();
        }

        public int previousIndex() {
            return ((ListIterator)this.i).previousIndex();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        UMListIterator(ListIterator listIterator) {
            super(listIterator);
        }
    }
}

