/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import kaffe.io.ByteToCharDefault;
import kaffe.io.ConverterAlias;
import kaffe.util.Assert;

public abstract class ByteToCharConverter {
    private static String encodingRoot;
    private static String encodingDefault;
    private static ByteToCharConverter defaultConverter;
    private static Hashtable cache;
    private static Object noConverter;
    protected byte[] buf;
    protected int blen;

    void carry(byte[] byArray, int n, int n2) {
        int n3 = this.blen + n2;
        Assert.that(this.blen == 0);
        if (this.buf == null) {
            int n4 = n2 < 128 ? 128 : n2;
            this.buf = new byte[n4];
        } else if (n3 > this.buf.length) {
            int n5 = this.buf.length * 2;
            while (n5 < n3) {
                n5 *= 2;
            }
            byte[] byArray2 = new byte[n5];
            System.arraycopy(this.buf, 0, byArray2, 0, this.blen);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.blen, n2);
        this.blen = n3;
    }

    public abstract int convert(byte[] var1, int var2, int var3, char[] var4, int var5, int var6);

    public int flush(char[] cArray, int n, int n2) {
        if (this.blen == 0) {
            return 0;
        }
        int n3 = this.blen;
        this.blen = 0;
        return this.convert(this.buf, 0, n3, cArray, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ByteToCharConverter getConverterInternal(String string) {
        Object object = cache.get(string);
        if (object == noConverter) {
            return null;
        }
        if (object != null) {
            return (ByteToCharConverter)object;
        }
        String string2 = encodingRoot + ".ByteToChar" + ConverterAlias.alias(string);
        try {
            object = Class.forName(string2).newInstance();
            cache.put(string, object);
            return (ByteToCharConverter)object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(string2.replace('.', '/') + ".ser");
                if (inputStream != null) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    object = objectInputStream.readObject();
                    objectInputStream.close();
                    cache.put(string, object);
                    return (ByteToCharConverter)object;
                }
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException2) {
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        cache.put(string, noConverter);
        return null;
    }

    public static ByteToCharConverter getConverter(String string) throws UnsupportedEncodingException {
        ByteToCharConverter byteToCharConverter = ByteToCharConverter.getConverterInternal(string);
        if (byteToCharConverter != null) {
            return byteToCharConverter;
        }
        throw new UnsupportedEncodingException(string);
    }

    public static ByteToCharConverter getDefault() {
        ByteToCharConverter byteToCharConverter = ByteToCharConverter.getConverterInternal(encodingDefault);
        if (byteToCharConverter == null) {
            byteToCharConverter = defaultConverter;
        }
        return byteToCharConverter;
    }

    public abstract int getNumberOfChars(byte[] var1, int var2, int var3);

    static {
        defaultConverter = new ByteToCharDefault();
        cache = new Hashtable();
        noConverter = new Object();
        encodingRoot = "kaffe.io";
        encodingDefault = System.getProperty("file.encoding");
    }
}

