// LayoutDefs.h
// e.moon 21may99
//
// Display constants for MediaRoutingView and friends.
//
// HISTORY
//   21may99	e.moon -- created as part of simplifying &
//						optimizing the MediaRoutingView.  The
//            LiveNodeView no longer needs to provide
//            positioning info (the 'jack rectangle'.)

#ifndef __LAYOUTDEFS_H__
#define __LAYOUTDEFS_H__

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

// *** grid layout ***

static const float	NODE_COLUMN_WIDTH 		= 120.0;
static const float	GUTTER_COLUMN_WIDTH		= 18.0;
static const float  GUTTER_COLUMN_IN			= 4.0;
static const float	GUTTER_COLUMN_OUT			= GUTTER_COLUMN_WIDTH-6.0;
static const float	V_UNIT								= 4.0;
static const float	NODE_ROW_HEIGHT				= V_UNIT * 6;
static const float	GUTTER_ROW_HEIGHT			= V_UNIT * 2;

static const float	WIRE_THICKNESS				= 2.0;

static const float	JACK_DRAG_OUTLINE_LEFT_OFFSET			= 4.0;
static const float	JACK_DRAG_OUTLINE_RIGHT_OFFSET		= 6.0;
static const float	JACK_DRAG_OUTLINE_TOP_OFFSET			= 5.0;
static const float	JACK_DRAG_OUTLINE_BOTTOM_OFFSET		= 6.0;

static const float	JACK_DRAG_OUTLINE_THICKNESS	= 3.0;

// *** cell-view layout ***

static const float	NAME_PAD_X						= 3;
static const float	NAME_PAD_Y						= V_UNIT/2;

static const float	JACK_PAD_Y						= V_UNIT / 2;

static const float	JACK_WIDTH						= 7;
static const float	JACK_HEIGHT						= V_UNIT * 2;
	
static const float	JACK_TIP_OFFSET_X			= 2.0;
static const float	JACK_TIP_OFFSET_Y			= -4.0;

// *** child-cell layout ***

static const float	TRANSPORT_ICON_WIDTH			= 12.0;
static const float	TRANSPORT_ICON_HEIGHT			= 8.0;
static const float	TRANSPORT_ICON_PAD_LEFT		= 4.0;

__END_CORTEX_NAMESPACE
#endif /* __LAYOUTDEFS_H__ */
