// MediaRoutingContainerView.h
// e.moon 7may99
//
// PURPOSE
//   Replaces the standard GridView container BView;
//   draws extra adornments, but doesn't have much in
//   the way of real functionality.
//
// HISTORY
//   e.moon 7may99: created

#ifndef __MEDIAROUTINGCONTAINERVIEW_H__
#define __MEDIAROUTINGCONTAINERVIEW_H__

#include <View.h>
#include "Wire.h"

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class MediaRoutingView;

class MediaRoutingContainerView :
	public		BView {
	typedef	BView _inherited;
	
public:					// ctor/dtor/accessors
	virtual ~MediaRoutingContainerView();
	MediaRoutingContainerView(MediaRoutingView* routingView);

//	TipManager* tipManager() const;

public:					// BView impl
	// [e.moon 17oct99] handles TipManager a little more sanely
	virtual void AttachedToWindow();
	virtual void DetachedFromWindow();
	
	virtual void Draw(BRect updateRect);
	virtual void FrameResized(float width, float height);

	virtual void MouseDown(BPoint where);

protected:				// MouseDown helpers
	Wire* findWireAt(BPoint where);
	Wire* hitTestSegments(
		const list<WireSegment>& segments,
		BPoint where);

protected:				// members
	// top-level parent view (the routing view, containing
	// all the grid info this view needs to draw the backdrop)
	MediaRoutingView* 		m_routingView;
	
//	// the floating-tip manager
//	TipManager*						m_tipManager;

protected:				// presentation helpers
	void cacheColors();	
	
protected:				// colors
	rgb_color		m_nodeSlotColor;
	rgb_color		m_gutterColor;
};

__END_CORTEX_NAMESPACE
#endif /* __MEDIAROUTINGCONTAINERVIEW_H__ */