// cortex_defs.h
// * PURPOSE
//   Preprocessor stuff for the Cortex toolkit.
//
// * NOTES
//   To place the Cortex classes in a namespace of your
//   choosing, set the preprocessor variable CORTEX_CORTEX_NAMESPACE
//   to whatever string you want.
//
//   Message 'namespaces' are defined here as well.
//
// * HISTORY
//   e.moon		25jun99		Begun

#ifndef __cortex_defs_h__
#define __cortex_defs_h__

// *** default: no XML serialization support
#ifndef CORTEX_XML
	#define CORTEX_XML 0
#endif

// *** namespace support
#ifdef CORTEX_NAMESPACE
	#define __BEGIN_CORTEX_NAMESPACE namespace CORTEX_NAMESPACE {
	#define __END_CORTEX_NAMESPACE }
	#define __USE_CORTEX_NAMESPACE using namespace CORTEX_NAMESPACE;
	#define __CORTEX_NAMESPACE__ CORTEX_NAMESPACE::
#else
	#define CORTEX_NAMESPACE
	#define __BEGIN_CORTEX_NAMESPACE
	#define __END_CORTEX_NAMESPACE
	#define __USE_CORTEX_NAMESPACE
	#define __CORTEX_NAMESPACE__
#endif

// *** message 'what' code base values

// replaced by Observable aug99
// const uint32 Listenable_message_base				= 'Lis0';

const uint32 NodeManager_message_base				= 'NMaA';
const uint32 NodeManager_int_message_base		= 'Nm_A';
const uint32 NodeGroup_message_base					= 'NGrA';
const uint32 NodeRef_message_base						= 'NReA';
const uint32 NodeSyncThread_message_base		= 'NStA';

const uint32 RouteWindow_message_base				= 'RoWA';
const uint32 MediaRoutingView_message_base	= 'RoVA';
const uint32 GroupInspector_message_base		= 'IGrA';
const uint32 NodeInspector_message_base			= 'INoA';
const uint32 InspectorManager_message_base	= 'IMaA';

const uint32 ValControl_message_base				= 'VcnA';

const uint32 Observable_message_base				= 'ObTA';
const uint32 Observer_message_base					= 'Ob_A';

#endif /*__cortex_defs_h__*/
