#ifndef CONTROLVIEW_H
#define CONTROLVIEW_H


#include <TabView.h>


#define IDC_RENDERMODE              'renm'
#define IDC_TRANSPARENCY            'tran'
#define IDC_GROUND                  'grnd'
#define IDC_BACKGROUND              'back'
#define IDC_HITBOXES                'hitb'
#define IDC_BONES                   'bone'
#define IDC_ATTACHMENTS             'atch'

#define IDC_SEQUENCE                'sequ'
#define IDC_SPEEDSCALE              'sped'

#define IDC_BODYPART                'body'
#define IDC_SUBMODEL                'subm'
#define IDC_CONTROLLERVALUE         'cval'
#define IDC_CONTROLLER              'cntr'
#define IDC_SKINS                   'skns'

#define IDC_EXPORTTEXTURE           'extx'
#define IDC_TEXTURESCALE            'txsc'


class ControlView : public BTabView {
   BMenu *renderModeMenu;
   BCheckBox *cbGround;
   BCheckBox *cbBackground;
   BCheckBox *cbHitBoxes;
   BCheckBox *cbBones;
   BCheckBox *cbAttachments;
   BSlider *transparency;

   void CreateRenderTab(void);

   BMenu *sequenceMenu;
   BSlider *speed;

   void CreateSequenceTab(void);

   BMenu *controllerMenu;
   BSlider *controller;
   BMenu *bodypartsMenu;
   BMenu *submodelMenu;

   void CreateBodyTab(void);

   void CreateTextureTab(void);

   void setBodypart(int);
   void setBoneController(void);
   void setBoneControllerValue(void);
public:
   ControlView(BRect frame);

   virtual void AttachedToWindow(void);
   virtual void MessageReceived(BMessage *message);

   void initSequences(void);
   void initBodyparts(void);
   void initBoneControllers(void);

   void setShowBackground(bool status);
   void setShowGround(bool status);
};


#endif
