/* NeXT_obuffer.h

   Header file for NeXT output buffer. Copied from maplay 1.3b. */

/*
 *  @(#) obuffer_next.h 1.1, last edit: 27 Oct 1994 17:20:55
 *  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
 *  @(#) Berlin University of Technology
 *
 *  NeXTStep class written at the end of June 1994 by
 *  Pete French (pete@ohm.york.ac.uk) and Ian Stepehnson (ian@ohm.york.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef NEXT_OBUFFER_H
#define NEXT_OBUFFER_H

#ifdef NeXT

#include "args.h"
#include "obuffer.h"

const uint32 OBUFFERSIZE = 100000;      // Loads of buffering
#define MAX_QUEUE_LENGTH 10             // but never more than this
#define CAN_QUEUE 0
#define CANNOT_QUEUE 1
const uint32 MAXCHANNELS = 2;           // max. number of channels

class NeXTObuffer : public Obuffer
{
  int16  buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  static float sample_rate;
  static int chans;
  static void really_write_buffer(int16 **, int16 *);

public:
        NeXTObuffer (uint32 number_of_channels, MPEG_Args *maplay_args);
       ~NeXTObuffer (void);
  void  append (uint32 channel, int16 value);
  void  write_buffer (int dummy) {}     // not needed

#ifdef SEEK_STOP
  void NeXTObuffer::clear_buffer(void);

  void NeXTObuffer::set_stop_flag(void)
#endif // SEEK_STOP

  static BOOL class_suitable (uint32 number_of_channels);
};

#endif // NeXT

#endif // NEXT_OBUFFER_H

